/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticAccessMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class QualifiedNameReference
extends NameReference {
    public char[][] tokens;
    public FieldBinding[] otherBindings;
    public FieldBinding[] otherCodegenBindings;
    int[] otherDepths;
    public int indexOfFirstFieldBinding;
    SyntheticAccessMethodBinding syntheticWriteAccessor;
    SyntheticAccessMethodBinding[] syntheticReadAccessors;
    protected FieldBinding lastFieldBinding;

    public QualifiedNameReference(char[][] sources, int sourceStart, int sourceEnd) {
        this.tokens = sources;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        TypeBinding lastReceiverType;
        int otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                this.lastFieldBinding = (FieldBinding)this.binding;
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, this.actualReceiverType, 0, flowInfo);
                }
                if (!this.lastFieldBinding.isBlankFinal() || this.otherBindings == null || !currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) || flowInfo.isDefinitelyAssigned(this.lastFieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(this.lastFieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount - 1) {
                this.lastFieldBinding = this.otherBindings[i];
                boolean bl = needValue = !this.otherBindings[i + 1].isStatic();
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1, flowInfo);
                }
                ++i;
            }
            this.lastFieldBinding = this.otherBindings[otherBindingsCount - 1];
        }
        if (isCompound) {
            if (this.binding == this.lastFieldBinding && this.lastFieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) && !flowInfo.isDefinitelyAssigned(this.lastFieldBinding)) {
                currentScope.problemReporter().uninitializedBlankFinalField(this.lastFieldBinding, this);
            }
            lastReceiverType = this.lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
            this.manageSyntheticReadAccessIfNecessary(currentScope, this.lastFieldBinding, lastReceiverType, this.lastFieldBinding == this.binding ? 0 : otherBindingsCount, flowInfo);
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        if (this.lastFieldBinding.isFinal()) {
            if (this.lastFieldBinding.isBlankFinal() && !isCompound && currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding) && this.indexOfFirstFieldBinding == 1) {
                if (flowInfo.isPotentiallyAssigned(this.lastFieldBinding)) {
                    currentScope.problemReporter().duplicateInitializationOfBlankFinalField(this.lastFieldBinding, this);
                } else {
                    flowContext.recordSettingFinal(this.lastFieldBinding, this);
                }
                flowInfo.markAsDefinitelyAssigned(this.lastFieldBinding);
            } else {
                currentScope.problemReporter().cannotAssignToFinalField(this.lastFieldBinding, this);
                if (currentScope.allowBlankFinalFieldAssignment(this.lastFieldBinding)) {
                    flowInfo.markAsDefinitelyAssigned(this.lastFieldBinding);
                }
            }
        }
        lastReceiverType = this.lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
        this.manageSyntheticWriteAccessIfNecessary(currentScope, this.lastFieldBinding, lastReceiverType, flowInfo);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        int otherBindingsCount;
        int n = otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 ? valueRequired : !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding;
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, (FieldBinding)this.binding, this.actualReceiverType, 0, flowInfo);
                }
                if (!(fieldBinding = (FieldBinding)this.binding).isBlankFinal() || this.indexOfFirstFieldBinding != 1 || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                boolean bl = i < otherBindingsCount - 1 ? !this.otherBindings[i + 1].isStatic() : (needValue = valueRequired);
                if (needValue) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope, this.otherBindings[i], i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1, flowInfo);
                }
                ++i;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        MethodScope methodScope = scope.methodScope();
        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.fieldDeclarationIndex != -1 && fieldBinding.id >= methodScope.fieldDeclarationIndex && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
        }
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        return this.getOtherFieldBindings(scope);
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        this.generateReadSequence(currentScope, codeStream);
        assignment.expression.generateCode(currentScope, codeStream, true);
        this.fieldStore(codeStream, this.lastFieldBinding, this.syntheticWriteAccessor, valueRequired);
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != AstNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            this.generateReadSequence(currentScope, codeStream);
            if (valueRequired) {
                if (this.lastFieldBinding.declaringClass == null) {
                    codeStream.arraylength();
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else if (this.lastFieldBinding.constant != AstNode.NotAConstant) {
                    if (!this.lastFieldBinding.isStatic()) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(this.lastFieldBinding.constant, this.implicitConversion);
                } else {
                    SyntheticAccessMethodBinding accessor;
                    SyntheticAccessMethodBinding syntheticAccessMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
                    if (accessor == null) {
                        if (this.lastFieldBinding.isStatic()) {
                            codeStream.getstatic(this.lastFieldBinding);
                        } else {
                            codeStream.getfield(this.lastFieldBinding);
                        }
                    } else {
                        codeStream.invokestatic(accessor);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                }
            } else if (this.lastFieldBinding != null && !this.lastFieldBinding.isStatic()) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        SyntheticAccessMethodBinding accessor;
        this.generateReadSequence(currentScope, codeStream);
        SyntheticAccessMethodBinding syntheticAccessMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
        if (this.lastFieldBinding.isStatic()) {
            if (accessor == null) {
                codeStream.getstatic(this.lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        } else {
            codeStream.dup();
            if (accessor == null) {
                codeStream.getfield(this.lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        }
        int operationTypeID = this.implicitConversion >> 4;
        if (operationTypeID == 11) {
            codeStream.generateStringAppend(currentScope, null, expression);
        } else {
            codeStream.generateImplicitConversion(this.implicitConversion);
            if (expression == IntLiteral.One) {
                codeStream.generateConstant(expression.constant, this.implicitConversion);
            } else {
                expression.generateCode(currentScope, codeStream, true);
            }
            codeStream.sendOperator(operator, operationTypeID);
            codeStream.generateImplicitConversion(assignmentImplicitConversion);
        }
        this.fieldStore(codeStream, this.lastFieldBinding, this.syntheticWriteAccessor, valueRequired);
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        SyntheticAccessMethodBinding accessor;
        this.generateReadSequence(currentScope, codeStream);
        SyntheticAccessMethodBinding syntheticAccessMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
        if (this.lastFieldBinding.isStatic()) {
            if (accessor == null) {
                codeStream.getstatic(this.lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        } else {
            codeStream.dup();
            if (accessor == null) {
                codeStream.getfield(this.lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        }
        if (valueRequired) {
            if (this.lastFieldBinding.isStatic()) {
                if (this.lastFieldBinding.type == BaseTypes.LongBinding || this.lastFieldBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2();
                } else {
                    codeStream.dup();
                }
            } else if (this.lastFieldBinding.type == BaseTypes.LongBinding || this.lastFieldBinding.type == BaseTypes.DoubleBinding) {
                codeStream.dup2_x1();
            } else {
                codeStream.dup_x1();
            }
        }
        codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
        codeStream.sendOperator(postIncrement.operator, this.lastFieldBinding.type.id);
        codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
        this.fieldStore(codeStream, this.lastFieldBinding, this.syntheticWriteAccessor, false);
    }

    public void generateReadSequence(BlockScope currentScope, CodeStream codeStream) {
        int otherBindingsCount = this.otherCodegenBindings == null ? 0 : this.otherCodegenBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                this.lastFieldBinding = (FieldBinding)this.codegenBinding;
                if (this.lastFieldBinding.constant != AstNode.NotAConstant || !needValue || this.lastFieldBinding.isStatic()) break;
                if ((this.bits & 0x1FE0) != 0) {
                    ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                    codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    break;
                }
                this.generateReceiver(codeStream);
                break;
            }
            case 2: {
                if (!needValue) break;
                this.lastFieldBinding = null;
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.constant != AstNode.NotAConstant) {
                    codeStream.generateConstant(localBinding.constant, 0);
                    break;
                }
                if ((this.bits & 0x1FE0) != 0) {
                    Object[] path = currentScope.getEmulationPath(localBinding);
                    codeStream.generateOuterAccess(path, this, localBinding, currentScope);
                    break;
                }
                codeStream.load(localBinding);
            }
        }
        if (this.otherCodegenBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                FieldBinding nextField = this.otherCodegenBindings[i];
                if (this.lastFieldBinding != null) {
                    boolean bl = needValue = !nextField.isStatic();
                    if (needValue) {
                        SyntheticAccessMethodBinding accessor;
                        SyntheticAccessMethodBinding syntheticAccessMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[i];
                        if (accessor == null) {
                            if (this.lastFieldBinding.constant != AstNode.NotAConstant) {
                                if (this.lastFieldBinding != this.codegenBinding && !this.lastFieldBinding.isStatic()) {
                                    codeStream.invokeObjectGetClass();
                                    codeStream.pop();
                                }
                                codeStream.generateConstant(this.lastFieldBinding.constant, 0);
                            } else if (this.lastFieldBinding.isStatic()) {
                                codeStream.getstatic(this.lastFieldBinding);
                            } else {
                                codeStream.getfield(this.lastFieldBinding);
                            }
                        } else {
                            codeStream.invokestatic(accessor);
                        }
                    } else if (this.codegenBinding != this.lastFieldBinding && !this.lastFieldBinding.isStatic()) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                }
                this.lastFieldBinding = nextField;
                ++i;
            }
        }
    }

    public void generateReceiver(CodeStream codeStream) {
        codeStream.aload_0();
    }

    public TypeBinding getOtherFieldBindings(BlockScope scope) {
        int length = this.tokens.length;
        if ((this.bits & 1) != 0) {
            if (!((FieldBinding)this.binding).isStatic()) {
                if (this.indexOfFirstFieldBinding == 1) {
                    if (scope.methodScope().isStatic) {
                        scope.problemReporter().staticFieldAccessToNonStaticVariable(this, (FieldBinding)this.binding);
                        return null;
                    }
                } else {
                    scope.problemReporter().staticFieldAccessToNonStaticVariable(this, (FieldBinding)this.binding);
                    return null;
                }
            }
            if (this.isFieldUseDeprecated((FieldBinding)this.binding, scope, (this.bits & 0x2000) != 0 && this.indexOfFirstFieldBinding == length)) {
                scope.problemReporter().deprecatedField((FieldBinding)this.binding, this);
            }
        }
        TypeBinding type = ((VariableBinding)this.binding).type;
        int index = this.indexOfFirstFieldBinding;
        if (index == length) {
            this.constant = FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope);
            return type;
        }
        int otherBindingsLength = length - index;
        this.otherBindings = new FieldBinding[otherBindingsLength];
        this.otherCodegenBindings = this.otherBindings;
        this.otherDepths = new int[otherBindingsLength];
        this.constant = (this.bits & 1) != 0 ? FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope) : ((VariableBinding)this.binding).constant;
        int firstDepth = (this.bits & 0x1FE0) >> 5;
        while (index < length) {
            char[] token = this.tokens[index];
            if (type == null) {
                return null;
            }
            this.bits &= 0xFFFFE01F;
            FieldBinding field = scope.getField(type, token, this);
            int place = index - this.indexOfFirstFieldBinding;
            this.otherBindings[place] = field;
            this.otherDepths[place] = (this.bits & 0x1FE0) >> 5;
            if (field.isValidBinding()) {
                if (this.isFieldUseDeprecated(field, scope, (this.bits & 0x2000) != 0 && index + 1 == length)) {
                    scope.problemReporter().deprecatedField(field, this);
                }
                Constant someConstant = FieldReference.getConstantFor(field, this, false, scope);
                if (this.constant != AstNode.NotAConstant) {
                    this.constant = someConstant;
                }
                type = field.type;
                ++index;
                if (!field.isStatic()) continue;
                scope.problemReporter().unnecessaryReceiverForStaticField(this, field);
                continue;
            }
            this.constant = AstNode.NotAConstant;
            scope.problemReporter().invalidField(this, field, index, type);
            this.setDepth(firstDepth);
            return null;
        }
        this.setDepth(firstDepth);
        return this.otherBindings[otherBindingsLength - 1].type;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if ((this.bits & 0x1FE0) == 0 || this.constant != AstNode.NotAConstant) {
            return;
        }
        if ((this.bits & 7) == 2) {
            currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
        }
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope, FieldBinding fieldBinding, TypeBinding lastReceiverType, int index, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (fieldBinding.constant != AstNode.NotAConstant) {
            return;
        }
        if (fieldBinding.isPrivate()) {
            if (fieldBinding.declaringClass != currentScope.enclosingSourceType()) {
                if (this.syntheticReadAccessors == null) {
                    this.syntheticReadAccessors = this.otherBindings == null ? new SyntheticAccessMethodBinding[1] : new SyntheticAccessMethodBinding[this.otherBindings.length + 1];
                }
                this.syntheticReadAccessors[index] = ((SourceTypeBinding)fieldBinding.declaringClass).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
        } else if (fieldBinding.isProtected()) {
            int depth;
            int n = depth = index == 0 ? (this.bits & 0x1FE0) >> 5 : this.otherDepths[index - 1];
            if (depth > 0 && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage()) {
                if (this.syntheticReadAccessors == null) {
                    this.syntheticReadAccessors = this.otherBindings == null ? new SyntheticAccessMethodBinding[1] : new SyntheticAccessMethodBinding[this.otherBindings.length + 1];
                }
                this.syntheticReadAccessors[index] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt(depth)).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
        }
        if (!(fieldBinding.declaringClass == lastReceiverType || lastReceiverType.isArrayType() || fieldBinding.declaringClass == null || fieldBinding.constant != AstNode.NotAConstant || (currentScope.environment().options.targetJDK < 1 || index <= 0 && this.indexOfFirstFieldBinding <= 1 && fieldBinding.isStatic() || fieldBinding.declaringClass.id == 1) && fieldBinding.declaringClass.canBeSeenBy(currentScope))) {
            if (index == 0) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)lastReceiverType);
            } else {
                if (this.otherCodegenBindings == this.otherBindings) {
                    int l = this.otherBindings.length;
                    this.otherCodegenBindings = new FieldBinding[l];
                    System.arraycopy(this.otherBindings, 0, this.otherCodegenBindings, 0, l);
                }
                this.otherCodegenBindings[index - 1] = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)lastReceiverType);
            }
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope, FieldBinding fieldBinding, TypeBinding lastReceiverType, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (fieldBinding.isPrivate()) {
            if (fieldBinding.declaringClass != currentScope.enclosingSourceType()) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)fieldBinding.declaringClass).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
        } else if (fieldBinding.isProtected()) {
            int depth;
            int n = depth = fieldBinding == this.binding ? (this.bits & 0x1FE0) >> 5 : this.otherDepths[this.otherDepths.length - 1];
            if (depth > 0 && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage()) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt(depth)).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
        }
        if (!(fieldBinding.declaringClass == lastReceiverType || lastReceiverType.isArrayType() || fieldBinding.declaringClass == null || fieldBinding.constant != AstNode.NotAConstant || (currentScope.environment().options.targetJDK < 1 || fieldBinding == this.binding && this.indexOfFirstFieldBinding <= 1 && fieldBinding.isStatic() || fieldBinding.declaringClass.id == 1) && fieldBinding.declaringClass.canBeSeenBy(currentScope))) {
            if (fieldBinding == this.binding) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)lastReceiverType);
            } else {
                if (this.otherCodegenBindings == this.otherBindings) {
                    int l = this.otherBindings.length;
                    this.otherCodegenBindings = new FieldBinding[l];
                    System.arraycopy(this.otherBindings, 0, this.otherCodegenBindings, 0, l);
                }
                this.otherCodegenBindings[this.otherCodegenBindings.length - 1] = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)lastReceiverType);
            }
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = this.receiverType = scope.enclosingSourceType();
        this.constant = Constant.NotAConstant;
        this.codegenBinding = this.binding = scope.getBinding(this.tokens, this.bits & 7, (InvocationSite)this);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 7) {
                case 3: 
                case 7: {
                    if (this.binding instanceof LocalVariableBinding) {
                        if (!((LocalVariableBinding)this.binding).isFinal() && (this.bits & 0x1FE0) != 0) {
                            scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)this.binding, this);
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 2;
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    if (this.binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)this.binding;
                        MethodScope methodScope = scope.methodScope();
                        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.fieldDeclarationIndex != -1 && fieldBinding.id >= methodScope.fieldDeclarationIndex && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
                            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 1;
                        if (this.indexOfFirstFieldBinding > 1 && this.isTypeUseDeprecated(this.actualReceiverType, scope)) {
                            scope.problemReporter().deprecatedType(this.actualReceiverType, this);
                        }
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF8;
                    this.bits |= 4;
                }
                case 4: {
                    if (this.isTypeUseDeprecated((TypeBinding)this.binding, scope)) {
                        scope.problemReporter().deprecatedType((TypeBinding)this.binding, this);
                    }
                    this.resolvedType = (TypeBinding)this.binding;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public void setFieldIndex(int index) {
        this.indexOfFirstFieldBinding = index;
    }

    public String toStringExpression() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.length) {
            buffer.append(this.tokens[i]);
            if (i < this.tokens.length - 1) {
                buffer.append(".");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.tokens[0]);
    }
}

