/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;

class JarPackageFragment
extends PackageFragment {
    protected JarPackageFragment(IPackageFragmentRoot root, String name) {
        super(root, name);
    }

    protected boolean computeChildren(OpenableElementInfo info) {
        JarPackageFragmentInfo jInfo = (JarPackageFragmentInfo)info;
        if (jInfo.fEntryNames != null) {
            ArrayList<IClassFile> vChildren = new ArrayList<IClassFile>();
            Iterator iter = jInfo.fEntryNames.iterator();
            while (iter.hasNext()) {
                String child = (String)iter.next();
                IClassFile classFile = this.getClassFile(child);
                vChildren.add(classFile);
            }
            IJavaElement[] children = new IJavaElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(JavaElementInfo.fgEmptyChildren);
        }
        return true;
    }

    void computeNonJavaResources(String[] resNames, JarPackageFragmentInfo info, String zipName) {
        if (resNames == null) {
            info.setNonJavaResources(null);
            return;
        }
        int max = resNames.length;
        Object[] res = new Object[max];
        int index = 0;
        int i = 0;
        while (i < max) {
            String resName = resNames[i];
            if (!resName.toLowerCase().endsWith(".java")) {
                if (!this.isDefaultPackage()) {
                    resName = String.valueOf(this.getElementName().replace('.', '/')) + "/" + resName;
                }
                res[index++] = new JarEntryFile(resName, zipName);
            }
            ++i;
        }
        if (index != max) {
            Object[] objectArray = res;
            res = new Object[index];
            System.arraycopy(objectArray, 0, res, 0, index);
        }
        info.setNonJavaResources(res);
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public ICompilationUnit createCompilationUnit(String name, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    protected OpenableElementInfo createElementInfo() {
        return new JarPackageFragmentInfo();
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit[] getCompilationUnits() throws JavaModelException {
        return PackageFragment.fgEmptyCompilationUnitList;
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        return null;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        this.getOpenableParent().open(pm);
    }

    public void refreshChildren() {
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new JarPackageFragment((IPackageFragmentRoot)((JavaElement)this.fParent).rootedAt(project), this.fName);
    }

    protected Object[] storedNonJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }
}

