/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.TypeVector;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion fRegion;
    protected IJavaProject fProject;

    public RegionBasedTypeHierarchy(IRegion region, IJavaProject project, IType type, boolean computeSubtypes) throws JavaModelException {
        super(type, (IJavaSearchScope)null, computeSubtypes);
        this.fRegion = region;
        this.fProject = project;
    }

    protected void activate() {
        super.activate();
        IJavaElement[] roots = this.fRegion.getElements();
        int i = 0;
        while (i < roots.length) {
            IJavaElement root = roots[i];
            if (root instanceof IOpenable) {
                this.files.put(root, root);
            } else {
                Openable o = (Openable)((JavaElement)root).getOpenableParent();
                if (o != null) {
                    this.files.put(o, o);
                }
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void compute() throws JavaModelException, CoreException {
        RegionBasedHierarchyBuilder builder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)builder).build(this.computeSubtypes);
    }

    protected void destroy() {
        this.fRegion = new Region();
        super.destroy();
    }

    protected boolean isAffectedByOpenable(IJavaElementDelta delta, IJavaElement element) {
        if (element instanceof CompilationUnit && ((CompilationUnit)element).isWorkingCopy()) {
            return false;
        }
        if (this.focusType == null) {
            return this.fRegion.contains(element);
        }
        return super.isAffectedByOpenable(delta, element);
    }

    public IJavaProject javaProject() {
        return this.fProject;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses(), false);
    }

    private void pruneDeadBranches(IType[] types, boolean superInRegion) {
        int i = 0;
        int length = types.length;
        while (i < length) {
            TypeVector subtypes;
            IType type = types[i];
            if (this.fRegion.contains(type)) {
                subtypes = (TypeVector)this.typeToSubtypes.get(type);
                if (subtypes != null) {
                    this.pruneDeadBranches(subtypes.copy().elements(), true);
                }
            } else if (superInRegion) {
                this.removeType(type);
            } else {
                subtypes = (TypeVector)this.typeToSubtypes.get(type);
                if (subtypes != null) {
                    this.pruneDeadBranches(subtypes.copy().elements(), false);
                }
                if ((subtypes = (TypeVector)this.typeToSubtypes.get(type)) == null || subtypes.size == 0) {
                    this.removeType(type);
                }
            }
            ++i;
        }
    }

    protected void removeType(IType type) {
        IType[] superinterfaces;
        TypeVector types;
        IType superclass;
        IType[] subtypes = this.getSubtypes(type);
        this.typeToSubtypes.remove(type);
        if (subtypes != null) {
            int i = 0;
            while (i < subtypes.length) {
                this.removeType(subtypes[i]);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.remove(type)) != null && (types = (TypeVector)this.typeToSubtypes.get(superclass)) != null) {
            types.remove(type);
        }
        if ((superinterfaces = (IType[])this.typeToSuperInterfaces.remove(type)) != null) {
            int i = 0;
            int length = superinterfaces.length;
            while (i < length) {
                IType superinterface = superinterfaces[i];
                TypeVector types2 = (TypeVector)this.typeToSubtypes.get(superinterface);
                if (types2 != null) {
                    types2.remove(type);
                }
                ++i;
            }
        }
    }
}

