/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.CoreElement;
import org.apache.jasper.compiler.DelegatingListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;
import org.xml.sax.Attributes;

public class Parser {
    private JspReader reader;
    private ParseEventListener listener;
    CharArrayWriter caw;
    Mark tmplStart;
    Mark tmplStop;
    String currentFile;
    static final Vector coreElements = new Vector();

    public Parser(JspReader reader, ParseEventListener lnr) {
        this.reader = reader;
        this.listener = new DelegatingListener(lnr, new Action(){

            public void execute(Mark start, Mark stop) throws JasperException {
                Parser.this.flushCharData(start, stop);
            }
        });
        this.caw = new CharArrayWriter();
        this.currentFile = reader.mark().getFile();
    }

    public Parser(JspCompilationContext ctxt, String file, String encoding, InputStreamReader inReader, ParseEventListener lnr) throws ParseException, FileNotFoundException {
        this.reader = new JspReader(ctxt, file, encoding, inReader);
        lnr.setReader(this.reader);
        this.listener = new DelegatingListener(lnr, new Action(){

            public void execute(Mark start, Mark stop) throws JasperException {
                Parser.this.flushCharData(start, stop);
            }
        });
        this.caw = new CharArrayWriter();
        this.currentFile = this.reader.mark().getFile();
    }

    void flushCharData(Mark start, Mark stop) throws JasperException {
        char[] array = this.caw.toCharArray();
        if (array.length != 0) {
            this.listener.handleJspCdata(start, stop, this.caw.toCharArray());
        }
        this.caw = new CharArrayWriter();
    }

    public void parse() throws JasperException {
        this.parse(null);
    }

    public void parse(String until) throws JasperException {
        this.parse(until, null);
    }

    public void parse(String until, Class[] accept) throws JasperException {
        boolean noJspElement = false;
        while (this.reader.hasMoreInput()) {
            CoreElement c;
            if (this.tmplStart == null) {
                this.tmplStart = this.reader.mark();
            }
            if (this.tmplStop == null) {
                this.tmplStop = this.reader.mark();
            }
            if (until != null && this.reader.matches(until)) {
                return;
            }
            if (!this.reader.mark().getFile().equals(this.currentFile)) {
                this.flushCharData(this.tmplStart, this.tmplStop);
                this.currentFile = this.reader.mark().getFile();
                this.tmplStart = this.reader.mark();
            }
            Enumeration e = coreElements.elements();
            if (accept != null) {
                Vector<CoreElement> v = new Vector<CoreElement>();
                while (e.hasMoreElements()) {
                    c = (CoreElement)e.nextElement();
                    int i = 0;
                    while (i < accept.length) {
                        if (c.getClass().equals(accept[i])) {
                            v.addElement(c);
                        }
                        ++i;
                    }
                }
                e = v.elements();
            }
            boolean accepted = false;
            while (e.hasMoreElements()) {
                c = (CoreElement)e.nextElement();
                Mark m = this.reader.mark();
                if (!c.accept(this.listener, this.reader, this)) continue;
                Constants.message("jsp.message.accepted", new Object[]{c.getClass().getName(), m}, 4);
                accepted = true;
                noJspElement = false;
                break;
            }
            if (accepted) continue;
            if (!noJspElement) {
                this.tmplStart = this.reader.mark();
                noJspElement = true;
            }
            String s = this.reader.nextContent();
            this.tmplStop = this.reader.mark();
            this.caw.write(s, 0, s.length());
        }
        this.flushCharData(this.tmplStart, this.tmplStop);
    }

    static {
        coreElements.addElement(new Directive());
        coreElements.addElement(new Include());
        coreElements.addElement(new Forward());
        coreElements.addElement(new Comment());
        coreElements.addElement(new Declaration());
        coreElements.addElement(new Expression());
        coreElements.addElement(new Scriptlet());
        coreElements.addElement(new Bean());
        coreElements.addElement(new GetProperty());
        coreElements.addElement(new SetProperty());
        coreElements.addElement(new Tag());
        coreElements.addElement(new Plugin());
        coreElements.addElement(new QuoteEscape());
    }

    static final class QuoteEscape
    implements CoreElement {
        private static String QUOTED_START_TAG = "<\\%";
        private static String QUOTED_END_TAG = "%\\>";
        private static String START_TAG = "<%";
        private static String END_TAG = "%>";
        private static final String APOS = "&apos;";
        private static final String QUOTE = "&quote;";

        QuoteEscape() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            try {
                Mark start = reader.mark();
                if (reader.matches(QUOTED_START_TAG)) {
                    reader.advance(QUOTED_START_TAG.length());
                    Mark end = reader.mark();
                    parser.caw.write(START_TAG);
                    parser.flushCharData(start, end);
                    return true;
                }
                if (reader.matches(APOS)) {
                    reader.advance(APOS.length());
                    Mark end = reader.mark();
                    parser.caw.write("'");
                    parser.flushCharData(start, end);
                    return true;
                }
                if (reader.matches(QUOTE)) {
                    reader.advance(QUOTE.length());
                    Mark end = reader.mark();
                    parser.caw.write("\"");
                    parser.flushCharData(start, end);
                    return true;
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
            return false;
        }
    }

    static final class Plugin
    implements CoreElement {
        private static final String OPEN_PLUGIN = "<jsp:plugin";
        private static final String END_OPEN_PLUGIN = ">";
        private static final String CLOSE_PLUGIN = "</jsp:plugin>";
        private static final String OPEN_PARAMS = "<jsp:params>";
        private static final String CLOSE_PARAMS = "</jsp:params>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String OPEN_FALLBACK = "<jsp:fallback>";
        private static final String CLOSE_FALLBACK = "</jsp:fallback>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height"), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width"), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};

        Plugin() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_PLUGIN)) {
                Mark start = reader.mark();
                reader.advance(OPEN_PLUGIN.length());
                Attributes attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(END_OPEN_PLUGIN)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.plugin.notclosed"));
                }
                reader.advance(END_OPEN_PLUGIN.length());
                reader.skipSpaces();
                Hashtable param = null;
                String fallback = null;
                JspUtil.checkAttributes("plugin", attrs, validAttributes, start);
                if (reader.matches(OPEN_PARAMS)) {
                    param = new Hashtable();
                    boolean paramsClosed = false;
                    reader.advance(OPEN_PARAMS.length());
                    while (reader.hasMoreInput()) {
                        reader.skipSpaces();
                        if (reader.matches(CLOSE_PARAMS)) {
                            paramsClosed = true;
                            reader.advance(CLOSE_PARAMS.length());
                            break;
                        }
                        if (!reader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpected"));
                        }
                        reader.parsePluginParamTag(param);
                        reader.skipSpaces();
                        if (!reader.matches(CLOSE_INDIVIDUAL_PARAM)) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.closeindividualparam"));
                        }
                        reader.advance(CLOSE_INDIVIDUAL_PARAM.length());
                    }
                    if (!paramsClosed) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.closeparams"));
                    }
                    reader.skipSpaces();
                }
                if (reader.matches(OPEN_FALLBACK)) {
                    reader.advance(OPEN_FALLBACK.length());
                    reader.skipSpaces();
                    Mark fallBackStart = reader.mark();
                    Mark fallBackStop = reader.skipUntil(CLOSE_FALLBACK);
                    fallback = new String(reader.getChars(fallBackStart, fallBackStop));
                    reader.skipSpaces();
                }
                if (!reader.matches(CLOSE_PLUGIN)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_PLUGIN}));
                }
                reader.advance(CLOSE_PLUGIN.length());
                Mark stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handlePlugin(start, stop, attrs, param, fallback);
                return true;
            }
            return false;
        }
    }

    static final class Tag
    implements CoreElement {
        private static final String CLOSE_1 = "/>";
        private static final String CLOSE = ">";

        Tag() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            TagLibraries libraries;
            if (reader.peekChar() != 60) {
                return false;
            }
            Mark start = reader.mark();
            reader.nextChar();
            String tag = reader.parseToken(false);
            int i = tag.indexOf(58);
            if (i == -1) {
                reader.reset(start);
                return false;
            }
            String prefix = tag.substring(0, i);
            String shortTagName = "";
            if (++i < tag.length()) {
                shortTagName = tag.substring(i);
            }
            if (!(libraries = listener.getTagLibraries()).isUserDefinedTag(prefix, shortTagName)) {
                reader.reset(start);
                return false;
            }
            if (shortTagName == null) {
                throw new ParseException(start, "Nothing after the :");
            }
            TagLibraryInfo tli = libraries.getTagLibInfo(prefix);
            TagInfo ti = tli.getTag(shortTagName);
            if (ti == null) {
                throw new ParseException(start, "Unable to locate TagInfo for " + tag);
            }
            String bc = ti.getBodyContent();
            Attributes attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            Mark bodyStart = null;
            Mark bodyStop = null;
            boolean hasBody = false;
            if (reader.matches(CLOSE_1)) {
                reader.advance(CLOSE_1.length());
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleTagBegin(start, reader.mark(), attrs, prefix, shortTagName, tli, ti, false);
                listener.handleTagEnd(start, reader.mark(), prefix, shortTagName, attrs, tli, ti, false);
                return true;
            }
            if (!reader.matches(CLOSE)) throw new ParseException(start, "Unterminated user-defined tag");
            reader.advance(CLOSE.length());
            bodyStart = reader.mark();
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            String tagEnd = "</" + tag + CLOSE;
            bodyStop = reader.skipUntil(tagEnd.toLowerCase());
            if (bodyStop != null) {
                String bodyString = new String(reader.getChars(bodyStart, bodyStop));
                boolean bl = hasBody = bodyString.length() > 0;
                if (hasBody && bc.equalsIgnoreCase("EMPTY")) {
                    throw new ParseException(start, "Body is supposed to be empty for " + tag);
                }
            }
            reader.reset(bodyStart);
            listener.handleTagBegin(start, bodyStart, attrs, prefix, shortTagName, tli, ti, hasBody);
            if (!bc.equalsIgnoreCase("TAGDEPENDENT") && !bc.equalsIgnoreCase("EMPTY") && !bc.equalsIgnoreCase("JSP")) throw new ParseException(start, "Internal Error: Invalid BODY_CONTENT type");
            if (bc.equalsIgnoreCase("TAGDEPENDENT")) {
                parser.parse(tagEnd, new Class[0]);
            } else {
                parser.parse(tagEnd);
            }
            try {
                reader.advance(tagEnd.length());
            }
            catch (ParseException ex) {
                throw new ParseException(start, Constants.getString("jsp.error.unterminated.user.tag", new Object[]{JspUtil.escapeXml(tagEnd)}));
            }
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            listener.handleTagEnd(parser.tmplStop, reader.mark(), prefix, shortTagName, attrs, tli, ti, hasBody);
            return true;
        }
    }

    static final class SetProperty
    implements CoreElement {
        private static final String OPEN_SETPROPERTY = "<jsp:setProperty";
        private static final String CLOSE_SETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value"), new JspUtil.ValidAttribute("param")};

        SetProperty() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_SETPROPERTY)) {
                Mark start = reader.mark();
                reader.advance(OPEN_SETPROPERTY.length());
                Attributes attrs = reader.parseTagAttributes();
                JspUtil.checkAttributes("setProperty", attrs, validAttributes, start);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_SETPROPERTY)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_SETPROPERTY}));
                }
                reader.advance(CLOSE_SETPROPERTY.length());
                Mark stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleSetProperty(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class GetProperty
    implements CoreElement {
        private static final String OPEN_GETPROPERTY = "<jsp:getProperty";
        private static final String CLOSE_GETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};

        GetProperty() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_GETPROPERTY)) {
                Mark start = reader.mark();
                reader.advance(OPEN_GETPROPERTY.length());
                Attributes attrs = reader.parseTagAttributes();
                JspUtil.checkAttributes("getProperty", attrs, validAttributes, start);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_GETPROPERTY)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_GETPROPERTY}));
                }
                reader.advance(CLOSE_GETPROPERTY.length());
                Mark stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleGetProperty(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class Bean
    implements CoreElement {
        private static final String OPEN_BEAN = "<jsp:useBean";
        private static final String CLOSE_BEAN = "/>";
        private static final String CLOSE_BEAN_2 = "</jsp:useBean>";
        private static final String CLOSE_BEAN_3 = ">";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName")};

        Bean() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_BEAN)) {
                Mark start = reader.mark();
                reader.advance(OPEN_BEAN.length());
                Attributes attrs = reader.parseTagAttributesBean();
                JspUtil.checkAttributes("useBean", attrs, validAttributes, start);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_BEAN)) {
                    if (!reader.matches(CLOSE_BEAN_3)) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"useBean"}));
                    }
                    reader.advance(CLOSE_BEAN_3.length());
                    Mark stop = reader.mark();
                    listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                    listener.handleBean(start, stop, attrs);
                    int oldSize = reader.size;
                    parser.parse(CLOSE_BEAN_2);
                    if (oldSize != reader.size) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.usebean.notinsamefile"));
                    }
                    if (!reader.matches(CLOSE_BEAN_2)) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_BEAN}));
                    }
                    reader.advance(CLOSE_BEAN_2.length());
                    listener.handleBeanEnd(start, stop, attrs);
                    return true;
                }
                reader.advance(CLOSE_BEAN.length());
                Mark stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleBean(start, stop, attrs);
                listener.handleBeanEnd(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class Scriptlet
    implements CoreElement {
        private static final String OPEN_SCRIPTLET = "<%";
        private static final String CLOSE_SCRIPTLET = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Scriptlet() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            Mark stop;
            String end_open = null;
            Attributes attrs = null;
            if (!reader.matches(OPEN_SCRIPTLET)) {
                return false;
            }
            String open = OPEN_SCRIPTLET;
            String close = CLOSE_SCRIPTLET;
            reader.advance(open.length());
            Mark start = reader.mark();
            if (end_open != null) {
                attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(end_open)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                reader.advance(end_open.length());
                reader.skipSpaces();
                JspUtil.checkAttributes("Scriptlet", attrs, validAttributes, start);
            }
            if ((stop = reader.skipUntil(close)) == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            listener.handleScriptlet(start, stop, attrs, reader.getChars(start, stop));
            return true;
        }
    }

    static final class Expression
    implements CoreElement {
        private static final String OPEN_EXPR = "<%=";
        private static final String CLOSE_EXPR = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Expression() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            Mark stop;
            String end_open = null;
            Attributes attrs = null;
            if (!reader.matches(OPEN_EXPR)) {
                return false;
            }
            String open = OPEN_EXPR;
            String close = CLOSE_EXPR;
            reader.advance(open.length());
            Mark start = reader.mark();
            if (end_open != null) {
                attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(end_open)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                reader.advance(end_open.length());
                reader.skipSpaces();
                JspUtil.checkAttributes("Expression", attrs, validAttributes, start);
            }
            if ((stop = reader.skipUntil(close)) == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            listener.handleExpression(start, stop, attrs, reader.getChars(start, stop));
            return true;
        }
    }

    static final class Declaration
    implements CoreElement {
        private static final String OPEN_DECL = "<%!";
        private static final String CLOSE_DECL = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Declaration() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            Mark stop;
            String end_open = null;
            Attributes attrs = null;
            if (!reader.matches(OPEN_DECL)) {
                return false;
            }
            String open = OPEN_DECL;
            String close = CLOSE_DECL;
            reader.advance(open.length());
            Mark start = reader.mark();
            if (end_open != null) {
                attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(end_open)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                reader.advance(end_open.length());
                reader.skipSpaces();
                JspUtil.checkAttributes("Declaration", attrs, validAttributes, start);
            }
            if ((stop = reader.skipUntil(close)) == null) {
                throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            listener.handleDeclaration(start, stop, attrs, reader.getChars(start, stop));
            return true;
        }
    }

    static final class Comment
    implements CoreElement {
        private static final String OPEN_COMMENT = "<%--";
        private static final String CLOSE_COMMENT = "--%>";

        Comment() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_COMMENT)) {
                reader.advance(OPEN_COMMENT.length());
                Mark start = reader.mark();
                Mark stop = reader.skipUntil(CLOSE_COMMENT);
                if (stop == null) {
                    throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{OPEN_COMMENT}));
                }
                parser.flushCharData(parser.tmplStart, parser.tmplStop);
                return true;
            }
            return false;
        }
    }

    static final class Forward
    implements CoreElement {
        private static final String OPEN_FORWARD = "<jsp:forward";
        private static final String CLOSE_FORWARD_NO_BODY = "/>";
        private static final String CLOSE_FORWARD_BODY = ">";
        private static final String CLOSE_FORWARD = "</jsp:forward>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};

        Forward() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!reader.matches("<jsp:forward")) break block4;
                            start = reader.mark();
                            reader.advance("<jsp:forward".length());
                            attrs = reader.parseTagAttributes();
                            param = new Hashtable<K, V>();
                            JspUtil.checkAttributes("Forward", attrs, Forward.validAttributes, start);
                            reader.skipSpaces();
                            if (reader.matches("/>")) break block5;
                            if (!reader.matches(">")) {
                                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                            }
                            reader.advance(">".length());
                            reader.skipSpaces();
                            if (reader.matches("</jsp:forward>")) break block6;
                            reader.skipSpaces();
                            if (reader.matches("<jsp:param ")) ** GOTO lbl28
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpectedonly"));
lbl-1000:
                            // 1 sources

                            {
                                reader.parsePluginParamTag(param);
                                reader.skipSpaces();
                                if (!reader.matches("/>")) {
                                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param "}));
                                }
                                reader.advance("/>".length());
                                reader.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (reader.matches((String)"<jsp:param "))
                            }
                        }
                        if (!reader.matches("</jsp:forward>")) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                        }
                        reader.advance("</jsp:forward>".length());
                        break block7;
                    }
                    reader.advance("/>".length());
                }
                stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleForward(start, stop, attrs, param);
                return true;
            }
            return false;
        }
    }

    static final class Include
    implements CoreElement {
        private static final String OPEN_INCLUDE = "<jsp:include";
        private static final String CLOSE_INCLUDE_NO_BODY = "/>";
        private static final String CLOSE_INCLUDE_BODY = ">";
        private static final String CLOSE_INCLUDE = "</jsp:include>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};

        Include() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!reader.matches("<jsp:include")) break block4;
                            param = new Hashtable<K, V>();
                            start = reader.mark();
                            reader.advance("<jsp:include".length());
                            attrs = reader.parseTagAttributes();
                            JspUtil.checkAttributes("Include", attrs, Include.validAttributes, start);
                            reader.skipSpaces();
                            if (reader.matches("/>")) break block5;
                            if (!reader.matches(">")) {
                                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                            }
                            reader.advance(">".length());
                            reader.skipSpaces();
                            if (reader.matches("</jsp:include>")) break block6;
                            reader.skipSpaces();
                            if (reader.matches("<jsp:param ")) ** GOTO lbl28
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpectedonly"));
lbl-1000:
                            // 1 sources

                            {
                                reader.parsePluginParamTag(param);
                                reader.skipSpaces();
                                if (!reader.matches("/>")) {
                                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param "}));
                                }
                                reader.advance("/>".length());
                                reader.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (reader.matches((String)"<jsp:param "))
                            }
                        }
                        if (!reader.matches("</jsp:include>")) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                        }
                        reader.advance("</jsp:include>".length());
                        break block7;
                    }
                    reader.advance("/>".length());
                }
                stop = reader.mark();
                listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                listener.handleInclude(start, stop, attrs, param);
                return true;
            }
            return false;
        }
    }

    static final class Directive
    implements CoreElement {
        private static final String OPEN_DIRECTIVE = "<%@";
        private static final String CLOSE_DIRECTIVE = "%>";
        static final String[] directives = new String[]{"page", "include", "taglib"};
        private static final JspUtil.ValidAttribute[] pageDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding")};
        private static final JspUtil.ValidAttribute[] includeDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] tagDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri", true), new JspUtil.ValidAttribute("prefix", true)};
        private static final String[] reservedPrefixes = new String[]{"jsp", "jspx", "java", "javax", "servlet", "sun", "sunw"};

        Directive() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (!reader.matches(OPEN_DIRECTIVE)) {
                return false;
            }
            String open = OPEN_DIRECTIVE;
            String close = CLOSE_DIRECTIVE;
            Mark start = reader.mark();
            reader.advance(open.length());
            reader.skipSpaces();
            String match = null;
            int i = 0;
            while (i < directives.length) {
                if (reader.matches(directives[i])) {
                    match = directives[i];
                    break;
                }
                ++i;
            }
            if (match == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.invalid.directive"));
            }
            reader.advance(match.length());
            Attributes attrs = reader.parseTagAttributes();
            if (match.equals("page")) {
                JspUtil.checkAttributes("Page directive", attrs, pageDvalidAttrs, start);
            } else if (match.equals("include")) {
                JspUtil.checkAttributes("Include directive", attrs, includeDvalidAttrs, start);
            } else if (match.equals("taglib")) {
                JspUtil.checkAttributes("Taglib directive", attrs, tagDvalidAttrs, start);
                String prefix = attrs.getValue("prefix");
                int i2 = 0;
                while (i2 < reservedPrefixes.length) {
                    if (prefix.equals(reservedPrefixes[i2])) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.taglib.reserved.prefix", new Object[]{prefix}));
                    }
                    ++i2;
                }
            }
            reader.skipSpaces();
            if (!reader.matches(close)) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            reader.advance(close.length());
            Mark stop = reader.mark();
            listener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            listener.handleDirective(match, start, stop, attrs);
            return true;
        }
    }

    public static interface Action {
        public void execute(Mark var1, Mark var2) throws JasperException;
    }
}

