/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.ServletEngine;

public class JspServlet
extends HttpServlet {
    Logger.Helper loghelper;
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected Options options;
    protected URLClassLoader parentClassLoader;
    protected ServletEngine engine;
    protected String serverInfo;
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    static boolean firstTime = true;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        Constants.jasperLog = new DefaultLogger(this.context);
        Constants.jasperLog.setName("JASPER_LOG");
        Constants.jasperLog.setTimestamp("false");
        Constants.jasperLog.setVerbosityLevel(config.getInitParameter("logVerbosityLevel"));
        this.loghelper = new Logger.Helper("JASPER_LOG", "JspServlet");
        this.options = new EmbededServletOptions(config, this.context);
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String contextDir = this.context.getRealPath("/");
                if (contextDir == null) {
                    contextDir = this.options.getScratchDir().toString();
                }
                URL url = new URL("file:" + contextDir);
                this.codeSource = new CodeSource(url, null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                contextDir = contextDir.endsWith(File.separator) ? contextDir + "-" : contextDir + File.separator + "-";
                this.permissionCollection.add(new FilePermission(contextDir, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = this.parentClassLoader.getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    int i = 0;
                    while (i < urls.length) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl == null && urls[i].toString().startsWith("jar:jndi:")) {
                            jarUrl = urls[i].toString();
                            jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                            jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                        }
                        ++i;
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (MalformedURLException mfe) {
                // empty catch block
            }
        }
        if (firstTime) {
            firstTime = false;
            if (System.getSecurityManager() != null) {
                String basePackage = "org.apache.jasper.";
                try {
                    this.parentClassLoader.loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                    this.parentClassLoader.loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                    this.parentClassLoader.loadClass(basePackage + "runtime.JspRuntimeLibrary");
                    this.parentClassLoader.loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                    this.parentClassLoader.loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                    ((Object)((Object)this)).getClass().getClassLoader().loadClass(basePackage + "servlet.JspServlet$JspServletWrapper");
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Jasper JspServlet preload of class failed: " + ex.getMessage());
                }
            }
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper == null) {
            wrapper = new JspServletWrapper(jspUri, isErrorPage);
            this.jsps.put(jspUri, wrapper);
        }
        wrapper.service(request, response, precompile);
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
            if (jspFile != null) {
                jspUri = jspFile;
            }
            boolean precompile = this.preCompile(request);
            Logger jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.matchVerbosityLevel(3)) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
                jasperLog.log("\t  Request Params: ");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    jasperLog.log("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    boolean loadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        boolean outDated;
        JspEngineContext ctxt;
        JspServletWrapper jsw;
        block17: {
            if (this.context.getResourceAsStream(jspUri) == null) {
                throw new FileNotFoundException(jspUri);
            }
            jsw = (JspServletWrapper)this.jsps.get(jspUri);
            if (jsw == null) {
                throw new JasperException("Can't happen - JspServletWrapper=null");
            }
            File outDir = null;
            try {
                URL outURL = this.options.getScratchDir().toURL();
                String outURI = outURL.toString();
                outURI = outURI.endsWith("/") ? outURI + jspUri.substring(1, jspUri.lastIndexOf("/") + 1) : outURI + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                outURL = new URL(outURI);
                outDir = new File(outURL.getFile());
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
            }
            catch (Exception e) {
                throw new JasperException("No output directory: " + e.getMessage());
            }
            boolean firstTime = jsw.servletClass == null;
            ctxt = new JspEngineContext(this.parentClassLoader, classpath, this.context, jspUri, outDir.toString() + File.separator, isErrorPage, this.options, req, res);
            outDated = false;
            Compiler compiler = ctxt.createCompiler();
            try {
                outDated = compiler.compile();
                if (jsw.servletClass != null && !compiler.isOutDated()) break block17;
                JspServlet jspServlet = this;
                synchronized (jspServlet) {
                    if (jsw.servletClass == null || compiler.isOutDated()) {
                        outDated = compiler.compile();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                compiler.removeGeneratedFiles();
                throw ex;
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString("jsp.error.unable.compile"), ex);
            }
        }
        if (jsw.servletClass == null || outDated) {
            try {
                URL[] urls = new URL[1];
                File outputDir = new File(this.normalize(ctxt.getOutputDir()));
                urls[0] = outputDir.toURL();
                jsw.loader = new JasperLoader(urls, ctxt.getServletClassName(), this.parentClassLoader, this.permissionCollection, this.codeSource);
                jsw.servletClass = jsw.loader.loadClass("org.apache.jsp." + ctxt.getServletClassName());
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
            catch (MalformedURLException mue) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), mue);
            }
        }
        return outDated;
    }

    public boolean isOutDated(File jsp, JspCompilationContext ctxt, Mangler mangler) {
        File jspReal = null;
        jspReal = new File(ctxt.getRealPath(jsp.getPath()));
        File classFile = new File(mangler.getClassFileName());
        boolean outDated = classFile.exists() ? classFile.lastModified() < jspReal.lastModified() : true;
        return outDated;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    class JspServletWrapper {
        Servlet theServlet;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;
        URLClassLoader loader = null;

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }

        private void load() throws JasperException, ServletException {
            try {
                this.destroy();
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
            this.theServlet.init(JspServlet.this.config);
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp = (String)JspServlet.this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (cp == null || cp.equals("")) {
                accordingto = "according to the init parameter";
                cp = JspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{accordingto, cp == null ? "" : cp}, 3);
            if (JspServlet.this.loadJSP(this.jspUri, cp, this.isErrorPage, req, res) || this.theServlet == null) {
                this.load();
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            block10: {
                try {
                    this.loadIfNecessary(request, response);
                    if (precompile) {
                        return;
                    }
                    if (this.theServlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                            break block10;
                        }
                    }
                    this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                }
                catch (FileNotFoundException ex) {
                    String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                    if (includeRequestUri != null) {
                        throw new ServletException((Throwable)ex);
                    }
                    try {
                        response.sendError(404, ex.getMessage());
                    }
                    catch (IllegalStateException ise) {
                        Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{ex.getMessage()}), ex, 1);
                    }
                    return;
                }
            }
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }
    }
}

