/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import org.apache.util.HttpURL;
import org.apache.util.URIUtil;

public class HttpsURL
extends HttpURL {
    public static final String scheme = "https";
    public static final int port = 443;
    static final long serialVersionUID = 887844277028676647L;

    public HttpsURL(String escapedHttpsURL) {
        super(escapedHttpsURL);
        this.setDefaultScheme(scheme);
        this.setDefaultPort(443);
    }

    public HttpsURL(String host, String path) {
        this(null, null, host, 443, path, null);
    }

    public HttpsURL(String host, int port, String path) {
        this(null, null, host, port, path, null);
    }

    public HttpsURL(String host, int port, String path, String query) {
        this(null, null, host, port, path, query);
    }

    public HttpsURL(String userName, String password, String host) {
        this(userName, password, host, 443, null, null);
    }

    public HttpsURL(String userName, String password, String host, int port) {
        this(userName, password, host, port, null, null);
    }

    public HttpsURL(String userName, String password, String host, String path) {
        this(userName, password, host, 443, path, null);
    }

    public HttpsURL(String userName, String password, String host, int port, String path) {
        this(userName, password, host, port, path, null);
    }

    public HttpsURL(String userName, String password, String host, String path, String query) {
        this(userName, password, host, 443, path, query);
    }

    public HttpsURL(String userName, String password, String host, int port, String path, String query) {
        super(URIUtil.escape(scheme, URIUtil.schemeReserved()) + "://" + (userName == null ? "" : URIUtil.escape(userName) + (password == null ? "" : ":" + URIUtil.escape(password)) + "@") + URIUtil.escape(host, URIUtil.hostReserved()) + (port == 443 || port == -1 ? "" : ":" + port) + (path == null || path.equals("") ? "/" : URIUtil.escape(!path.startsWith("/") ? "/" + path : path, URIUtil.pathReserved())) + (query == null || query.equals("") ? "" : "?" + URIUtil.escape(query, URIUtil.queryReserved())));
        this.setDefaultScheme(scheme);
        this.setDefaultPort(port);
    }

    public HttpsURL(HttpsURL httpsURL, String path) {
        this(httpsURL.toString() + (httpsURL.toString().endsWith("/") ? "" : "/") + URIUtil.escape(path, URIUtil.pathReserved()));
    }
}

