/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavException;
import org.apache.webdav.lib.WebdavResource;

public class WebdavFile
extends File {
    public static final char davSeparatorChar = '/';
    public static final String davSeparator = String.valueOf('/');
    private HttpURL httpUrl = null;
    private String relPath = null;

    public WebdavFile(WebdavFile parent, String child) throws MalformedURLException {
        this(parent.getAbsolutePath() + davSeparator + child, parent.getUser(), parent.getPass());
    }

    public WebdavFile(String pathname, String user, String pass) throws MalformedURLException {
        this(new URL(pathname), user, pass);
    }

    public WebdavFile(URL url, String user, String pass) throws MalformedURLException {
        this(new HttpURL(user, pass, url.getHost(), url.getPort(), url.getPath()));
    }

    public WebdavFile(String parent, String child, String user, String pass) throws MalformedURLException {
        this(parent + davSeparator + child, user, pass);
    }

    public WebdavFile(HttpURL httpUrl) {
        super(httpUrl.getUnescapedHttpURL());
        this.httpUrl = httpUrl;
    }

    public WebdavFile(String aPath) {
        super(aPath);
        this.relPath = aPath;
    }

    private WebdavResource createRes() {
        try {
            if (this.httpUrl == null) {
                throw new WebdavException("this method is not supported with relative paths");
            }
            return new WebdavResource(this.httpUrl);
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    private void closeRes(WebdavResource res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e) {
            throw new WebdavException(e);
        }
    }

    private File[] toFileArray(List fileList) {
        File[] files = new File[fileList.size()];
        Iterator it = fileList.iterator();
        int i = 0;
        while (i < files.length) {
            files[i] = (WebdavFile)it.next();
            ++i;
        }
        return files;
    }

    public String getUser() throws MalformedURLException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getUserName();
    }

    public String getPass() throws MalformedURLException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.getPassword();
    }

    public String getName() {
        if (this.relPath != null) {
            return this.relPath;
        }
        return this.httpUrl.getName();
    }

    public String getParent() {
        if (this.relPath != null) {
            return null;
        }
        String parent = this.httpUrl.getParent();
        if ("/".equals(parent)) {
            return null;
        }
        return parent;
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            return new WebdavFile(this.getParent(), this.getUser(), this.getPass());
        }
        catch (MalformedURLException e) {
            throw new WebdavException(e);
        }
    }

    public String getPath() {
        if (this.relPath != null) {
            return this.relPath;
        }
        return this.httpUrl.getUnescapedHttpURL();
    }

    public boolean isAbsolute() {
        return this.relPath == null;
    }

    public String getAbsolutePath() {
        return this.getPath();
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public File getCanonicalFile() {
        return this;
    }

    public URL toURL() throws MalformedURLException {
        if (this.relPath != null) {
            return null;
        }
        return this.httpUrl.toURL();
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = !res.isLocked();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean exists() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.exists();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean isDirectory() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.isCollection();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.getIsHidden();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public long lastModified() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            long l = res.getGetLastModified();
            Object var5_4 = null;
            this.closeRes(res);
            return l;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public long length() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            long l = res.getGetContentLength();
            Object var5_4 = null;
            this.closeRes(res);
            return l;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean createNewFile() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.putMethod("");
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean delete() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.deleteMethod();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public void deleteOnExit() {
        throw new WebdavException("this method is not implemented");
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(FilenameFilter filter) {
        File[] files = this.listFiles(filter);
        String[] names = new String[files.length];
        int i = 0;
        while (i < names.length) {
            names[i] = files[i].getAbsolutePath();
            ++i;
        }
        return names;
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FilenameFilter filter) {
        WebdavResource[] allFiles;
        WebdavResource res;
        block7: {
            res = null;
            res = this.createRes();
            allFiles = res.listWebdavResources();
            if (allFiles != null) break block7;
            File[] fileArray = null;
            Object var9_6 = null;
            this.closeRes(res);
            return fileArray;
        }
        try {
            ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
            int i = 0;
            while (i < allFiles.length) {
                if (filter == null || filter.accept(this, allFiles[i].getDisplayName())) {
                    filtered.add(new WebdavFile(allFiles[i].getHttpURL()));
                }
                ++i;
            }
            File[] fileArray = this.toFileArray(filtered);
            Object var9_7 = null;
            this.closeRes(res);
            return fileArray;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public File[] listFiles(FileFilter filter) {
        WebdavResource[] allFiles;
        WebdavResource res;
        block7: {
            res = null;
            res = this.createRes();
            allFiles = res.listWebdavResources();
            if (allFiles != null) break block7;
            File[] fileArray = null;
            Object var9_6 = null;
            this.closeRes(res);
            return fileArray;
        }
        try {
            ArrayList<WebdavFile> filtered = new ArrayList<WebdavFile>();
            int i = 0;
            while (i < allFiles.length) {
                WebdavFile file = new WebdavFile(allFiles[i].getHttpURL());
                if (filter == null || filter.accept(file)) {
                    filtered.add(file);
                }
                ++i;
            }
            File[] fileArray = this.toFileArray(filtered);
            Object var9_7 = null;
            this.closeRes(res);
            return fileArray;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean mkdir() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.mkcolMethod();
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean mkdirs() {
        return this.mkdir();
    }

    public boolean renameTo(File dest) {
        WebdavResource res = null;
        try {
            res = this.createRes();
            boolean bl = res.moveMethod(dest.getAbsolutePath());
            Object var5_5 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public boolean setLastModified(long time) {
        throw new WebdavException("this method is not implemented");
    }

    public boolean setReadOnly() {
        WebdavResource res = null;
        try {
            res = this.createRes();
            res.setOverwrite(false);
            boolean bl = true;
            Object var4_4 = null;
            this.closeRes(res);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new WebdavException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.closeRes(res);
                throw throwable;
            }
        }
    }

    public static File[] listRoots() {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        throw new WebdavException("this method is not implemented");
    }

    public static File createTempFile(String prefix, String suffix) {
        return WebdavFile.createTempFile(prefix, suffix, null);
    }

    public String toString() {
        if (this.relPath != null) {
            return this.relPath;
        }
        return this.httpUrl.getUnescapedHttpURL();
    }

    public int compareTo(File pathname) {
        if (pathname instanceof WebdavFile) {
            WebdavFile df = (WebdavFile)pathname;
            return df.getPath().compareTo(this.getPath());
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((File)o);
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof WebdavFile) {
            WebdavFile xf = (WebdavFile)x;
            return xf.getPath().equals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

