/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class LabelMethod
extends XMLResponseMethodBase {
    public static final int LABEL_SET = 1;
    public static final int LABEL_ADD = 2;
    public static final int LABEL_REMOVE = 3;
    private String labelName = null;
    private int type = 0;

    public LabelMethod() {
    }

    public LabelMethod(String path, int action, String labelName) {
        super(path);
        this.labelName = labelName;
        this.type = action;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        if (this.type <= 0 || this.labelName == null) {
            throw new IllegalStateException("Action type and label name must be set before calling this function");
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "label", 0);
        String typeElement = null;
        switch (this.type) {
            case 1: {
                typeElement = "set";
                break;
            }
            case 3: {
                typeElement = "remove";
                break;
            }
            case 2: {
                typeElement = "add";
            }
        }
        printer.writeElement("D", typeElement, 0);
        printer.writeElement("D", "label-name", 0);
        printer.writeText(this.labelName);
        printer.writeElement("D", "label-name", 1);
        printer.writeElement("D", typeElement, 1);
        printer.writeElement("D", "label", 1);
        return printer.toString();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 207 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {}
    }

    public String getName() {
        return "LABEL";
    }
}

