/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.ArrayList;
import org.apache.util.DOMUtils;
import org.apache.util.URLUtil;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AclProperty
extends BaseProperty {
    public static final String TAG_NAME = "acl";

    public AclProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Ace[] getAces() {
        NodeList children = this.element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ArrayList<Ace> aces = new ArrayList<Ace>();
        int i = 0;
        while (i < children.getLength()) {
            try {
                String localName;
                Element child = (Element)children.item(i);
                String namespace = DOMUtils.getElementNamespaceURI(child);
                if (namespace != null && namespace.equals("DAV:") && "ace".equals(localName = DOMUtils.getElementLocalName(child))) {
                    aces.add(this.parseAce(child));
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return aces.toArray(new Ace[aces.size()]);
    }

    protected Ace parseAce(Element element) {
        String principal = null;
        Element child = DOMUtils.getFirstElement(element, "DAV:", "principal");
        if (child == null) {
            System.err.println("Error: mandatory element <principal> is missing !");
            System.err.println("element: " + element);
            return null;
        }
        Element href = DOMUtils.getFirstElement(child, "DAV:", "href");
        if (href != null) {
            principal = URLUtil.URLDecode(DOMUtils.getTextValue(href));
        }
        String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
        int i = 0;
        while (i < types.length && principal == null) {
            Element type = DOMUtils.getFirstElement(child, "DAV:", types[i]);
            if (type != null) {
                principal = types[i];
            }
            ++i;
        }
        if (principal == null) {
            System.err.println("Error: unknown type of principal");
            System.err.println("element: " + element);
            return null;
        }
        Ace ace = new Ace(principal);
        child = DOMUtils.getFirstElement(element, "DAV:", "grant");
        if (child == null) {
            child = DOMUtils.getFirstElement(element, "DAV:", "deny");
            ace.setNegative(true);
        }
        if (child != null) {
            NodeList privilegeElements = child.getElementsByTagNameNS("DAV:", "privilege");
            int i2 = 0;
            while (i2 < privilegeElements.getLength()) {
                Element privilegeElement = (Element)privilegeElements.item(i2);
                NodeList privileges = privilegeElement.getElementsByTagName("*");
                int j = 0;
                while (j < privileges.getLength()) {
                    Element privilege = (Element)privileges.item(j);
                    ace.addPrivilege(this.parsePrivilege(privilege));
                    ++j;
                }
                ++i2;
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "inherited")) != null) {
            href = DOMUtils.getFirstElement(child, "DAV:", "href");
            if (href != null) {
                ace.setInherited(true);
                ace.setInheritedFrom(DOMUtils.getTextValue(href));
            } else {
                System.err.println("Error: mandatory element <href> is missing !");
                return null;
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "protected")) != null) {
            ace.setProtected(true);
        }
        return ace;
    }

    protected Privilege parsePrivilege(Element privilegeElement) {
        return new Privilege(privilegeElement.getNamespaceURI(), privilegeElement.getLocalName(), null);
    }

    public String getPropertyAsString() {
        Ace[] aces = this.getAces();
        if (aces == null || aces.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(aces[0].toString());
        int i = 1;
        while (i < aces.length) {
            tmp.append(", ");
            tmp.append(aces[i].toString());
            ++i;
        }
        return tmp.toString();
    }
}

