/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;

public class SIZE
extends Protocol {
    Vector members = new Vector();
    boolean print_msg = false;
    long min_size = 0L;
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);

    public String getName() {
        return "SIZE";
    }

    public void init() {
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("print_msg");
        if (str != null) {
            this.print_msg = Boolean.valueOf(str);
            props.remove("print_msg");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Integer.parseInt(str);
            props.remove("min_size");
        }
        if (props.size() > 0) {
            System.err.println("SIZE.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                int serialized_size;
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (payload_size <= 0 || (long)(serialized_size = this.sizeOf(msg)) <= this.min_size) break;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("size of message is " + serialized_size + ", " + msg.getHeaders().size() + " headers"));
                }
                if (!this.print_msg || !this.log.isInfoEnabled()) break;
                this.log.info((Object)("headers are " + msg.getHeaders() + ", payload size=" + payload_size));
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                int serialized_size;
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (payload_size <= 0 || (long)(serialized_size = this.sizeOf(msg)) <= this.min_size) break;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("size of message is " + serialized_size + ", " + msg.getHeaders().size() + " headers"));
                }
                if (!this.print_msg || !this.log.isInfoEnabled()) break;
                this.log.info((Object)("headers are " + msg.getHeaders() + ", payload size=" + payload_size));
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sizeOf(Message msg) {
        ByteArrayOutputStream byteArrayOutputStream = this.out_stream;
        synchronized (byteArrayOutputStream) {
            try {
                this.out_stream.reset();
                ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
                msg.writeExternal(out);
                out.flush();
                return this.out_stream.size();
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

