/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service.lease;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.service.lease.Lease;
import org.jgroups.service.lease.LeaseDeniedException;
import org.jgroups.service.lease.LeaseFactoryClient;
import org.jgroups.service.lease.LeaseFactoryService;

public class LeaseFactoryClientTest
extends TestCase {
    public static final String SERVER_PROTOCOL_STACK = "UDP(mcast_addr=224.0.0.35;mcast_port=12345;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):PING(timeout=500;num_initial_members=1;down_thread=false;up_thread=false):FD(down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;down_thread=false):FRAG(frag_size=4096;down_thread=false):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=200;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false;down_thread=true;up_thread=true):pbcast.STATE_TRANSFER(down_thread=false)";
    public static final String CLIENT_PROTOCOL_STACK = "UDP(mcast_addr=224.0.0.36;mcast_port=56789;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):FRAG(frag_size=4096;down_thread=false;up_thread=false):UNICAST(timeout=5000;use_gms=false)";
    protected JChannel svcServerChannel;
    protected JChannel svcClientChannel;
    protected JChannel clientChannel;
    protected LeaseFactoryService leaseFactory;
    protected LeaseFactoryClient leaseClient;
    static /* synthetic */ Class class$org$jgroups$service$lease$LeaseFactoryClientTest;

    public LeaseFactoryClientTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.svcServerChannel = new JChannel(SERVER_PROTOCOL_STACK);
        this.svcServerChannel.setOpt(4, true);
        this.svcServerChannel.connect("server");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.svcClientChannel = new JChannel(CLIENT_PROTOCOL_STACK);
        this.svcClientChannel.connect("client");
        this.clientChannel = new JChannel(CLIENT_PROTOCOL_STACK);
        this.clientChannel.connect("client");
        this.leaseFactory = new LeaseFactoryService(this.svcServerChannel, this.svcClientChannel);
        this.leaseClient = new LeaseFactoryClient(this.clientChannel);
    }

    protected void tearDown() throws Exception {
        this.clientChannel.close();
        this.svcClientChannel.close();
        this.svcServerChannel.close();
    }

    public void test() throws Exception {
        System.out.println("testing obtaining lease...");
        Lease lease = this.leaseClient.newLease("1", "foo", 10000L, false);
        LeaseFactoryClientTest.assertTrue((String)"lease should be granted", (lease != null ? 1 : 0) != 0);
        System.out.println("lease was granted.");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.leaseClient.newLease("1", "bar", 1000L, false);
            LeaseFactoryClientTest.assertTrue((String)"Lease should not be granted.", (boolean)false);
        }
        catch (LeaseDeniedException ex) {
            // empty catch block
        }
        System.out.println("trying to cancel lease...");
        this.leaseClient.cancelLease(lease);
        System.out.println("lease was canceled.");
        lease = this.leaseClient.newLease("1", "bar", 1000L, false);
        LeaseFactoryClientTest.assertTrue((String)"new lease should have been granted.", (lease != null ? 1 : 0) != 0);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("renewing lease...");
        lease = this.leaseClient.renewLease(lease, 1000L, false);
        LeaseFactoryClientTest.assertTrue((String)"lease should have been renewed", (lease != null ? 1 : 0) != 0);
        System.out.println("lease renewed.");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            lease = this.leaseClient.renewLease(lease, 1000L, false);
            LeaseFactoryClientTest.assertTrue((String)"lease should be expired", (boolean)false);
        }
        catch (LeaseDeniedException leaseDeniedException) {
            // empty catch block
        }
        lease = this.leaseClient.newLease("1", "bar", 1000L, false);
        this.leaseClient.cancelLease(lease);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$jgroups$service$lease$LeaseFactoryClientTest == null ? (class$org$jgroups$service$lease$LeaseFactoryClientTest = LeaseFactoryClientTest.class$("org.jgroups.service.lease.LeaseFactoryClientTest")) : class$org$jgroups$service$lease$LeaseFactoryClientTest).getName()};
        TestRunner.main((String[])testCaseName);
        System.out.println("press key to return");
        try {
            System.in.read();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

