/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.stack.IpAddress;

public class DigestTest
extends TestCase {
    Digest d;
    Digest d2;
    IpAddress a1;
    IpAddress a2;
    IpAddress a3;
    static /* synthetic */ Class class$org$jgroups$tests$DigestTest;

    public DigestTest(String name) {
        super(name);
    }

    public void setUp() {
        this.d = new Digest(3);
        this.a1 = new IpAddress(5555);
        this.a2 = new IpAddress(6666);
        this.a3 = new IpAddress(7777);
        this.d.add(this.a1, 4L, 500L, 501L);
        this.d.add(this.a2, 25L, 26L, 26L);
        this.d.add(this.a3, 20L, 25L, 33L);
    }

    public void tearDown() {
    }

    public void testConstructor() {
        DigestTest.assertTrue((this.d.size() == 3 ? 1 : 0) != 0);
        this.d.reset(2);
        DigestTest.assertTrue((this.d.size() == 2 ? 1 : 0) != 0);
        this.d.reset(4);
        DigestTest.assertTrue((this.d.size() == 4 ? 1 : 0) != 0);
    }

    public void testConstructor2() {
        Digest dd = new Digest(3);
        DigestTest.assertTrue((dd.lowSeqnoAt(0) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((dd.highSeqnoAt(0) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((dd.highSeqnoSeenAt(0) == -1L ? 1 : 0) != 0);
    }

    public void testGetIndex() {
        DigestTest.assertTrue((this.d.getIndex(this.a1) == 0 ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.getIndex(this.a3) == 2 ? 1 : 0) != 0);
    }

    public void testContains() {
        DigestTest.assertTrue((boolean)this.d.contains(this.a2));
    }

    public void testSenderAt() {
        DigestTest.assertTrue((boolean)this.d.senderAt(2).equals(this.a3));
    }

    public void testResetAt() {
        this.d.resetAt(0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(0) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(0) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(0) == -1L ? 1 : 0) != 0);
    }

    public void testLowSeqnoAt() {
        DigestTest.assertTrue((this.d.lowSeqnoAt(0) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(1) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(2) == 20L ? 1 : 0) != 0);
    }

    public void testHighSeqnoAt() {
        DigestTest.assertTrue((this.d.highSeqnoAt(0) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(1) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(2) == 25L ? 1 : 0) != 0);
    }

    public void testHighSeqnoSeenAt() {
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(0) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(1) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(2) == 33L ? 1 : 0) != 0);
    }

    public void testCopy() {
        this.d = this.d.copy();
        this.testLowSeqnoAt();
        this.testHighSeqnoAt();
        this.testHighSeqnoSeenAt();
        this.testGetIndex();
        this.testContains();
        this.testSenderAt();
        this.testResetAt();
    }

    public void testNonConflictingMerge() {
        Digest cons_d = new Digest(5);
        IpAddress ip1 = new IpAddress(1111);
        IpAddress ip2 = new IpAddress(2222);
        cons_d.add(ip1, 1L, 10L, 10L);
        cons_d.add(ip2, 2L, 20L, 20L);
        cons_d.merge(this.d);
        DigestTest.assertTrue((cons_d.getIndex(ip1) == 0 ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.getIndex(ip2) == 1 ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.getIndex(this.a1) == 2 ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.getIndex(this.a2) == 3 ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.getIndex(this.a3) == 4 ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(0) == 1L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(1) == 2L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(2) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(3) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(4) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(0) == 10L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(1) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(2) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(3) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(4) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(0) == 10L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(1) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(2) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(3) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(4) == 33L ? 1 : 0) != 0);
    }

    public void testConflictingMerge() {
        Digest new_d = new Digest(2);
        new_d.add(this.a1, 5L, 450L, 501L);
        new_d.add(this.a3, 18L, 28L, 35L);
        this.d.merge(new_d);
        DigestTest.assertTrue((this.d.lowSeqnoAt(0) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(0) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(0) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(1) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(1) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(1) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(2) == 18L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(2) == 28L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(2) == 35L ? 1 : 0) != 0);
    }

    public void testSameSendersOtherIsNull() {
        DigestTest.assertFalse((boolean)this.d.sameSenders(null));
    }

    public void testSameSenders1MNullDifferentLenth() {
        this.d2 = new Digest(1);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSenders1MNullSameLength() {
        this.d2 = new Digest(3);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSendersIdentical() {
        this.d2 = this.d.copy();
        DigestTest.assertTrue((boolean)this.d.sameSenders(this.d2));
    }

    public void testSameSendersNotIdentical() {
        this.d2 = new Digest(3);
        this.d2.add(this.a1, 4L, 500L, 501L);
        this.d2.add(this.a3, 20L, 25L, 33L);
        this.d2.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertFalse((boolean)this.d.sameSenders(this.d2));
    }

    public void testSameSendersNotSameLength() {
        this.d2 = new Digest(3);
        this.d2.add(this.a1, 4L, 500L, 501L);
        this.d2.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertFalse((boolean)this.d.sameSenders(this.d2));
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$DigestTest == null ? (class$org$jgroups$tests$DigestTest = DigestTest.class$("org.jgroups.tests.DigestTest")) : class$org$jgroups$tests$DigestTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DigestTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

