/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.PERF_TP;

public class PerfTpTest {
    JChannel ch = null;
    PERF_TP tp = null;

    public static void main(String[] args) {
        String props = null;
        int num_msgs = 1000;
        int size = 1000;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-num".equals(args[i])) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            PerfTpTest.help();
            return;
        }
        try {
            new PerfTpTest().start(props, num_msgs, size);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("PerfTpTest [-help] [-props <properties>] [-num <num msgs>] [-size <msg size (in bytes)]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String props, int num_msgs, int size) throws ChannelException, InterruptedException {
        byte[] buf = new byte[size];
        this.ch = new JChannel(props);
        this.ch.connect("demo");
        this.tp = PERF_TP.getInstance();
        this.tp.setExpectedMessages(num_msgs);
        for (int i = 0; i < num_msgs; ++i) {
            Message msg = new Message(null, null, buf);
            this.ch.send(msg);
        }
        PERF_TP i = this.tp;
        synchronized (i) {
            if (!this.tp.done()) {
                this.tp.wait();
            }
        }
        long total = this.tp.getTotalTime();
        double msgs_per_ms = (long)num_msgs / total;
        double msgs_per_sec = msgs_per_ms * 1000.0;
        double time_per_msg = (double)total / (double)num_msgs;
        double usec_per_msg = time_per_msg * 1000.0;
        System.out.println("num_msgs = " + num_msgs + ", total_time = " + total + "ms");
        System.out.println("msgs/millisec = " + msgs_per_ms + ", msgs/sec = " + msgs_per_sec + "\ntime/msg = " + time_per_msg + " ms" + " (" + usec_per_msg + " usec/msg)");
        this.ch.close();
    }
}

