/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.TreeMap;
import org.jgroups.util.Util;

public class Ser {
    public static void main(String[] args) {
        Ser s = new Ser();
        int num = 10000;
        boolean populate = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-populate".equals(args[i])) {
                populate = true;
                continue;
            }
            Ser.help();
            return;
        }
        try {
            s.start(num, populate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("Ser [-help] [-num <number>] [-populate]");
    }

    public void start(int num, boolean populate) throws Exception {
        if (populate) {
            HashMap map = new HashMap();
            System.out.println("-- populating map with " + num + " entries");
            for (int i = 0; i < num; ++i) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("XSAM_DS_KEY1", "VALUE FOR THE FIRST KEY");
                treeMap.put("XSAM_DS_KEY2", "VALUE FOR THE SECOND KEY");
                treeMap.put("XSAM_DS_KEY3", "VALUE FOR THE THIRD  KEY");
                treeMap.put("XSAM_DS_KEY4", "VALUE FOR THE FOURTH  KEY");
                treeMap.put("XSAM_DS_KEY5", "VALUE FOR THE FIFTH KEY");
                treeMap.put("XSAM_DS_KEY6", "VALUE FOR THE SIXTH KEY");
                treeMap.put("XSAM_DS_KEY7", "VALUE FOR THE SEVENTH  KEY");
                treeMap.put("XSAM_DS_KEY8", "VALUE FOR THE EIGHT KEY");
                treeMap.put("XSAM_DS_KEY9", "VALUE FOR THE NINE  KEY");
                treeMap.put("XSAM_DS_KEY10", "VALUE FOR THE TEN  KEY");
                String key = "KEY" + i + System.currentTimeMillis();
                map.put(key, treeMap);
            }
            System.out.println("-- serializing map");
            byte[] buf = Util.objectToByteBuffer(map);
            System.out.println("-- serialized size: " + buf.length + " bytes");
            System.out.println("-- writing to file");
            FileOutputStream f = new FileOutputStream("dump.txt");
            f.write(buf, 0, buf.length);
            f.close();
            System.out.println("-- mem: " + Util.memStats(true));
            System.out.println("-- clearing map, nullifying map, f, buf");
            map.clear();
            f = null;
            buf = null;
            Runtime.getRuntime().gc();
            System.out.println("-- mem: " + Util.memStats(true));
        }
        Runtime rt = Runtime.getRuntime();
        long used_mem = rt.totalMemory() - rt.freeMemory();
        System.out.println("-- used memory: " + used_mem);
        System.out.println("-- reading buf from file");
        FileInputStream fin = new FileInputStream("dump.txt");
        byte[] new_buf = new byte[fin.available()];
        fin.read(new_buf, 0, new_buf.length);
        System.out.println("-- buffer size is " + new_buf.length + " bytes");
        System.out.println("-- mem: " + Util.memStats(true));
        HashMap new_map = (HashMap)Util.objectFromByteBuffer(new_buf);
        System.out.println("new_map size: " + new_map.size());
        long used_mem2 = rt.totalMemory() - rt.freeMemory();
        double factor = (used_mem2 - used_mem) / (long)new_buf.length;
        System.out.println("*** serialized size=" + new_buf.length + ", diff in memory=" + (used_mem2 - used_mem) + " bytes (factor: " + factor + ") *** ");
        System.out.println("-- mem: " + Util.memStats(true));
    }
}

