/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private OutputStream os;
    static final int one = 1;

    public IfxDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.os = outputStream;
    }

    public final void write(int n) throws IOException {
        this.os.write(n);
        ++this.written;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
    }

    public final void writePadded(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
        this.written += n2;
        if ((n2 & 1) >= 1) {
            this.write(0);
        }
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void writePadded(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInt(n);
        this.write(byArray);
    }

    public final void flush() throws IOException {
        this.os.flush();
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string);
        this.write(byArray, 2, byArray.length - 2);
    }

    public final void writeBytes(String string, String string2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string, string2);
        this.write(byArray, 2, byArray.length - 2);
    }

    public final void writeChar(String string) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeChar(String string, String string2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxChar(string, string2);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeChars(String string) throws IOException {
        this.writeChar(string);
    }

    public final void writeDate(Date date) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDate(date);
        this.write(byArray);
    }

    public final void writeDateTime(Timestamp timestamp) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDateTime(timestamp);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInterval(IntervalDF intervalDF) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalDF);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeInterval(IntervalYM intervalYM) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalYM);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeDecimal(BigDecimal bigDecimal) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDecimal(bigDecimal);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeDouble(double d) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeReal(float f) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public final void writeSmallInt(short s) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s);
        this.write(byArray);
    }

    public final void writeShort(int n) throws IOException {
        short s = (short)n;
        this.writeSmallInt(s);
    }

    public final void writeShort(short s) throws IOException {
        this.writeSmallInt(s);
    }

    public final void writeLongInt(long l) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongInt(l);
        this.write(byArray);
    }

    public final void writeLong(long l) throws IOException {
        this.writeLongInt(l);
    }
}

