/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxCallableStatement;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxCallableStatement
extends IfxPreparedStatement
implements CallableStatement,
IfmxCallableStatement {
    private IfxProtocol prot = null;
    private IfxConnection conn = null;
    private boolean null_ind = false;
    private int outIfxType = -1;
    private int outScale = -1;
    private int outIndex = -1;
    private String outName = null;
    private String signature = null;
    private IfxObject outParam = null;
    private IfxColumnInfo outParamInfo = null;

    IfxCallableStatement(Connection connection, String string) throws SQLException {
        super((IfxConnection)connection);
        Object object;
        this.conn = (IfxConnection)connection;
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            object = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{object};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        this.setSqlString(string);
        try {
            this.setupExecutePrepare();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -9752) {
                this.hasOutParameter = true;
                object = IfxErrMsg.getMessage(-79820);
                this.chainWarnings(new SQLWarning((String)object, "U0001", 79820));
                this.outIndex = this.numqmarks;
            }
            throw sQLException;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        ResultSet resultSet = null;
        if (!this.hasOutParameter) {
            resultSet = super.executeQuery();
        } else {
            if (this.vector.size() != this.numqmarks) {
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            if (this.vector.elementAt(this.outIndex - 1) == null) {
                throw IfxErrMsg.getSQLException(-79824, this.jconn);
            }
            this.setSignature();
            resultSet = this.executeFastPath(true);
        }
        return resultSet;
    }

    public void IfxSetNull(int n, int n2) throws SQLException {
        super.setNull(n, 0, n2);
    }

    public void IfxSetNull(int n, int n2, String string) throws SQLException {
        if (!IfxTypes.isComplexType(n2) && n2 != 40 && n2 != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        super.setNull(n, 0, n2, string);
    }

    public void setArray(int n, Array array, String string) throws SQLException {
        super.setArray(n, array, string);
    }

    public void setObject(int n, Array array, String string) throws SQLException {
        super.setObject(n, (Object)array, string);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setBoolean(n, bl, 45);
    }

    private void setSignature() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.outIfxType == -1) {
            throw IfxErrMsg.getSQLException(-79822, this.jconn);
        }
        stringBuffer.append("function ");
        String string = "(    ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandString.toLowerCase().trim(), string);
        String string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        stringBuffer.append(string2);
        stringBuffer.append("(");
        IfxObject ifxObject = null;
        int n = 0;
        while (n < this.vector.size() - 1) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if ((ifxObject = (IfxObject)this.vector.elementAt(n)) == null) {
                throw IfxErrMsg.getSQLException(-79823, this.jconn);
            }
            int n2 = ifxObject.getIfxType();
            short s = ifxObject.getEncodedLength();
            String string3 = ifxObject.getExtendedTypeName().trim();
            this.getTypeName(n2, s, string3, stringBuffer);
            ++n;
        }
        if (this.vector.size() > 0) {
            stringBuffer.append(", ");
        }
        this.getTypeName(this.outIfxType, this.outScale, this.outName, stringBuffer);
        stringBuffer.append(")");
        this.signature = stringBuffer.toString();
    }

    private void getTypeName(int n, int n2, String string, StringBuffer stringBuffer) throws SQLException {
        switch (n) {
            case 10: 
            case 14: {
                if (n2 == 0) {
                    throw IfxErrMsg.getSQLException(-79717, this.jconn);
                }
                stringBuffer.append(IfxTypes.IfxTypeToName((short)n));
                stringBuffer.append(" ");
                stringBuffer.append(IfxDateTime.getQualifierName((short)n2, n));
                break;
            }
            case 3: {
                stringBuffer.append("double precision");
                break;
            }
            case 40: 
            case 41: {
                if (string == null || string.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                stringBuffer.append(string);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (string == null || string.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                stringBuffer.append(string);
                break;
            }
            default: {
                stringBuffer.append(IfxTypes.IfxTypeToName(n));
            }
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.registerOutParameter(n, n2, 0, null);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (string != null && n2 != 2003 && n2 != 2000 && n2 != 2002 && n2 != 2001) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.registerOutParameter(n, n2, 0, string);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.registerOutParameter(n, n2, n3, null);
    }

    private void registerOutParameter(int n, int n2, int n3, String string) throws SQLException {
        int n4;
        this.verify(n);
        if (this.ambiguousSQLType(n2)) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        if (n2 == 6 && !this.jconn.getMapFloat()) {
            n2 = 7;
        }
        if ((n4 = IfxTypes.FromJDBCToIfxType(n2)) == -99) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        this.outIfxType = n4;
        this.outScale = n3;
        this.outName = string;
        if (this.outScale == 0 && this.outIfxType == 10) {
            this.outScale = n2 == 93 ? (int)IfxDateTime.getQualifier((byte)0, (byte)15) : (int)IfxDateTime.getQualifier((byte)6, (byte)10);
        }
    }

    public void IfxRegisterOutParameter(int n, int n2) throws SQLException {
        this.IfxRegisterOutParameter(n, n2, 0, null);
    }

    public void IfxRegisterOutParameter(int n, int n2, String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!IfxTypes.isComplexType(n2) && n2 != 40 && n2 != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.IfxRegisterOutParameter(n, n2, 0, string);
    }

    public void IfxRegisterOutParameter(int n, int n2, int n3) throws SQLException {
        this.IfxRegisterOutParameter(n, n2, n3, null);
    }

    private void IfxRegisterOutParameter(int n, int n2, int n3, String string) throws SQLException {
        this.verify(n);
        this.outIfxType = n2;
        this.outScale = n3;
        this.outName = string;
    }

    public boolean wasNull() throws SQLException {
        if (!this.hasOutParameter || this.outParam == null) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        return this.outParam.isNull();
    }

    public String getString(int n) throws SQLException {
        String string = null;
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        this.savedResult.blobCheck(this.outParam);
        string = this.outParam.toString();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return false;
        }
        boolean bl = this.outParam.toBoolean();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0;
        }
        byte by = this.outParam.toByte();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return by;
    }

    public short getShort(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0;
        }
        short s = this.outParam.toShort();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return s;
    }

    public int getInt(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0;
        }
        int n2 = this.outParam.toInt();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0L;
        }
        long l = this.outParam.toLong();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0.0f;
        }
        float f = this.outParam.toFloat();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return 0.0;
        }
        double d = this.outParam.toDouble();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = this.outParam.toDecimal().setScale(n2, 4);
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        return this.outParam.toDecimal();
    }

    public byte[] getBytes(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        this.savedResult.blobCheck(this.outParam);
        byte[] byArray = this.outParam.toBytes();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        Date date = this.outParam.toDate();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return date;
    }

    public Time getTime(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        Time time = this.outParam.toTime();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return time;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        Timestamp timestamp = this.outParam.toTimestamp();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return timestamp;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        long l = timestamp.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        Timestamp timestamp2 = new Timestamp(l);
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    public Object getObject(int n) throws SQLException {
        this.verify(n);
        Object object = null;
        object = this.jconn != null ? this.getObject(n, this.jconn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.verify(n);
        Object object = null;
        if (this.outParam != null && !this.outParam.isNull()) {
            this.savedResult.blobCheck(this.outParam);
            this.outParam.setTypeMap(map);
            object = this.outParam.toObject();
            DataTruncation dataTruncation = this.outParam.getWarning();
            if (dataTruncation != null) {
                this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
            }
        }
        return object;
    }

    public Array getArray(int n) throws SQLException {
        this.verify(n);
        IfxCollection ifxCollection = (IfxCollection)this.outParam;
        Array array = null;
        if (this.outParam != null && !this.outParam.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    public Blob getBlob(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        this.savedResult.blobCheck(this.outParam);
        Blob blob = this.outParam.toBlob();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        this.verify(n);
        if (this.outParam == null || this.outParam.isNull()) {
            return null;
        }
        this.savedResult.blobCheck(this.outParam);
        Clob clob = this.outParam.toClob();
        DataTruncation dataTruncation = this.outParam.getWarning();
        if (dataTruncation != null) {
            this.chainWarnings(new DataTruncation(n, false, true, dataTruncation.getDataSize(), dataTruncation.getTransferSize()));
        }
        return clob;
    }

    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": CallableStatement.getRef(int).", this.jconn);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.verify(n);
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        long l = date.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Date(l);
    }

    public boolean hasOutParameter() {
        return this.hasOutParameter;
    }

    private ResultSet executeFastPath(boolean bl) throws SQLException {
        IfxFParam ifxFParam = null;
        IfxResultSetMetaData ifxResultSetMetaData = null;
        IfxObject ifxObject = null;
        Vector<IfxObject> vector = null;
        if (this.signature == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        vector = this.savedResult.executeFastPath(this.signature, this.vector, this.hasOutParameter, bl);
        if (!((IfxConnection)super.getConnection()).isDirect()) {
            ifxFParam = this.savedResult.getFParam();
            this.outParam = (IfxObject)vector.elementAt(0);
            this.outParamInfo = ifxFParam.colInfoArray[0];
            ifxResultSetMetaData = new IfxResultSetMetaData(1, this.jconn);
            ifxResultSetMetaData.copyColumnInfo(1, ifxFParam.colInfoArray[1]);
            ifxFParam.colInfoArray[1] = null;
            ifxObject = (IfxObject)vector.elementAt(1);
        } else {
            int n = 0;
            ifxResultSetMetaData = (IfxResultSetMetaData)this.savedResult.getMetaData();
            vector = new Vector<IfxObject>();
            vector.setSize(1);
            n = ifxResultSetMetaData.getColumnCount();
            ifxObject = this.savedResult.getValueFastPath(n);
            vector.setElementAt(ifxObject, 0);
            this.outParam = (IfxObject)vector.elementAt(0);
            this.outParamInfo = ifxResultSetMetaData.getColumnInfo(n);
            ifxObject = this.savedResult.getValueFastPath(1);
        }
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.jconn, ifxResultSetMetaData);
        ifxClientResultSet.newRow(1);
        if (ifxObject.isNull()) {
            ifxClientResultSet.updateNull(1, 1);
        } else {
            ifxClientResultSet.updateIfxObject(1, 1, (Object)ifxObject);
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setType(1003);
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
        return ifxClientResultSet;
    }

    private void verify(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!this.hasOutParameter) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        this.checkParameterIndex(n, this.numqmarks);
        if (n != this.outIndex) {
            throw IfxErrMsg.getSQLException(-79828, this.jconn);
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.registerOutParameter(String,int)", this.jconn);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.registerOutParameter(String,int,int)", this.jconn);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.registerOutParameter(String,int,String)", this.jconn);
    }

    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(int)", this.conn);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setURL(int, URL)", this.jconn);
    }

    public void setNull(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNull(String,int)", this.jconn);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNull(String,int)", this.jconn);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setBoolean(String,boolean)", this.jconn);
    }

    public void setByte(String string, byte by) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setByte(String,byte)", this.jconn);
    }

    public void setShort(String string, short s) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setShort(String,short)", this.jconn);
    }

    public void setInt(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setInt(String,int)", this.jconn);
    }

    public void setLong(String string, long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setLong(String,long)", this.jconn);
    }

    public void setFloat(String string, float f) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setFloat(String,float)", this.jconn);
    }

    public void setDouble(String string, double d) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setDouble(String,double)", this.jconn);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setBigDecimal(String,BigDecimal)", this.jconn);
    }

    public void setString(String string, String string2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setString(String,String)", this.jconn);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setBytes(String,byte[])", this.jconn);
    }

    public void setDate(String string, Date date) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setDate(String,Date)", this.jconn);
    }

    public void setTime(String string, Time time) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setTime(String,Time)", this.jconn);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setTimestamp(String,Timestamp)", this.jconn);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setAsciiStream(String,InputStream)", this.jconn);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setBinaryStream(String,InputStream)", this.jconn);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setObject(String,Object,int)", this.jconn);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setObject(String,Object,int)", this.jconn);
    }

    public void setObject(String string, Object object) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setObject(String,Object)", this.jconn);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setChracterStream(String,ChracterStream)", this.jconn);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setDate(String,Date,Calendar)", this.jconn);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setDate(String,Time)", this.jconn);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setTimestamp(String,Timestamp)", this.jconn);
    }

    public String getString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getString(String)", this.jconn);
    }

    public boolean getBoolean(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getBoolean(String,String)", this.jconn);
    }

    public byte getByte(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getByte(String)", this.jconn);
    }

    public short getShort(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getShort(String)", this.jconn);
    }

    public int getInt(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getInt(String)", this.jconn);
    }

    public long getLong(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getLong(String)", this.jconn);
    }

    public float getFloat(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getFloat(String)", this.jconn);
    }

    public double getDouble(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getDouble(String)", this.jconn);
    }

    public byte[] getBytes(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getBytes(String)", this.jconn);
    }

    public Date getDate(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getDate(String)", this.jconn);
    }

    public Time getTime(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getTime(String)", this.jconn);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getTimestamp(String)", this.jconn);
    }

    public Object getObject(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getObject(String)", this.jconn);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getBigDecimal(String)", this.jconn);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getObject(String,Map)", this.jconn);
    }

    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getRef(String)", this.jconn);
    }

    public Blob getBlob(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getBlob(String)", this.jconn);
    }

    public Clob getClob(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getClob(String)", this.jconn);
    }

    public Array getArray(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getArray(String)", this.jconn);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getDate(String,Calendar)", this.jconn);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getTime(String,Calendar)", this.jconn);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getTimestamp(String,Calendar)", this.jconn);
    }

    public URL getURL(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(String)", this.conn);
    }
}

