/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxCblob
extends IfxLob
implements Clob {
    public IfxCblob() {
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxLocator ifxLocator) {
        this.locatorPointer = ifxLocator;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    public IfxCblob(IfxConnection ifxConnection, IfxLocator ifxLocator, int n) throws SQLException {
        this.conn = ifxConnection;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(ifxConnection);
        this.smb.IfxLoOpen(ifxLocator, n);
    }

    public IfxCblob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this(ifxConnection, ifxLocator, 8);
    }

    protected IfxCblob(byte[] byArray) {
        this.blobBuffer = byArray;
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(InputStream inputStream) {
        this.blobStream = inputStream;
        this.ifxType = (short)3;
        this.smartBlobMode = 2;
    }

    protected IfxCblob(IfxTmpFile ifxTmpFile) {
        this.tempBlobFile = ifxTmpFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)3;
        this.smartBlobMode = 0;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n) throws SQLException {
        super(connection, inputStream, n);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n, String string) throws SQLException {
        super(connection, inputStream, n, string);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, InputStream inputStream, int n, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, inputStream, n, ifxLobDescriptor);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string) throws SQLException {
        super(connection, string.getBytes());
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string, String string2) throws SQLException {
        super(connection, string.getBytes(), string2);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxCblob(Connection connection, String string, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        super(connection, string.getBytes(), ifxLobDescriptor);
        this.ifxType = (short)3;
        this.smartBlobMode = 1;
    }

    public IfxLocator getLocator() throws SQLException {
        return super.getLocator();
    }

    public long length() {
        return this.blobSize;
    }

    public String getSubString(long l, int n) {
        byte[] byArray = super.getPortion(l, n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public Reader getCharacterStream() throws SQLException {
        String string = this.conn.getdbEncoding();
        try {
            if (string != null) {
                return new InputStreamReader(super.getStream(), string);
            }
            return new InputStreamReader(super.getStream());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return super.getStream();
    }

    public long position(String string, long l) throws SQLException {
        long l2 = l - 1L;
        byte[] byArray = super.getPortion(1L, this.blobSize);
        if (byArray == null) {
            return -1L;
        }
        String string2 = new String(byArray);
        long l3 = string2.indexOf(string, (int)l2);
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    public void setAsciiStream(long l, InputStream inputStream, int n) throws SQLException {
        if (this.ifxType != 3) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        super.setStream(inputStream, n);
    }

    public void setSubString(long l, String string, int n) throws SQLException {
        if (this.ifxType != 3) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
        this.smb.IfxLoSeek(this.smb.getHandle(), l, 0);
        super.setBuffer(string.getBytes());
    }

    public void close() throws SQLException {
        super.close();
    }

    public long seek(long l, int n) throws SQLException {
        return super.seek(l, n);
    }

    public long where() throws SQLException {
        return super.where();
    }

    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    public void truncate(long l) throws SQLException {
        super.truncate(l);
    }

    public int setString(long l, String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Cblob.setString(long,String)", this.conn);
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Cblob.setString(long,String,int,int)", this.conn);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Cblob.setAsciiStream(long)", this.conn);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Cblob.setCharacterStream(long)", this.conn);
    }

    protected synchronized void finalize() {
        try {
            if (this.smb != null) {
                ((IfxSqliConnect)this.conn).addToBlobList(this.smb);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

