/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxComplexSQLOutput;
import com.informix.jdbc.IfxArray;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxIntervalDF;
import com.informix.jdbc.IfxIntervalYM;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxComplexOutput
extends IfxSQLOutput
implements IfmxComplexSQLOutput {
    private Map typeMap = null;
    private boolean isRow = false;
    private boolean isNested = false;
    private Vector typeInfoVector = null;
    private Vector parentTypeInfoVector = null;
    private Vector elementOffsetVector = new Vector();
    private int typeInfoCount = 0;
    private String extendedName = "";
    private boolean isNull = true;
    private short identsize = 0;
    private int currentIfxType = -99;
    private int currentIfxLength = 0;
    private int currentExtendedId = 0;
    private int typeIndex = -1;
    private boolean isTyped = false;
    private boolean atNextType = false;
    private static final short NESTED_COLLHDRSIZE = 16;
    private static final short COLL_ALIGN = 8;
    private static final short COLL_FLAGHASH_SIZE = 8;
    private static final String T_COMMA = ",";
    private static String T_LPAREN = "(";
    private static String T_RPAREN = ")";
    private static String T_SPACE = " ";
    private static final int CT_TYPE = 1;
    private static final int TYPE = 2;
    private static final int LENGTH = 3;
    private static final int NEXTELEMENT = 4;
    private static final int LPAREN = 5;
    private static final int RPAREN = 6;
    private static final int FIELDNAME = 7;
    private static final int NOTNULL = 8;
    private static final int CTEND = 9;
    private static String currentToken = null;
    private static boolean advanceToken = true;
    private static int previousState = -1;

    IfxComplexOutput(boolean bl, boolean bl2) throws SQLException {
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean bl, boolean bl2, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean bl, boolean bl2, Object object, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        if (object == null || !(object instanceof IfxColumnInfo)) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, Vector, Connection)", ifxConnection);
        }
        Vector<Object> vector = new Vector<Object>();
        vector.add(object);
        this.setTypeInfoVector(vector);
    }

    IfxComplexOutput(boolean bl, boolean bl2, String string, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", ifxConnection);
        }
        Vector vector = this.getTypeInfoVector(string);
        this.setTypeInfoVector(vector);
    }

    IfxComplexOutput(boolean bl, String string, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = false;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", ifxConnection);
        }
        Vector vector = this.getTypeInfoVector(string);
        this.setTypeInfoVector(vector);
    }

    boolean isNull() {
        return this.isNull;
    }

    void clear() {
        this.elementOffsetVector = new Vector();
        this.extendedName = "";
        this.isNull = true;
        this.reset();
    }

    private void clearTypeInfo() {
        this.parentTypeInfoVector = null;
        this.typeInfoVector = null;
        this.typeInfoCount = 0;
    }

    void setTypeMap(Map map) {
        this.typeMap = map;
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        super.setConnection(ifxConnection);
        this.identsize = ifxConnection.isLongID() ? (short)128 : (short)18;
    }

    private void addTypeAndOffsetInfo(int n, int n2, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = null;
        this.isNull = false;
        if (this.isTyped) {
            this.getNextType(n, n2, string);
            n = this.currentIfxType;
        } else {
            if (this.isRow) {
                throw IfxErrMsg.getSQLException(-79716, ": addTypeAndOffsetInfo() it's a row", this.conn);
            }
            if (this.typeInfoVector.size() == 0) {
                ifxColumnInfo = new IfxColumnInfo();
                ifxColumnInfo.SQLtype = n;
                ifxColumnInfo.Nullable = false;
                ifxColumnInfo.ColLength = (short)n2;
                if (string != null) {
                    ifxColumnInfo.ExtendedName = string;
                    if (n == 22) {
                        ifxColumnInfo.IsNamedRow = true;
                    } else if (n == 40) {
                        if (string.compareToIgnoreCase("blob") == 0) {
                            ifxColumnInfo.ExtendedId = 10;
                        } else if (string.compareToIgnoreCase("clob") == 0) {
                            ifxColumnInfo.ExtendedId = 11;
                        }
                    }
                }
                this.typeInfoVector.addElement(ifxColumnInfo);
            }
        }
        this.addElementOffset(n);
    }

    private void addElementOffset(int n) {
        int n2 = this.bStream.size();
        if (this.isRow || IfxTypes.isUDT(n) || IfxTypes.isComplexType(n)) {
            Integer n3 = new Integer(n2);
            Integer n4 = null;
            boolean bl = true;
            if (this.elementOffsetVector.size() > 0) {
                n4 = (Integer)this.elementOffsetVector.lastElement();
            }
            if (n4 != null && n4.intValue() == n3.intValue()) {
                bl = false;
            }
            if (bl) {
                this.elementOffsetVector.addElement(n3);
            }
        }
    }

    public void writeInt(int n) throws SQLException {
        if (!this.isRow && n == Integer.MIN_VALUE) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(2, 4, null);
        try {
            this.os.writeInt(n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeString(String string) throws SQLException {
        if (!this.isRow && string == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        try {
            if (this.isTyped) {
                this.writeStringWithLength(string);
            } else {
                this.addTypeAndOffsetInfo(43, 2048, null);
                if (string == null) {
                    int n = 1;
                    this.os.write(n);
                } else {
                    int n = 0;
                    this.os.write(n);
                    byte[] byArray = JavaToIfxType.JavaToIfxInt(string.length());
                    this.os.write(byArray, 0, byArray.length);
                    byArray = string.getBytes();
                    this.os.write(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    private void writeStringWithLength(String string) throws SQLException {
        String string2 = null;
        if (this.conn != null) {
            string2 = this.conn.getclLocale();
        }
        this.isNull = false;
        this.getNextType(-99, 0, null);
        if (!IfxTypes.isString(this.currentIfxType)) {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, string2);
        }
        this.addElementOffset(this.currentIfxType);
        int n = this.currentIfxLength;
        try {
            if (this.currentIfxType == 13 || this.currentIfxType == 16) {
                if (string == null && n < 2) {
                    n = 0;
                    string = "";
                }
                if (string == null) {
                    byte[] byArray = new byte[]{1, 0};
                    this.os.write(byArray, 0, byArray.length);
                    String string3 = stringUtil.fixLength(string, n - 2, ' ');
                    byArray = string3.getBytes();
                    this.os.write(byArray, 0, byArray.length);
                } else if (n == 0) {
                    byte[] byArray = new byte[]{0};
                    this.os.write(byArray, 0, byArray.length);
                } else {
                    if (string.length() > 255) {
                        n = 255;
                    }
                    this.os.write((byte)n);
                    String string4 = stringUtil.fixLength(string, n, ' ');
                    byte[] byArray = string4.getBytes();
                    this.os.write(byArray, 0, byArray.length);
                }
            } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
                String string5 = stringUtil.fixLength(string, n, ' ');
                byte[] byArray = string5.getBytes();
                if (string == null) {
                    byArray[0] = 0;
                }
                this.os.write(byArray, 0, byArray.length);
            } else if (string == null) {
                int n2 = 1;
                this.os.write(n2);
            } else {
                int n3 = 0;
                this.os.write(n3);
                byte[] byArray = JavaToIfxType.JavaToIfxInt(string.length());
                this.os.write(byArray, 0, byArray.length);
                byArray = string.getBytes();
                this.os.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(SQLData sQLData) throws SQLException {
        if (!this.isRow && sQLData == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo ifxColumnInfo = null;
        ifxColumnInfo = this.isTyped ? (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex + 1) : (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
        if (ifxColumnInfo.SQLtype == 40 || ifxColumnInfo.SQLtype == 41) {
            this.writeUDT(sQLData);
            return;
        } else if (ifxColumnInfo.IsDistinct) {
            this.writeDistinct(sQLData);
            return;
        } else {
            if (ifxColumnInfo.SQLtype != 22) throw IfxErrMsg.getSQLException(-79777, this.conn);
            if (sQLData == null || sQLData instanceof Struct) {
                this.writeStruct((Struct)((Object)sQLData));
                return;
            } else {
                if (!(sQLData instanceof SQLData)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeNestedRow(sQLData);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object object) throws SQLException {
        if (!this.isRow && object == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo ifxColumnInfo = null;
        ifxColumnInfo = this.isTyped ? (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex + 1) : (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
        if (IfxTypes.isCollection(ifxColumnInfo.SQLtype)) {
            if (object == null || object instanceof Collection) {
                this.writeNestedCollection((Collection)object);
                return;
            } else {
                if (!(object instanceof Array)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeArray((Array)object);
            }
            return;
        } else {
            if (ifxColumnInfo.SQLtype != 14) throw IfxErrMsg.getSQLException(-79777, this.conn);
            if (object == null || object instanceof IntervalDF) {
                this.writeIntervalDF((IntervalDF)object);
            }
            if (!(object instanceof IntervalYM)) throw IfxErrMsg.getSQLException(-79777, this.conn);
            this.writeIntervalYM((IntervalYM)object);
        }
    }

    public void writeStruct(Struct struct) throws SQLException {
        IfxComplexOutput ifxComplexOutput = null;
        if (this.isTyped) {
            this.getNextType(22, 0, null);
        }
        this.addElementOffset(22);
        if (struct == null && !this.isRow) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (struct != null) {
            Map<String, Class<?>> map = this.conn.getTypeMap();
            Object[] objectArray = struct.getAttributes(map);
            String string = struct.getSQLTypeName();
            if (string == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            if (objectArray.length == 0) {
                throw IfxErrMsg.getSQLException(-79792, this.conn);
            }
            ifxComplexOutput = this.isTyped ? new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(true, true, string, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
                ifxColumnInfo.Nullable = false;
                this.typeInfoVector.add(ifxColumnInfo);
            }
            int n = 0;
            while (n < objectArray.length) {
                int n2;
                this.isNull = false;
                if (objectArray[n] == null) {
                    this.getNextType(-99, 0, null);
                    this.atNextType = true;
                    n2 = this.currentIfxType;
                } else {
                    n2 = this.getIfxType(objectArray[n], ifxComplexOutput.getIsTyped());
                }
                ifxComplexOutput.writeElement(objectArray[n], n2);
                ++n;
            }
        } else {
            ifxComplexOutput = new IfxComplexOutput(true, true, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
                ifxColumnInfo.Nullable = false;
                this.typeInfoVector.add(ifxColumnInfo);
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
    }

    private void writeNestedRow(SQLData sQLData) throws SQLException {
        Object object;
        IfxComplexOutput ifxComplexOutput = null;
        if (this.isTyped) {
            this.getNextType(22, 0, null);
        }
        this.addElementOffset(this.currentIfxType);
        if (sQLData == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            this.isNull = true;
            return;
        }
        if (this.isTyped) {
            ifxComplexOutput = new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn);
        } else {
            object = sQLData.getSQLTypeName();
            if (object == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            ifxComplexOutput = new IfxComplexOutput(true, true, (String)object, this.conn);
        }
        this.addElementOffset(22);
        this.isNull = false;
        ifxComplexOutput.writeRow(sQLData);
        this.writeNestedData(ifxComplexOutput);
        if (!this.isTyped && this.typeInfoVector.size() == 0) {
            object = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
            ((IfxColumnInfo)object).Nullable = false;
            this.typeInfoVector.add(object);
        }
    }

    private void writeNestedCollection(Collection collection) throws SQLException {
        Object object;
        Object object2;
        if (!this.isRow && collection == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (collection == null) {
            this.addTypeAndOffsetInfo(20, 0, null);
        } else {
            this.addTypeAndOffsetInfo(this.getOverrideIfxType(collection), 0, null);
        }
        IfxComplexOutput ifxComplexOutput = null;
        ifxComplexOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
        if (collection == null) {
            this.addElementOffset(this.currentIfxType);
            this.writeNestedData(ifxComplexOutput);
            return;
        }
        this.isNull = false;
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            ifxComplexOutput.isNull = false;
            this.addTypeAndOffsetInfo(-99, 0, null);
        } else {
            object2 = iterator.next();
            object = object2.getClass();
            int n = this.getIfxType(object2, ifxComplexOutput.getIsTyped());
            while (true) {
                this.addElementOffset(n);
                ifxComplexOutput.writeElement(object2, n);
                if (!iterator.hasNext()) break;
                object2 = iterator.next();
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
        if (!this.isTyped) {
            object2 = (IfxColumnInfo)this.typeInfoVector.lastElement();
            if (((IfxColumnInfo)object2).child != null) {
                if (this.isUnknownType((IfxColumnInfo)((IfxColumnInfo)object2).child.get(0))) {
                    ((IfxColumnInfo)object2).child = ifxComplexOutput.getTypeInfoVector();
                }
            } else {
                ((IfxColumnInfo)object2).child = ifxComplexOutput.getTypeInfoVector();
            }
            object = (IfxColumnInfo)((IfxColumnInfo)object2).child.get(0);
            ((IfxColumnInfo)object).Nullable = false;
        }
    }

    private void writeUDT(Object object) throws SQLException {
        if (object == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
            this.addTypeAndOffsetInfo(40, 0, ifxColumnInfo.ExtendedName);
            IfxObject ifxObject = IfxValue.makeInstance(this.conn, ifxColumnInfo);
            byte[] byArray = ifxObject.toIfx();
            try {
                this.os.write(byArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        if (!(object instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        SQLData sQLData = (SQLData)object;
        IfxUDTOutput ifxUDTOutput = new IfxUDTOutput(this.conn);
        sQLData.writeSQL(ifxUDTOutput);
        String string = ((SQLData)object).getSQLTypeName();
        if (string == null || string == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, ifxUDTOutput.length(), string);
        try {
            this.os.writeByte(0);
            byte[] byArray = JavaToIfxType.JavaToIfxInt(ifxUDTOutput.length());
            this.os.write(byArray);
            byArray = ifxUDTOutput.toByteArray();
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        ifxUDTOutput.reset();
    }

    private void writeDistinct(Object object) throws SQLException {
        if (!this.isRow && object == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (!(object instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        IfxDistinctOutput ifxDistinctOutput = new IfxDistinctOutput(null, this.conn);
        SQLData sQLData = (SQLData)object;
        String string = sQLData.getSQLTypeName();
        if (string == null || string == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, 0, string);
        sQLData.writeSQL(ifxDistinctOutput);
        try {
            byte[] byArray = new byte[]{0};
            this.os.write(byArray, 0, 1);
            byte[] byArray2 = JavaToIfxType.JavaToIfxInt(ifxDistinctOutput.length());
            this.os.write(byArray2, 0, byArray2.length);
            byArray2 = ifxDistinctOutput.toByteArray();
            this.os.write(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        ifxDistinctOutput.reset();
    }

    void writeRow(SQLData sQLData) throws SQLException {
        this.extendedName = sQLData.getSQLTypeName();
        if (this.extendedName == null || this.extendedName == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            Vector vector = this.getTypeInfoVector(this.extendedName);
            this.setTypeInfoVector(vector);
        }
        sQLData.writeSQL(this);
        this.writeElementOffset();
    }

    void writeRow(Struct struct) throws SQLException {
        Object object;
        this.isNull = false;
        String string = struct.getSQLTypeName();
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            object = this.getTypeInfoVector(string);
            this.setTypeInfoVector((Vector)object);
        }
        if (((Object[])(object = struct.getAttributes())).length == 0) {
            throw IfxErrMsg.getSQLException(-79792, this.conn);
        }
        int n = 0;
        while (n < ((Object[])object).length) {
            int n2;
            if (object[n] == null) {
                this.getNextType(-99, 0, null);
                this.atNextType = true;
                n2 = this.currentIfxType;
            } else {
                n2 = this.getIfxType(object[n], this.isTyped);
            }
            this.writeElement(object[n], n2);
            ++n;
        }
        this.writeElementOffset();
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeCollection(Collection collection) throws SQLException {
        int n;
        block6: {
            if (collection == null) {
                this.addParentTypeInfoHeader(20, "");
                this.isNull = true;
                return;
            }
            n = this.getOverrideIfxType(collection);
            this.isNull = false;
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                this.addTypeAndOffsetInfo(-99, 0, null);
            } else {
                Object e = iterator.next();
                if (e == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                Class<?> clazz = e.getClass();
                int n2 = this.getIfxType(e, this.isTyped);
                do {
                    if (e.getClass() != clazz) {
                        throw IfxErrMsg.getSQLException(-79780, this.conn);
                    }
                    this.writeElement(e, n2);
                    if (!iterator.hasNext()) break block6;
                } while ((e = iterator.next()) != null);
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
        }
        this.addParentTypeInfoHeader(n, "");
        this.writeElementOffset();
    }

    void writeCollection(Array array) throws SQLException {
        if (array == null) {
            this.addParentTypeInfoHeader(20, "");
            this.isNull = true;
            return;
        }
        Object object = array.getArray(this.typeMap);
        if (object != null) {
            Class<?> clazz = object.getClass().getComponentType();
            int n = array.getBaseType();
            switch (n) {
                case 1111: {
                    if (clazz.equals(Boolean.TYPE)) {
                        this.writePrimitiveArray((boolean[])object);
                        break;
                    }
                    this.writeArray((Object[])object, n);
                    break;
                }
                case 4: {
                    if (!clazz.equals(Integer.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((int[])object);
                    break;
                }
                case 5: {
                    if (!clazz.equals(Short.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((short[])object);
                    break;
                }
                case -5: {
                    if (!clazz.equals(Long.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((long[])object);
                    break;
                }
                case 6: {
                    if (!clazz.equals(Float.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((float[])object);
                    break;
                }
                case 8: {
                    if (!clazz.equals(Double.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((double[])object);
                    break;
                }
                default: {
                    this.writeArray((Object[])object, n);
                    break;
                }
            }
        } else {
            this.isNull = true;
        }
        this.addParentTypeInfoHeader(this.getOverrideIfxType(array), "");
        this.writeElementOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeArray(Array array) throws SQLException {
        Object object;
        IfxComplexOutput ifxComplexOutput;
        block18: {
            Object object2;
            block17: {
                if (!this.isRow && array == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                if (array != null) {
                    this.addTypeAndOffsetInfo(this.getOverrideIfxType(array), 0, null);
                } else {
                    this.addTypeAndOffsetInfo(20, 0, null);
                }
                ifxComplexOutput = null;
                ifxComplexOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
                Map<String, Class<?>> map = this.conn.getTypeMap();
                object2 = array.getArray(map);
                if (object2 == null) {
                    this.addElementOffset(this.currentIfxType);
                    this.writeNestedData(ifxComplexOutput);
                    return;
                }
                this.isNull = false;
                Class<?> clazz = object2.getClass().getComponentType();
                if (!clazz.isPrimitive()) break block17;
                switch (array.getBaseType()) {
                    case 1111: {
                        if (!clazz.equals(Boolean.TYPE)) throw IfxErrMsg.getSQLException(-79728, this.conn);
                        ifxComplexOutput.writePrimitiveArray((boolean[])object2);
                        break block18;
                    }
                    case 5: {
                        ifxComplexOutput.writePrimitiveArray((short[])object2);
                        break block18;
                    }
                    case 4: {
                        ifxComplexOutput.writePrimitiveArray((int[])object2);
                        break block18;
                    }
                    case -5: {
                        ifxComplexOutput.writePrimitiveArray((long[])object2);
                        break block18;
                    }
                    case 6: {
                        ifxComplexOutput.writePrimitiveArray((float[])object2);
                        break block18;
                    }
                    case 8: {
                        ifxComplexOutput.writePrimitiveArray((double[])object2);
                        break block18;
                    }
                    default: {
                        throw IfxErrMsg.getSQLException(-79728, this.conn);
                    }
                }
            }
            Object[] objectArray = (Object[])object2;
            object = objectArray[0].getClass();
            int n = this.getIfxType(objectArray[0], ifxComplexOutput.getIsTyped());
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (object != objectArray[n2].getClass()) {
                    throw IfxErrMsg.getSQLException(-79780, this.conn);
                }
                this.addElementOffset(n);
                ifxComplexOutput.writeElement(objectArray[n2], n);
                ++n2;
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
        if (this.isTyped) return;
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.lastElement();
        if (ifxColumnInfo.child != null) {
            if (this.isUnknownType((IfxColumnInfo)ifxColumnInfo.child.get(0))) {
                ifxColumnInfo.child = ifxComplexOutput.getTypeInfoVector();
            }
        } else {
            ifxColumnInfo.child = ifxComplexOutput.getTypeInfoVector();
        }
        object = (IfxColumnInfo)ifxColumnInfo.child.get(0);
        ((IfxColumnInfo)object).Nullable = false;
    }

    private void writeArray(Object[] objectArray, int n) throws SQLException {
        int n2 = 0;
        int n3 = -99;
        if (objectArray == null) {
            return;
        }
        n2 = objectArray.length;
        if (n2 == 0) {
            this.addTypeAndOffsetInfo(0, 1, null);
            return;
        }
        if (objectArray[0] == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        Class<?> clazz = objectArray[0].getClass();
        n3 = this.getIfxType(objectArray[0], this.isTyped);
        int n4 = 0;
        while (n4 < n2) {
            if (objectArray[n4] == null) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            if (objectArray[n4].getClass() != clazz) {
                throw IfxErrMsg.getSQLException(-79780, this.conn);
            }
            this.writeElement(objectArray[n4], n3);
            ++n4;
        }
    }

    private void writeElement(Object object, int n) throws SQLException {
        switch (n) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                this.writeString((String)object);
                break;
            }
            case 1: {
                if (object == null) {
                    this.writeShort((short)Short.MIN_VALUE);
                    break;
                }
                this.writeShort((Short)object);
                break;
            }
            case 2: 
            case 6: {
                if (object == null) {
                    this.writeInt(Integer.MIN_VALUE);
                    break;
                }
                this.writeInt((Integer)object);
                break;
            }
            case 3: {
                if (object == null) {
                    this.writeDouble(IfxFloat.getIfxNull());
                    break;
                }
                this.writeDouble((Double)object);
                break;
            }
            case 4: {
                if (object == null) {
                    this.writeFloat(IfxSmallFloat.getIfxNull());
                    break;
                }
                this.writeFloat(((Float)object).floatValue());
                break;
            }
            case 5: 
            case 8: {
                this.writeBigDecimal((BigDecimal)object);
                break;
            }
            case 7: {
                this.writeDate((Date)object);
                break;
            }
            case 10: {
                if (object instanceof Time) {
                    this.writeTime((Time)object);
                    break;
                }
                this.writeTimestamp((Timestamp)object);
                break;
            }
            case 14: {
                if (object instanceof String) {
                    this.writeString((String)object);
                    break;
                }
                if (object == null || object instanceof IntervalDF) {
                    this.writeIntervalDF((IntervalDF)object);
                    break;
                }
                this.writeIntervalYM((IntervalYM)object);
                break;
            }
            case 17: 
            case 18: {
                if (object == null) {
                    this.writeLong(Long.MIN_VALUE);
                    break;
                }
                this.writeLong((Long)object);
                break;
            }
            case 102: {
                this.writeBlob((Blob)object);
                break;
            }
            case 101: {
                this.writeClob((Clob)object);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                if (object == null || object instanceof Collection) {
                    this.writeNestedCollection((Collection)object);
                    break;
                }
                Array array = null;
                array = object.getClass().isArray() ? new IfxArray(object, this.conn) : (Array)object;
                this.writeArray(array);
                break;
            }
            case 22: {
                if (object == null || object instanceof Struct) {
                    this.writeStruct((Struct)object);
                    break;
                }
                if (!(object instanceof SQLData)) break;
                this.writeNestedRow((SQLData)object);
                break;
            }
            case 40: 
            case 41: 
            case 44: {
                this.writeUDT(object);
                break;
            }
            case 45: {
                if (object == null) {
                    this.writeBoolean((byte)-1);
                    break;
                }
                this.writeBoolean((Boolean)object);
                break;
            }
            default: {
                throw IfxErrMsg.getSQLException(-79777, this.conn);
            }
        }
    }

    private int getIfxType(Object object, boolean bl) throws SQLException {
        int n = -99;
        Class<?> clazz = object.getClass();
        if (object instanceof Clob) {
            n = 101;
        } else if (object instanceof Blob) {
            n = 102;
        } else if (object instanceof Struct) {
            n = 22;
        } else if (object instanceof Array) {
            n = this.getOverrideIfxType(object);
        } else {
            try {
                n = IfxTypes.FromJavaToIfxType(clazz.getName());
                if (n == -99 && clazz.isArray()) {
                    n = 20;
                }
                if (IfxTypes.isCollection(n)) {
                    int n2 = n;
                    n = this.getOverrideIfxType(object);
                    if (n == -99) {
                        n = n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == -99) {
            if (object instanceof SQLData) {
                String string = ((SQLData)object).getSQLTypeName();
                if (string == null || string == "") {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo((IfxColumnInfo)null, string);
                if (ifxUDTInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                if (ifxUDTInfo.JDBCtype == 2002) {
                    IfxResultSetMetaData ifxResultSetMetaData;
                    n = 22;
                    if (!bl && (ifxResultSetMetaData = ifxUDTInfo.structInfo) != null) {
                        this.typeInfoVector = ifxResultSetMetaData.getColumnInfoVector();
                    }
                } else {
                    n = 40;
                }
            } else {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
        }
        return n;
    }

    void writePrimitiveArray(boolean[] blArray) throws SQLException {
        int n = blArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(45, 1, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeBoolean(blArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    void writePrimitiveArray(int[] nArray) throws SQLException {
        int n = nArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(2, 4, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeInt(nArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    void writePrimitiveArray(short[] sArray) throws SQLException {
        int n = sArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(1, 2, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeShort(sArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    void writePrimitiveArray(long[] lArray) throws SQLException {
        int n = lArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(17, 10, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeLong(lArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    void writePrimitiveArray(float[] fArray) throws SQLException {
        int n = fArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(4, 4, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeFloat(fArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    void writePrimitiveArray(double[] dArray) throws SQLException {
        int n = dArray.length;
        if (n == 0) {
            this.addTypeAndOffsetInfo(3, 8, null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeDouble(dArray[n2]);
            ++n2;
        }
        this.writeElementOffset();
    }

    byte[] getSerializedTypeInfo() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.parentTypeInfoVector == null) {
            throw IfxErrMsg.getSQLException(-79716, "getSerializedTypeInfo())", this.conn);
        }
        this.typeInfoCount = 0;
        this.serializeTypeInfo(byteArrayOutputStream, this.parentTypeInfoVector, (short)0, (short)0, false);
        return byteArrayOutputStream.toByteArray();
    }

    private short serializeTypeInfo(ByteArrayOutputStream byteArrayOutputStream, Vector vector, short s, short s2, boolean bl) throws SQLException {
        short s3 = s;
        int n = vector.size();
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(0);
        s = (short)(s + 1);
        short s4 = bl ? (short)1 : 0;
        int n2 = 0;
        while (n2 < n) {
            ++this.typeInfoCount;
            ifxColumnInfo = (IfxColumnInfo)vector.get(n2);
            byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxSmallInt(s2);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxSmallInt(s3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            this.serializeString(ifxColumnInfo.ColName, this.identsize, byteArrayOutputStream);
            byArray = JavaToIfxType.JavaToIfxSmallInt(s4);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            short s5 = (short)ifxColumnInfo.SQLtype;
            if (!ifxColumnInfo.Nullable) {
                s5 = (short)(s5 | 0x100);
            }
            if (ifxColumnInfo.IsNamedRow) {
                s5 = (short)(s5 | 0x1000);
            }
            if (ifxColumnInfo.IsDistinct) {
                s5 = (short)(s5 | 0x800);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(s5);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxSmallInt((short)ifxColumnInfo.ColLength);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxInt(ifxColumnInfo.ExtendedId);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxSmallInt((short)0);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            this.serializeString(ifxColumnInfo.ExtendedName, this.identsize, byteArrayOutputStream);
            this.serializeString(ifxColumnInfo.ExtendedOwner, this.identsize, byteArrayOutputStream);
            byArray = JavaToIfxType.JavaToIfxSmallInt(ifxColumnInfo.Alignment);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byArray = JavaToIfxType.JavaToIfxInt(ifxColumnInfo.SourceType);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (ifxColumnInfo.child != null) {
                s = this.serializeTypeInfo(byteArrayOutputStream, ifxColumnInfo.child, s, (short)(s2 + 1), (ifxColumnInfo.SQLtype & 0xFF) == 22);
            }
            if (n2 + 1 != n) {
                s = (short)(s + 1);
            }
            if (bl) {
                s4 = (short)(s4 + 1);
            }
            ++n2;
        }
        return s;
    }

    private void serializeString(String string, short s, ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        short s2 = 0;
        s2 = string == null ? (short)0 : (short)string.length();
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s2);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        String string2 = stringUtil.fixLength(string, s, ' ');
        byArray = string2.getBytes();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    int getTypeCount() {
        return this.typeInfoCount;
    }

    private int getElementOffsetCount() {
        int n = 0;
        if (this.elementOffsetVector != null && !this.elementOffsetVector.isEmpty()) {
            n = this.elementOffsetVector.size() + 1;
        }
        return n;
    }

    private Vector getTypeInfoVector() throws SQLException {
        Vector vector = null;
        if (this.parentTypeInfoVector != null) {
            vector = this.parentTypeInfoVector;
        } else if (this.isTyped) {
            throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() parentTypeInfo is null", this.conn);
        }
        if (this.typeInfoVector.size() == 0) {
            if (!this.isTyped) {
                if (!this.isNull) {
                    this.addTypeAndOffsetInfo(-99, 0, null);
                    if (this.parentTypeInfoVector != null) {
                        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.parentTypeInfoVector.get(0);
                        ifxColumnInfo.child = this.typeInfoVector;
                    }
                }
            } else {
                throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() typeInfoVector is null", this.conn);
            }
        }
        if (vector == null) {
            vector = this.typeInfoVector;
        }
        return vector;
    }

    private void setTypeInfoVector(Vector vector) {
        if (this.isTyped) {
            return;
        }
        this.parentTypeInfoVector = vector;
        this.typeInfoVector = ((IfxColumnInfo)vector.get((int)0)).child;
        this.isTyped = true;
    }

    private void addParentTypeInfoHeader(int n, String string) {
        if (this.isRow) {
            return;
        }
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        ifxColumnInfo.SQLtype = n;
        string = ifxColumnInfo.ExtendedName = string;
        if (!this.isNull) {
            ifxColumnInfo.child = this.typeInfoVector;
            if (IfxTypes.isCollection(n)) {
                ((IfxColumnInfo)this.typeInfoVector.get((int)0)).Nullable = false;
            }
        }
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>(1);
        vector.addElement(ifxColumnInfo);
        this.parentTypeInfoVector = vector;
    }

    private void writeNestedData(IfxComplexOutput ifxComplexOutput) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.getNestedHeader(this.bStream.size(), ifxComplexOutput.length(), ifxComplexOutput.isNull);
            this.os.write(byArray, 0, byArray.length);
            if (!ifxComplexOutput.isNull) {
                byArray = ifxComplexOutput.toByteArray();
                this.os.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    private boolean isUnknownType(IfxColumnInfo ifxColumnInfo) {
        if (ifxColumnInfo.SQLtype == -99) {
            return true;
        }
        if (ifxColumnInfo.child != null) {
            return this.isUnknownType((IfxColumnInfo)ifxColumnInfo.child.get(0));
        }
        return false;
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        BigDecimal bigDecimal2 = null;
        if (!this.isRow && bigDecimal == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (this.isTyped) {
            this.addTypeAndOffsetInfo(5, this.currentIfxLength, null);
            int n = IfxDecimal.precDec(this.currentIfxLength);
            int n2 = IfxDecimal.precTot(this.currentIfxLength);
            if (n == 255) {
                n = n2;
            }
            bigDecimal2 = bigDecimal.setScale(n, 4);
            IfxDecimal ifxDecimal = new IfxDecimal();
            ifxDecimal.setConnection(this.conn);
            ifxDecimal.fromDecimal(bigDecimal2, n, (short)this.currentIfxLength);
            byte[] byArray = ifxDecimal.toIfx();
            try {
                this.os.write(byArray, 2, byArray.length - 2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            String string = bigDecimal.toString();
            this.writeString(string);
        }
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeBinaryStream(InputStream).", this.conn);
    }

    public void writeBlob(Blob blob) throws SQLException {
        IfxObject ifxObject = null;
        if (!this.isRow && blob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "blob");
        ifxObject = IfxValue.makeInstanceFromIfxType(this.conn, 102);
        if (!((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL = true;
        }
        ifxObject.fromBlob(blob);
        byte[] byArray = ifxObject.toIfxTuple();
        try {
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    private void writeBoolean(byte by) throws SQLException {
        try {
            this.addTypeAndOffsetInfo(45, 1, null);
            if (by == -1) {
                this.os.writeByte(1);
                this.os.writeInt(0);
            } else {
                this.os.writeByte(0);
                this.os.writeInt(1);
                this.os.writeByte(by);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBoolean(boolean bl) throws SQLException {
        byte by = bl ? (byte)1 : 0;
        this.writeBoolean(by);
    }

    public void writeByte(byte by) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeByte(byte).", this.conn);
    }

    public void writeClob(Clob clob) throws SQLException {
        IfxObject ifxObject = null;
        if (!this.isRow && clob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "clob");
        ifxObject = IfxValue.makeInstanceFromIfxType(this.conn, 101);
        if (!((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL = true;
        }
        ifxObject.fromClob(clob);
        byte[] byArray = ifxObject.toIfxTuple();
        try {
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeDate(Date date) throws SQLException {
        if (!this.isRow && date == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(7, 4, null);
        super.writeDate(date);
    }

    public void writeDouble(double d) throws SQLException {
        if (!this.isRow && IfxFloat.isIfxNull(d)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(3, 8, null);
        super.writeDouble(d);
    }

    public void writeFloat(float f) throws SQLException {
        if (!this.isRow && IfxSmallFloat.isIfxNull(f)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(4, 4, null);
        try {
            this.os.writeReal(f);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeLong(long l) throws SQLException {
        this.addTypeAndOffsetInfo(17, 10, null);
        try {
            this.os.writeLongInt(l);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeShort(short s) throws SQLException {
        this.addTypeAndOffsetInfo(1, 2, null);
        try {
            this.os.writeSmallInt(s);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeTime(Time time) throws SQLException {
        IfxDateTime ifxDateTime = new IfxDateTime(time);
        this.addTypeAndOffsetInfo(10, ifxDateTime.getEncodedLength(), null);
        try {
            byte[] byArray = ifxDateTime.toIfx();
            this.os.write(byArray, 2, byArray.length - 2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        IfxDateTime ifxDateTime = new IfxDateTime(timestamp);
        this.addTypeAndOffsetInfo(10, ifxDateTime.getEncodedLength(), null);
        try {
            byte[] byArray = ifxDateTime.toIfx();
            this.os.write(byArray, 2, byArray.length - 2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeInterval(Interval interval) throws SQLException {
        if (interval == null || interval instanceof IntervalDF) {
            this.writeIntervalDF((IntervalDF)interval);
        } else if (interval instanceof IntervalYM) {
            this.writeIntervalYM((IntervalYM)interval);
        } else {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
    }

    void writeIntervalDF(IntervalDF intervalDF) throws SQLException {
        short s = 0;
        if (intervalDF != null) {
            s = intervalDF.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, s, null);
        IfxIntervalDF ifxIntervalDF = new IfxIntervalDF(intervalDF);
        ifxIntervalDF.setConnection(this.conn);
        if (intervalDF == null && this.isTyped) {
            ifxIntervalDF.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] byArray = ifxIntervalDF.toIfxTuple();
            this.os.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    void writeIntervalYM(IntervalYM intervalYM) throws SQLException {
        short s = 0;
        if (intervalYM != null) {
            s = intervalYM.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, s, null);
        IfxIntervalYM ifxIntervalYM = new IfxIntervalYM(intervalYM);
        ifxIntervalYM.setConnection(this.conn);
        if (intervalYM == null && this.isTyped) {
            ifxIntervalYM.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] byArray = ifxIntervalYM.toIfxTuple();
            this.os.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    private void getNextType(int n, int n2, String string) throws SQLException {
        if (!this.isRow && this.typeIndex >= 0) {
            return;
        }
        if (this.atNextType) {
            this.atNextType = false;
            return;
        }
        ++this.typeIndex;
        if (this.typeIndex >= this.typeInfoVector.size()) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
        this.currentIfxType = ifxColumnInfo.SQLtype;
        this.currentExtendedId = ifxColumnInfo.ExtendedId;
        this.currentIfxLength = ifxColumnInfo.ColLength;
        if (n != -99) {
            this.verifyType(n, n2, string);
        }
    }

    private void verifyType(int n, int n2, String string) throws SQLException {
        String string2 = null;
        if (this.conn != null) {
            string2 = this.conn.getclLocale();
        }
        if (this.currentIfxType != n) {
            if (IfxTypes.isCollection(this.currentIfxType) && IfxTypes.isCollection(n)) {
                return;
            }
            if (n == 40 && this.currentIfxType == 41 || n == 41 && this.currentIfxType == 40) {
                return;
            }
            if ((this.currentIfxType == 101 || this.currentIfxType == 102) && n == 41) {
                return;
            }
            if (n == 5 && this.currentIfxType == 8) {
                return;
            }
            IfxComplex.badTypeException(this.currentIfxType, (short)n, this.trace, string2);
        }
        if (string != null && string != "") {
            Object object;
            int n3 = 0;
            if (string.compareToIgnoreCase("blob") == 0) {
                n3 = 10;
            } else if (string.compareToIgnoreCase("clob") == 0) {
                n3 = 11;
            } else {
                object = this.conn.getUDTInfo((IfxColumnInfo)null, string);
                if (object == null) {
                    String string3 = IfxErrMsg.getMessage(-79796, string, this.conn);
                    throw new SQLException(string3);
                }
                n3 = ((IfxUDTInfo)object).xid;
            }
            if (this.currentExtendedId != n3) {
                object = Integer.toString(n3);
                String string4 = Integer.toString(this.currentExtendedId);
                String string5 = IfxErrMsg.getMessage(-79794, (String)object, string4, this.conn);
                throw new SQLException(string5);
            }
        }
    }

    protected String getExtendedName() throws SQLException {
        String string = null;
        if (this.extendedName == "" && !this.isNull) {
            string = this.parentTypeInfoVector != null ? IfxComplex.getExtendedName(this.parentTypeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale());
        } else {
            string = this.conn != null ? IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, null);
            string = this.extendedName;
        }
        return string;
    }

    private Vector getTypeInfoVector(String string) throws SQLException {
        Vector vector;
        block4: {
            if (string == null) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            vector = null;
            try {
                String string2 = T_SPACE + T_COMMA + T_LPAREN + T_RPAREN;
                string = string.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
                vector = this.constructTypeInfo(stringTokenizer, 1, null, 0);
            }
            catch (Exception exception) {
                IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo((IfxColumnInfo)null, string);
                if (ifxUDTInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.structInfo;
                if (ifxResultSetMetaData == null) break block4;
                vector = ifxResultSetMetaData.getColumnInfoVector();
            }
        }
        this.extendedName = string;
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector constructTypeInfo(StringTokenizer stringTokenizer, int n, Boolean bl, int n2) throws SQLException {
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>();
        int n3 = -1;
        IfxColumnInfo ifxColumnInfo = null;
        boolean bl2 = false;
        String string = "";
        while (!bl2) {
            block37: {
                if (advanceToken) {
                    if (stringTokenizer.hasMoreTokens()) {
                        currentToken = this.getNextToken(stringTokenizer);
                        break block37;
                    } else {
                        if (currentToken.equals(T_RPAREN)) break;
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                }
                advanceToken = true;
            }
            switch (n) {
                case 1: {
                    n3 = IfxTypes.FromIfxNameToIfxType(currentToken);
                    if (!IfxTypes.isComplexType(n3)) {
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    if (n3 == 102) {
                        n3 = 40;
                        ifxColumnInfo.ExtendedName = "blob";
                        ifxColumnInfo.ExtendedId = 10;
                    } else if (n3 == 101) {
                        n3 = 40;
                        ifxColumnInfo.ExtendedName = "clob";
                        ifxColumnInfo.ExtendedId = 11;
                    }
                    ifxColumnInfo.SQLtype = n3;
                    Boolean bl3 = null;
                    bl3 = n3 == 22 ? new Boolean(true) : new Boolean(false);
                    if (bl == null) {
                        bl = bl3;
                    }
                    vector.addElement(ifxColumnInfo);
                    ifxColumnInfo.Fieldno = 1;
                    previousState = n;
                    n = 5;
                    ifxColumnInfo.child = this.constructTypeInfo(stringTokenizer, n, bl3, n2 + 4);
                    if (previousState != 9) {
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    n = 8;
                    break;
                }
                case 7: {
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    ifxColumnInfo.ColName = currentToken;
                    previousState = n;
                    n = 2;
                    break;
                }
                case 2: {
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    n = this.parseFieldType(currentToken, ifxColumnInfo, string);
                    break;
                }
                case 4: {
                    if (currentToken.equals(T_COMMA)) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                        previousState = n;
                        n = 7;
                        break;
                    }
                    if (currentToken.equals(")")) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                    }
                    previousState = 9;
                    bl2 = true;
                    break;
                }
                case 5: {
                    if (previousState == 1) {
                        previousState = n;
                        if (bl.booleanValue()) {
                            n = 7;
                            break;
                        }
                        n = 2;
                        break;
                    }
                    previousState = n;
                    n = 3;
                    break;
                }
                case 3: {
                    int n4;
                    ifxColumnInfo.ColLength = n4 = this.getLength(stringTokenizer, ifxColumnInfo.SQLtype);
                    n = 8;
                    break;
                }
                case 6: {
                    if (!currentToken.equals(")")) {
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (!bl.booleanValue()) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                        previousState = 9;
                        bl2 = true;
                        break;
                    }
                    previousState = n;
                    n = 8;
                    break;
                }
                case 8: {
                    if (!currentToken.equalsIgnoreCase("not")) {
                        if (!bl.booleanValue()) {
                            throw IfxErrMsg.getSQLException(-79790, this.conn);
                        }
                        advanceToken = false;
                        n = 4;
                        break;
                    }
                    currentToken = this.getNextToken(stringTokenizer);
                    if (!currentToken.equalsIgnoreCase("null")) {
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    ifxColumnInfo.Nullable = false;
                    if (previousState == 9 && !stringTokenizer.hasMoreTokens()) {
                        bl2 = true;
                        break;
                    }
                    previousState = n;
                    if (bl.booleanValue()) {
                        n = 4;
                        break;
                    }
                    n = 6;
                    break;
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79790, this.conn);
                }
            }
        }
        return vector;
    }

    private int parseFieldType(String string, IfxColumnInfo ifxColumnInfo, String string2) throws SQLException {
        int n = -99;
        int n2 = 0;
        int n3 = 0;
        String string3 = null;
        String string4 = null;
        if (string.startsWith("'")) {
            n3 = string.indexOf(39, 1);
            if (n3 > 0) {
                string3 = string.substring(1, n3);
                ++n3;
            } else {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        }
        if ((n3 = string.indexOf(46, n3)) <= 0 && string3 != null) {
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        if (string3 != null) {
            ifxColumnInfo.ExtendedOwner = string3;
            ++n3;
        } else if (n3 > 0) {
            ifxColumnInfo.ExtendedOwner = string3 = string.substring(0, n3);
            ++n3;
        } else {
            n3 = 0;
        }
        string4 = string.substring(n3, string.length());
        n = IfxTypes.FromIfxNameToIfxType(string4);
        if (IfxTypes.isComplexType(n)) {
            n2 = 1;
            advanceToken = false;
        } else {
            if (n == 1111) {
                this.getOther(ifxColumnInfo, string4, string3);
                n = ifxColumnInfo.SQLtype;
            }
            if (n == 102) {
                n = 40;
                ifxColumnInfo.ExtendedName = "blob";
                ifxColumnInfo.ExtendedId = 10;
            } else if (n == 101) {
                n = 40;
                ifxColumnInfo.ExtendedName = "clob";
                ifxColumnInfo.ExtendedId = 11;
            }
            ifxColumnInfo.SQLtype = n;
            previousState = n2;
            n2 = 3;
        }
        return n2;
    }

    private void getOther(IfxColumnInfo ifxColumnInfo, String string, String string2) throws SQLException {
        IfxUDTInfo ifxUDTInfo = null;
        ifxUDTInfo = string2 != null ? this.conn.getUDTInfo(string, string2) : this.conn.getUDTInfo((IfxColumnInfo)null, string);
        if (ifxUDTInfo == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        ifxColumnInfo.ExtendedName = ifxUDTInfo.name;
        if (ifxUDTInfo.owner != null && string2 != null) {
            ifxColumnInfo.ExtendedOwner = ifxUDTInfo.owner;
        }
        ifxColumnInfo.ExtendedId = ifxUDTInfo.xid;
        ifxColumnInfo.SQLtype = ifxUDTInfo.SQLtype;
        if (ifxUDTInfo.JDBCtype == 2002) {
            IfxColumnInfo ifxColumnInfo2 = null;
            IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.structInfo;
            ifxColumnInfo2 = (IfxColumnInfo)ifxResultSetMetaData.getColumnInfoVector().get(0);
            String string3 = ifxColumnInfo.ColName;
            ifxColumnInfo2.copy(ifxColumnInfo);
            ifxColumnInfo.ColName = string3;
        } else if (ifxUDTInfo.JDBCtype == 2001) {
            ifxColumnInfo.SourceType = ifxUDTInfo.source;
        }
    }

    private String getState(int n) {
        switch (n) {
            case 1: {
                return "CT_TYPE";
            }
            case 2: {
                return "TYPE";
            }
            case 3: {
                return "LENGTH";
            }
            case 4: {
                return "NEXTELEMENT";
            }
            case 5: {
                return "LPAREN";
            }
            case 6: {
                return "RPAREN";
            }
            case 7: {
                return "FIELDNAME";
            }
            case 8: {
                return "NOTNULL";
            }
        }
        return "";
    }

    private int getLength(StringTokenizer stringTokenizer, int n) throws SQLException {
        int n2 = -1;
        if (n == 0 || n == 15 || n == 13 || n == 16) {
            if (!currentToken.equals(T_LPAREN)) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            currentToken = this.getNextToken(stringTokenizer);
            n2 = Integer.valueOf(currentToken);
            currentToken = this.getNextToken(stringTokenizer);
            if (!currentToken.equals(")")) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        } else if (n == 8 || n == 5) {
            int n3 = 16;
            int n4 = this.conn.isANSI() ? 0 : 255;
            if (!currentToken.equals(T_LPAREN)) {
                if (n == 8) {
                    n4 = 2;
                }
                n2 = ((byte)n3 << 8) + n4;
                advanceToken = false;
            } else {
                currentToken = this.getNextToken(stringTokenizer);
                n3 = Integer.valueOf(currentToken);
                currentToken = this.getNextToken(stringTokenizer);
                if (currentToken.equals(T_COMMA)) {
                    currentToken = this.getNextToken(stringTokenizer);
                    n4 = Integer.valueOf(currentToken);
                    currentToken = this.getNextToken(stringTokenizer);
                }
                if (!currentToken.equals(T_RPAREN)) {
                    throw IfxErrMsg.getSQLException(-79790, this.conn);
                }
                n2 = ((byte)n3 << 8) + n4;
            }
        } else if (n == 10 || n == 14) {
            n2 = n == 10 ? this.getQualifier(stringTokenizer, false) : this.getQualifier(stringTokenizer, true);
        } else {
            advanceToken = false;
            switch (n) {
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 8;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 17: 
                case 18: {
                    n2 = 10;
                    break;
                }
                case 45: {
                    n2 = 1;
                    break;
                }
                case 43: {
                    n2 = 2048;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        if (n2 == -1) {
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        return n2;
    }

    private String getNextToken(StringTokenizer stringTokenizer) throws SQLException {
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals(T_SPACE)) continue;
            return string;
        }
        throw IfxErrMsg.getSQLException(-79790, this.conn);
    }

    private int getQualifier(StringTokenizer stringTokenizer, boolean bl) throws SQLException {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n = 0;
        by = this.fieldNametoDatetimeMacro(stringTokenizer);
        currentToken = this.getNextToken(stringTokenizer);
        if (currentToken.equals(T_LPAREN)) {
            if (bl) {
                currentToken = this.getNextToken(stringTokenizer);
                by3 = (byte)Integer.valueOf(currentToken).intValue();
                currentToken = this.getNextToken(stringTokenizer);
                if (!currentToken.equals(T_RPAREN)) {
                    throw IfxErrMsg.getSQLException(-79717, this.conn);
                }
                currentToken = this.getNextToken(stringTokenizer);
            } else {
                throw IfxErrMsg.getSQLException(-79707, this.conn);
            }
        }
        if (currentToken.equalsIgnoreCase("to")) {
            currentToken = this.getNextToken(stringTokenizer);
            by2 = this.fieldNametoDatetimeMacro(stringTokenizer);
            n = bl ? (int)Interval.getQualifier(by3, by, by2) : (int)IfxDateTime.getQualifier(by, by2);
        }
        return n;
    }

    private byte fieldNametoDatetimeMacro(StringTokenizer stringTokenizer) throws SQLException {
        int n = -1;
        currentToken.trim();
        if (currentToken.equalsIgnoreCase("year")) {
            n = 0;
        } else if (currentToken.equalsIgnoreCase("month")) {
            n = 2;
        } else if (currentToken.equalsIgnoreCase("day")) {
            n = 4;
        } else if (currentToken.equalsIgnoreCase("hour")) {
            n = 6;
        } else if (currentToken.equalsIgnoreCase("minute")) {
            n = 8;
        } else if (currentToken.equalsIgnoreCase("second")) {
            n = 10;
        } else if (currentToken.equalsIgnoreCase("fraction")) {
            currentToken = this.getNextToken(stringTokenizer);
            if (currentToken.equals(T_LPAREN)) {
                currentToken = this.getNextToken(stringTokenizer);
                int n2 = Integer.valueOf(currentToken);
                currentToken = this.getNextToken(stringTokenizer);
                if (currentToken.equals(T_RPAREN)) {
                    if (n2 == 1) {
                        n = 11;
                    } else if (n2 == 2) {
                        n = 12;
                    } else if (n2 == 3) {
                        n = 13;
                    } else if (n2 == 4) {
                        n = 14;
                    } else if (n2 == 5) {
                        n = 15;
                    }
                }
            } else {
                advanceToken = false;
                n = 12;
            }
        }
        if (n == -1) {
            throw IfxErrMsg.getSQLException(-79707, this.conn);
        }
        return (byte)n;
    }

    private byte[] getNestedHeader(int n, int n2, boolean bl) throws SQLException {
        byte[] byArray;
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            n4 = 3;
            byArray = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byArray[n5] = 0;
                ++n5;
            }
            byte[] byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)1);
            System.arraycopy(byArray2, 0, byArray, 0, 2);
            byArray[2] = 1;
        } else {
            n3 = IfxComplexOutput.getUDToffset(n, this.trace);
            n4 = n3 + 8;
            byArray = new byte[n4];
            int n6 = 0;
            while (n6 < n4) {
                byArray[n6] = 0;
                ++n6;
            }
            short s = (short)(n2 + n3 + 8 - 2);
            byte[] byArray3 = JavaToIfxType.JavaToIfxSmallInt(s);
            System.arraycopy(byArray3, 0, byArray, 0, 2);
            int n7 = 1;
            byte[] byArray4 = JavaToIfxType.JavaToIfxInt(n7);
            System.arraycopy(byArray4, 0, byArray, n3, 4);
            n3 += 4;
        }
        return byArray;
    }

    public static int getUDToffset(int n, Trace trace) {
        int n2 = (n + 3) % 8 == 0 ? 3 : 11 - (n + 3) % 8;
        return n2;
    }

    private void writeElementOffset() throws SQLException {
        byte[] byArray = this.getElementOffset(this.elementOffsetVector);
        if (byArray != null) {
            try {
                this.os.write(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    byte[] getElementOffset(Vector vector) throws SQLException {
        int n = this.elementOffsetVector.size();
        byte[] byArray = new byte[4 * (n + 1)];
        int n2 = 0;
        if (n < 1) {
            return null;
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(-1);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        n2 += 4;
        int n3 = n - 1;
        while (n3 >= 0) {
            Integer n4 = (Integer)vector.elementAt(n3);
            byArray2 = JavaToIfxType.JavaToIfxInt(n4);
            System.arraycopy(byArray2, 0, byArray, n2, 4);
            n2 += 4;
            --n3;
        }
        this.elementOffsetVector.clear();
        return byArray;
    }

    private int getOverrideIfxType(Object object) throws SQLException {
        int n = -99;
        boolean bl = false;
        Class<?> clazz = null;
        Map<String, Class<?>> map = this.conn.getTypeMap();
        if (map == null) {
            return n;
        }
        clazz = map.get("set");
        if (clazz != null && clazz == object.getClass()) {
            return 19;
        }
        clazz = map.get("list");
        if (clazz != null && clazz == object.getClass()) {
            return 21;
        }
        clazz = map.get("multiset");
        if (clazz != null && clazz == object.getClass()) {
            return 20;
        }
        if (object instanceof List) {
            return 21;
        }
        if (object instanceof Collection || object instanceof Array) {
            return 20;
        }
        return n;
    }

    boolean getIsTyped() {
        return this.isTyped;
    }

    public void writeURL(URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeURL()", this.conn);
    }
}

