/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinctOutput
implements SQLOutput {
    ByteArrayOutputStream bStream = new ByteArrayOutputStream();
    IfxDataOutputStream os = new IfxDataOutputStream(this.bStream);
    IfxObject sourceObj = null;
    IfxConnection conn = null;

    IfxDistinctOutput(IfxObject ifxObject, IfxConnection ifxConnection) {
        this.sourceObj = ifxObject;
        this.conn = ifxConnection;
    }

    void reset() {
        this.bStream.reset();
    }

    int length() {
        return this.bStream.size();
    }

    byte[] toByteArray() {
        return this.bStream.toByteArray();
    }

    public void writeString(String string) throws SQLException {
        this.sourceObj.fromString(string);
    }

    public void writeBoolean(boolean bl) throws SQLException {
        this.sourceObj.fromBoolean(bl);
    }

    public void writeByte(byte by) throws SQLException {
        this.sourceObj.fromByte(by);
    }

    public void writeShort(short s) throws SQLException {
        this.sourceObj.fromShort(s);
    }

    public void writeInt(int n) throws SQLException {
        this.sourceObj.fromInt(n);
    }

    public void writeLong(long l) throws SQLException {
        this.sourceObj.fromLong(l);
    }

    public void writeFloat(float f) throws SQLException {
        this.sourceObj.fromFloat(f);
    }

    public void writeDouble(double d) throws SQLException {
        this.sourceObj.fromDouble(d);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.sourceObj.fromDecimal(bigDecimal);
    }

    public void writeBytes(byte[] byArray) throws SQLException {
        this.sourceObj.fromBytes(byArray);
    }

    public void writeDate(Date date) throws SQLException {
        this.sourceObj.fromDate(date);
    }

    public void writeTime(Time time) throws SQLException {
        this.sourceObj.fromTime(time);
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.sourceObj.fromTimestamp(timestamp);
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeCharacterStream(Reader).", this.conn);
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        try {
            this.sourceObj.fromAsciiStream(inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        try {
            this.sourceObj.fromBinaryStream(inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeObject(SQLData sQLData) throws SQLException {
        this.sourceObj.fromObject(sQLData);
    }

    public void writeRef(Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeRef(Ref).", this.conn);
    }

    public void writeBlob(Blob blob) throws SQLException {
        this.sourceObj.fromBlob(blob);
    }

    public void writeClob(Clob clob) throws SQLException {
        this.sourceObj.fromClob(clob);
    }

    public void writeStruct(Struct struct) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeStruct(Struct).", this.conn);
    }

    public void writeArray(Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeArray(Array).", this.conn);
    }

    public void writeURL(URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeURL()", this.conn);
    }
}

