/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class IfxDriver
implements Driver {
    private static Trace trace = null;
    private String errMsg;
    private int errNum;
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private String DbName = null;
    private String SubProtocol = null;
    private String OrigUrl = null;
    private String NewUrl = null;
    private String Proxy = null;
    private String ClientLocale = null;
    private static String staticClientLocale = null;
    private static final String JDBCRelVer = "2.21.J";
    protected static String jdkVersion;

    private static void setJDKVersion() {
        try {
            jdkVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            System.out.println(IfxErrMsg.getMessage(-79880, (String)null));
        }
    }

    protected static int compareJDKVersion(String string) {
        Object var1_1 = null;
        boolean bl = false;
        String string2 = null;
        if (jdkVersion != null && string != null) {
            int n = jdkVersion.length();
            int n2 = 0;
            while (!bl && n2 < n) {
                char c = jdkVersion.charAt(n2);
                if (c >= '0' && c <= '9') {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            string2 = jdkVersion.substring(n2);
            return string2.compareTo(string);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        this.checkClientLocale(string, properties);
        if (this.checkURL(string)) {
            Object object;
            Class[] classArray;
            Properties properties2 = new Properties();
            Connection connection = null;
            if (properties == null) {
                properties2.clear();
            } else {
                classArray = null;
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    classArray = object.nextElement().toString();
                    properties2.put(classArray.toUpperCase(), properties.getProperty((String)classArray));
                }
                classArray = null;
            }
            this.getPropertiesFromUrl(string, properties2);
            try {
                classArray = new Class[]{string.getClass(), properties2.getClass()};
                object = Class.forName(properties2.getProperty("CONNECTIONCLASS"));
                Constructor constructor = ((Class)object).getConstructor(classArray);
                Object[] objectArray = new Object[]{this.NewUrl, properties2};
                connection = (Connection)constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (SQLException)invocationTargetException.getTargetException();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getLocSQLException(-79704, exception.toString(), this.ClientLocale);
            }
            return connection;
        }
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.checkURL(string);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String[] stringArray = new String[]{"DATABASE", "INFORMIXSERVER", "USER", "PASSWORD"};
        Properties properties2 = new Properties();
        if (!this.checkURL(string)) {
            throw IfxErrMsg.getLocSQLException(-79705, this.errMsg, this.ClientLocale);
        }
        this.getPropertiesFromUrl(string, properties2);
        String string2 = null;
        Properties properties3 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = enumeration.nextElement().toString();
            properties3.put(string2.toUpperCase(), properties.get(string2));
        }
        string2 = null;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (properties3.get(stringArray[n2]) == null && properties2.get(stringArray[n2]) == null) {
                driverPropertyInfoArray[n++] = new DriverPropertyInfo(stringArray[n2].toLowerCase(), null);
            }
            ++n2;
        }
        DriverPropertyInfo[] driverPropertyInfoArray2 = new DriverPropertyInfo[n];
        while (n-- > 0) {
            driverPropertyInfoArray2[n] = driverPropertyInfoArray[n];
        }
        return driverPropertyInfoArray2;
    }

    public int getMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public static int getMajorMinorVersion() {
        try {
            int n = IfxDriver.getJDBCMajorVersion() * 100;
            int n2 = IfxDriver.getJDBCMinorVersion();
            return n + n2;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkURL(String var1_1) throws SQLException {
        block28: {
            block29: {
                block30: {
                    block31: {
                        block27: {
                            var13_2 = true;
                            this.DbName = null;
                            this.SubProtocol = null;
                            this.OrigUrl = null;
                            this.NewUrl = null;
                            if (var1_1.indexOf(58) == -1) {
                                this.errNum = -80004;
                                this.errMsg = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + var1_1 + "'" + IfxErrMsg.getMinorMsg(-80004, this.ClientLocale) + " ':'";
                                return false;
                            }
                            var2_3 = new StringTokenizer(var1_1, ":", true);
                            var6_4 = var2_3.nextToken();
                            if (!var6_4.equalsIgnoreCase("jdbc")) {
                                this.errNum = -79756;
                                this.errMsg = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + var1_1 + "' " + IfxErrMsg.getMessage(-79756, this.ClientLocale);
                                return false;
                            }
                            var12_5 = var2_3.nextToken();
                            var7_6 = var2_3.nextToken();
                            if (var2_3.hasMoreTokens()) {
                                var12_5 = var2_3.nextToken();
                            }
                            if (var7_6 != null && var7_6.charAt(0) == '/' && var7_6.charAt(1) == '/') {
                                var7_6 = var7_6.substring(2, var7_6.length());
                            }
                            if (var7_6.equals("informix-sqli")) {
                                var14_7 = System.getProperty("java.version");
                                this.SubProtocol = new String("informix-sqli");
                                if (var2_3.hasMoreTokens()) {
                                    var7_6 = var2_3.nextToken();
                                }
                                if (var2_3.hasMoreTokens()) {
                                    var12_5 = var2_3.nextToken();
                                }
                            } else if (var7_6.equals("informix-direct")) {
                                this.SubProtocol = new String("informix-direct");
                                var13_2 = false;
                                if (var2_3.hasMoreTokens()) {
                                    var7_6 = var2_3.nextToken();
                                    if (!var7_6.equals(":") && var2_3.hasMoreTokens()) {
                                        var12_5 = var2_3.nextToken();
                                    }
                                } else {
                                    var7_6 = null;
                                }
                            } else {
                                this.errNum = -79757;
                                this.errMsg = IfxErrMsg.getMessage(-79757, this.ClientLocale) + ": '" + var7_6 + "'";
                                return false;
                            }
                            if (var7_6 != null && var7_6.charAt(0) == '/' && var7_6.charAt(1) == '/') {
                                var7_6 = var7_6.substring(2, var7_6.length());
                            }
                            if (var13_2) break block27;
                            if (var7_6 != null && var7_6.length() > 0 && var7_6.charAt(0) == '/') {
                                var14_7 = var7_6;
                                var5_8 = new StringTokenizer(var14_7, "/");
                                var9_10 = var5_8.nextToken();
                                if (!this.validDatabaseIdentifier(var9_10)) {
                                    this.errNum = -79760;
                                    this.errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + var9_10 + "'";
                                    return false;
                                }
                                this.DbName = new String(var9_10);
                                this.NewUrl = null;
                            }
                            break block28;
                        }
                        var3_12 = new StringTokenizer(var7_6, ".");
                        var14_7 = var3_12.nextToken();
                        if (var14_7.indexOf("=") != -1) break block29;
                        if (var14_7.indexOf("/") != -1) break block30;
                        if (!this.isANum(var14_7)) ** GOTO lbl73
                        if (var3_12.countTokens() == 3 && this.isAIPNum(var14_7)) ** GOTO lbl68
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + var7_6 + "'", this.ClientLocale);
lbl-1000:
                        // 1 sources

                        {
                            var14_7 = var3_12.nextToken();
                            if (this.isAIPNum(var14_7)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + var7_6 + "'", this.ClientLocale);
lbl68:
                            // 2 sources

                            ** while (var3_12.hasMoreTokens())
                        }
lbl69:
                        // 1 sources

                        break block31;
lbl-1000:
                        // 1 sources

                        {
                            var14_7 = var3_12.nextToken();
                            if (!this.isANum(var14_7)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + var7_6 + "'", this.ClientLocale);
lbl73:
                            // 2 sources

                            ** while (var3_12.hasMoreTokens())
                        }
                    }
                    if (!var2_3.hasMoreTokens()) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    var8_13 = var2_3.nextToken();
                    if (var2_3.hasMoreTokens()) {
                        var12_5 = var2_3.nextToken();
                    }
                    if (var8_13 != null && var8_13.indexOf(47) == -1) {
                        if (!this.isANum(var8_13)) {
                            throw IfxErrMsg.getLocSQLException(-79759, ": '" + var8_13 + "'", this.ClientLocale);
                        }
                        this.NewUrl = new String(var7_6 + ":" + var8_13);
                    } else if (var8_13 != null) {
                        var5_9 = new StringTokenizer(var8_13, "/");
                        if (!this.isANum(var8_13 = var5_9.nextToken())) {
                            throw IfxErrMsg.getLocSQLException(-79759, ": '" + var8_13 + "'", this.ClientLocale);
                        }
                        this.NewUrl = new String(var7_6 + ":" + var8_13);
                        var9_11 = var5_9.nextToken(":").substring(1);
                        if (var9_11 == null || var9_11.length() == 0) {
                            this.errNum = -79760;
                            this.errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + var9_11 + "'";
                            return false;
                        }
                        if (!this.validDatabaseIdentifier(var9_11)) {
                            throw IfxErrMsg.getLocSQLException(-79760, ": '" + var9_11 + "'", this.ClientLocale);
                        }
                        this.DbName = new String(var9_11);
                    }
                    break block28;
                }
                this.DbName = var14_7.substring(1, var14_7.length());
                this.NewUrl = null;
                break block28;
            }
            this.NewUrl = null;
        }
        this.OrigUrl = new String(var1_1);
        return true;
    }

    private boolean isAIPNum(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isANum(String string) {
        try {
            Integer n = new Integer(string);
            return n >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void getPropertiesFromUrl(String string, Properties properties) {
        int n;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        if (properties.get("DATABASE") == null && this.DbName != null) {
            properties.put("DATABASE", this.DbName);
        }
        if ((n = string.indexOf(61)) != -1) {
            int n3 = -1;
            while ((n3 = string.indexOf(58, (n2 = n3) + 1)) != -1 && n3 < n) {
            }
            if (n2 == -1) {
                return;
            }
        }
        if ((string2 = string.substring(n2 + 1)) != null) {
            stringTokenizer = new StringTokenizer(string2, ";");
        }
        if (string2 != null && string2.indexOf(61) != -1 && stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken(";");
                stringTokenizer2 = new StringTokenizer(string3, "=");
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken(";").substring(1);
                properties.put(string4.toUpperCase(), string5);
            }
        }
        if (this.SubProtocol.equals("informix-direct")) {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
            }
        } else {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
        }
        if ((this.Proxy = properties.getProperty("PROXY")) != null) {
            this.formatProxy(this.Proxy);
            properties.put("PROXY", this.Proxy);
        }
        properties.put("USERURL", this.OrigUrl);
        if (this.NewUrl == null && this.SubProtocol.equals("informix-direct")) {
            this.NewUrl = this.OrigUrl;
        }
    }

    private void checkTracing(String string, Properties properties) {
    }

    private void checkClientLocale(String string, Properties properties) {
        int n;
        String string2 = properties.getProperty("CLIENT_LOCALE");
        if (string2 == null && (n = string.indexOf("CLIENT_LOCALE")) != -1) {
            String string3 = null;
            string3 = string.substring(n, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken(";");
                if (string4.indexOf(61) == -1) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
                String string5 = stringTokenizer2.nextToken();
                String string6 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                if (!string5.equals("CLIENT_LOCALE")) continue;
                string2 = string6;
            }
        }
        if (string2 != null) {
            this.ClientLocale = new String(string2);
            this.setStaticClientLocale(string2);
        }
    }

    private void setStaticClientLocale(String string) {
        staticClientLocale = string;
    }

    private boolean validDatabaseIdentifier(String string) {
        int n = 1;
        int n2 = 0;
        String string2 = null;
        n2 = string.lastIndexOf("/");
        string2 = n2 != -1 ? string.substring(n2 + 1) : string;
        int n3 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        n = 1;
        while (n < n3) {
            c = string2.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String calcReleaseNum() {
        return null;
    }

    public static String getJDBCVersion() throws SQLException {
        return "2.21.JC3";
    }

    static int getJDBCMajorVersion() throws SQLException {
        Integer n;
        String string = IfxDriver.getJDBCVersion();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    static int getJDBCMinorVersion() throws SQLException {
        Integer n;
        String string = IfxDriver.getJDBCVersion();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    private boolean formatProxy(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer("http://");
        int n = string.indexOf(63);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n, string.length());
        } else {
            string3 = string;
        }
        try {
            string5 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.toUpperCase().indexOf("HTTP") != -1 || string2.toUpperCase().indexOf("SERVLET") != -1 || string2.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            string5 = string2;
        }
        stringBuffer.append(string5);
        stringBuffer.append("/servlet/IfxJDBCProxy");
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        this.Proxy = new String(stringBuffer.toString());
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException sQLException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80034, (String)null) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, (String)null));
        }
        IfxDriver.setJDKVersion();
    }
}

