/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxLobInputStream
extends InputStream {
    static final int LO_INTERNAL_BUF_MAX_SIZE = 4084;
    IfxConnection conn = null;
    IfxLocator locator = null;
    long lobSize = 0L;
    long total_read = 0L;
    private int loFd;
    private IfxLocator loPtr = null;
    private IfxSmartBlob smb = null;
    byte[] buffer = null;
    int pos = 0;
    int count = 0;

    public IfxLobInputStream(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException, IOException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        try {
            this.smb = new IfxSmartBlob(this.conn);
            this.loFd = this.smb.IfxLoOpen(this.locator, 4);
            this.lobSize = this.smb.IfxLoSize(this.loFd);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read() throws IOException {
        int n = 0;
        if ((this.buffer == null || this.pos == this.count) && (n = this.readLob()) == -1) {
            return -1;
        }
        ++this.total_read;
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.read(byArray, 0, byArray.length);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = 0;
        var5_5 = 0;
        var7_6 = true;
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        if (var2_2 < 0 || var2_2 > var1_1.length || var3_3 < 0 || var2_2 + var3_3 > var1_1.length || var2_2 + var3_3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 != 0) ** GOTO lbl19
        return 0;
lbl-1000:
        // 1 sources

        {
            if ((this.buffer == null || this.pos == this.count) && (var5_5 = this.readLob()) == -1) {
                if (!var7_6) continue;
                var4_4 = -1;
                return -1;
            }
            var6_7 = Math.min(this.count - this.pos, var3_3 - var4_4);
            System.arraycopy(this.buffer, this.pos, var1_1, var4_4 + var2_2, var6_7);
            var7_6 = false;
            var4_4 += var6_7;
            this.pos += var6_7;
lbl19:
            // 3 sources

            ** while (var4_4 < var3_3 && var5_5 >= 0)
        }
lbl20:
        // 1 sources

        this.total_read += (long)var4_4;
        return var4_4;
    }

    public long skip(long l) throws IOException {
        try {
            return this.smb.IfxLoSeek(this.loFd, l, 1);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void reset() throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, 0L, 0);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return (int)(this.lobSize - this.total_read);
    }

    public void close() throws IOException {
        try {
            this.smb.IfxLoClose(this.loFd);
            this.smb.IfxLoRelease(this.locator);
            this.smb = null;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected synchronized void finalize() throws IOException {
        try {
            if (this.smb != null) {
                ((IfxSqliConnect)this.conn).addToBlobList(this.smb);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readLob() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.lobSize > 4084L ? new byte[4084] : new byte[(int)this.lobSize];
        }
        try {
            this.pos = 0;
            this.count = this.smb.IfxLoRead(this.loFd, this.buffer, this.buffer.length);
            if (this.count == 0) {
                return -1;
            }
            return this.count;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    protected InputStream getStream() throws SQLException {
        if (this.lobSize == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.smb.IfxLoRead(this.loFd, (int)this.lobSize));
        return byteArrayInputStream;
    }
}

