/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Vector;

class IfxRowColumn {
    IfxConnection conn;
    ByteArrayOutputStream bStream;
    byte[] tuple;
    IfxResultSetMetaData rsmd;
    int offset;
    Vector colInfoVector;
    private int initialSize;
    private int currDataSize;
    private boolean dataInStream;
    Trace trace;

    IfxRowColumn(IfxConnection ifxConnection, IfxResultSetMetaData ifxResultSetMetaData, int n) throws SQLException {
        this.rsmd = ifxResultSetMetaData;
        this.conn = ifxConnection;
        try {
            if (this.rsmd.hasVariableLengthColumns) {
                n += 1024;
            }
            this.initialSize = n;
            this.tuple = new byte[this.initialSize];
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    IfxRowColumn(IfxConnection ifxConnection, IfxResultSetMetaData ifxResultSetMetaData) {
        this.conn = ifxConnection;
        this.rsmd = ifxResultSetMetaData;
    }

    void readTuple(IfxDataInputStream ifxDataInputStream, int n, int n2) throws SQLException {
        if (this.dataInStream || this.currDataSize + n2 > this.initialSize) {
            try {
                byte[] byArray = new byte[n2];
                if (!this.dataInStream) {
                    if (this.bStream == null) {
                        this.bStream = new ByteArrayOutputStream();
                    }
                    if (this.currDataSize > 0) {
                        this.bStream.write(this.tuple, 0, this.currDataSize);
                    }
                    this.dataInStream = true;
                }
                ifxDataInputStream.readPadded(byArray, 0, n2);
                this.bStream.write(byArray, 0, n2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        try {
            ifxDataInputStream.readPadded(this.tuple, n, n2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        this.currDataSize += n2;
    }

    void setOffsetInTuple(int n) throws SQLException {
        this.offset = n;
        if (this.rsmd.hasVariableLengthColumns || this.rsmd.hasVariableLengthCharColumns) {
            int n2 = n;
            int n3 = 0;
            if (this.colInfoVector == null) {
                this.colInfoVector = new Vector();
                this.colInfoVector.setSize(this.rsmd.getColumnCount());
            }
            int n4 = 1;
            while (n4 <= this.rsmd.getColumnCount()) {
                int n5;
                Object object;
                int n6 = this.rsmd.getIfxColumnType(n4);
                int n7 = this.rsmd.getColumnLength(n4);
                if (n6 == 40 || n6 == 41 || n6 == 45 || n6 == 43) {
                    object = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, n2 + 1, object, 0, 4);
                    n5 = IfxToJavaType.IfxToJavaInt(object);
                    n7 = 5 + n5;
                } else if (n6 == 13 || n6 == 16) {
                    if (((IfxSqliConnect)this.conn).isVarcharVarLenSupported()) {
                        if (this.dataInStream) {
                            this.tuple = this.bStream.toByteArray();
                            this.dataInStream = false;
                            this.bStream.reset();
                        }
                        n7 = 1 + (this.tuple[n2] & 0xFF);
                    } else {
                        ++n7;
                    }
                } else if (IfxTypes.isComplexType(n6)) {
                    object = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, n2, object, 0, 4);
                    n5 = IfxToJavaType.IfxToJavaInt(object);
                    n7 = n5 + 4;
                }
                n2 += n7;
                object = new columnInfo();
                object.startPos = n3;
                object.len = n7;
                this.colInfoVector.setElementAt(object, n4 - 1);
                n3 += n7;
                ++n4;
            }
        }
    }

    void setMetaData(IfxResultSetMetaData ifxResultSetMetaData) {
        this.rsmd = ifxResultSetMetaData;
    }

    void setTrace(Trace trace) {
    }

    IfxObject getColumn(int n) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n));
        this.loadColumnData(n, ifxObject);
        return ifxObject;
    }

    void loadColumnData(int n, IfxObject ifxObject) throws SQLException {
        int n2;
        int n3;
        Object object;
        int n4 = this.rsmd.getIfxColumnType(n);
        ifxObject.clear();
        if (this.colInfoVector != null) {
            if (n > this.colInfoVector.size()) {
                throw IfxErrMsg.getSQLException(-79703, this.conn);
            }
            object = (columnInfo)this.colInfoVector.elementAt(n - 1);
            n3 = ((columnInfo)object).len;
            n2 = ((columnInfo)object).startPos;
        } else {
            n3 = n4 == 2 || n4 == 7 || n4 == 1 || n4 == 4 || n4 == 17 || n4 == 3 ? 1 : this.rsmd.getColumnLength(n);
            n2 = this.rsmd.getColumnStartPosition(n);
        }
        object = this.tuple;
        if (this.dataInStream) {
            object = this.bStream.toByteArray();
        }
        if (!(this.rsmd.hasVariableLengthColumns || n4 != 13 && n4 != 16)) {
            ++n3;
        }
        if (object != null && n3 > 0) {
            try {
                if (object != null) {
                    if (n4 == 5 || n4 == 8 || n4 == 14 || n4 == 10) {
                        ifxObject.fromIfx((byte[])object, this.offset + n2, n3, (short)this.rsmd.getEncodedLength(n));
                    } else {
                        ifxObject.fromIfx((byte[])object, this.offset + n2, n3);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    private void writeTrace(int n, String string) {
    }

    byte[] getTupleData() {
        if (!this.dataInStream) {
            return this.tuple;
        }
        return this.bStream.toByteArray();
    }

    void reset() {
        if (this.dataInStream) {
            this.dataInStream = false;
            this.bStream.reset();
        }
        this.currDataSize = 0;
    }

    void clear() {
        this.reset();
        this.rsmd = null;
    }

    class columnInfo {
        int startPos;
        int len;

        columnInfo() {
        }
    }
}

