/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxShort
extends IfxObject {
    private short value;
    public static final short IFX_SMINT_NULL = Short.MIN_VALUE;

    IfxShort() throws SQLException {
        this.setIfxType(1);
    }

    IfxShort(short s) throws SQLException {
        this.setIfxType(1);
        this.value = s;
        this.unnullify();
    }

    IfxShort(Short s) throws SQLException {
        this.setIfxType(1);
        this.value = s;
        this.unnullify();
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[]{-128, 0};
            return byArray;
        }
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) {
        this.value = IfxToJavaType.IfxToJavaSmallInt(byArray, n);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Short(this.value);
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.shortValue();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s;
            this.unnullify();
        }
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    public void fromInt(int n) throws SQLException {
        this.value = (short)n;
        this.unnullify();
    }

    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.shortValue();
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    public void fromLong(long l) throws SQLException {
        this.value = (short)l;
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.shortValue();
            this.unnullify();
        }
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(float f) throws SQLException {
        this.value = (short)f;
        this.unnullify();
    }

    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.shortValue();
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double d) throws SQLException {
        this.value = (short)d;
        this.unnullify();
    }

    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d.shortValue();
            this.unnullify();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = (short)bigDecimal.intValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = (short)(bl ? 1 : 0);
        this.unnullify();
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = (short)(bl == true ? 1 : 0);
            this.unnullify();
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            this.value = Short.valueOf(string.trim());
            this.unnullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxShort && this.value == ((IfxShort)object).value;
    }

    public short getEncodedLength() {
        short s = 1280;
        return s;
    }

    public boolean isIfxNull() {
        return this.value == Short.MIN_VALUE;
    }
}

