/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxSmBlob
extends IfxBaseType {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_READWITHSEEK = 1;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    protected static final short BLOB_TYPE_BYTES = 1;
    protected static final short BLOB_TYPE_STREAM = 2;
    protected boolean LOB_ELEMENT_COLL = false;
    protected IfxLocator locator = null;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public IfxSmBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxSmBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    public IfxSmBlob(Blob blob) throws SQLException {
        this.fromBlob(blob);
        this.IfxSmBlobType = (short)2;
    }

    public IfxSmBlob(Clob clob) throws SQLException {
        this.fromClob(clob);
        this.IfxSmBlobType = (short)3;
    }

    private void getSize() {
        try {
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoOpen(this.locator, 16);
            this.sm_size = ifxSmartBlob.IfxLoSize(this.loFd);
            ifxSmartBlob.IfxLoClose(this.loFd);
            ifxSmartBlob = null;
        }
        catch (Exception exception) {
            this.sm_size = 0L;
        }
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        super.fromIfx(byArray, n, n2);
        if (!this.isNull()) {
            byte[] byArray2 = this.inputStream.toByteArray();
            this.locator = new IfxLocator(byArray2, this.conn);
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    protected void fromIfxFP(byte[] byArray) throws SQLException {
        super.fromIfx(byArray);
        if (!this.isNull()) {
            byte[] byArray2 = this.inputStream.toByteArray();
            this.locator = new IfxLocator(byArray2, this.conn);
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfxTuple();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.locator);
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IfxInputStream ifxInputStream = new IfxInputStream(this.tempBlobFile);
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.sm_size = n;
        this.BlobInputStream = inputStream;
        this.isBlob_loaded = false;
        this.blobType = (short)2;
        this.blobBuffer = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.createBlobOnServer(inputStream, n);
        }
    }

    public void createBlobOnServer(InputStream inputStream, int n) throws SQLException {
        OutputStream outputStream = null;
        String string = null;
        int n2 = 0;
        this.unnullify();
        IfxSmartBlob ifxSmartBlob = null;
        try {
            IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(this.conn);
            ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
            if (n > 0) {
                if (this.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText()) {
                    Object object;
                    String string2 = ((IfxSqliConnect)this.conn).getclEncoding();
                    String string3 = ((IfxSqliConnect)this.conn).getdbEncoding();
                    n2 = ((IfxSqliConnect)this.conn).getCodesetLobSize();
                    if (n <= n2) {
                        outputStream = new ByteArrayOutputStream();
                    } else {
                        try {
                            string = String.valueOf(System.currentTimeMillis());
                            object = Thread.currentThread().getName();
                            string = ((IfxSqliConnect)this.conn).getJDBCTempDir() + "ifxb_" + (String)object + string.substring(4);
                            this.tempBlobFile = new IfxTmpFile(string, this.conn);
                            outputStream = new FileOutputStream(string);
                        }
                        catch (Exception exception) {
                            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                        }
                    }
                    try {
                        int n3;
                        object = new BufferedReader(new InputStreamReader(inputStream, string2));
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string3));
                        char[] cArray = new char[4096];
                        while ((n3 = ((Reader)object).read(cArray)) != -1) {
                            ((Writer)bufferedWriter).write(cArray, 0, n3);
                        }
                        ((Reader)object).close();
                        ((Writer)bufferedWriter).flush();
                        ((Writer)bufferedWriter).close();
                        outputStream.close();
                        if (n <= n2) {
                            inputStream = new IfxByteArrayInputStream((ByteArrayOutputStream)outputStream);
                            n = ((ByteArrayOutputStream)outputStream).size();
                        } else {
                            inputStream = new IfxInputStream(this.tempBlobFile);
                            File file = new File(string);
                            n = (int)file.length();
                        }
                    }
                    catch (Exception exception) {
                        throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                    }
                }
                int n4 = 0;
                n4 = inputStream != null ? ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n) : ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer);
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
        }
        catch (SQLException sQLException) {
            if (ifxSmartBlob != null) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)3;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)2;
    }

    public String toString() {
        try {
            IfxCblob ifxCblob = new IfxCblob(this.conn, this.locator);
            ifxCblob.setSize(this.sm_size);
            return ifxCblob.getSubString(1L, (int)this.sm_size);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = string.length();
        try {
            String string2 = this.conn.getdbEncoding();
            this.blobBuffer = string2 != null ? string.getBytes(string2) : string.getBytes();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
        boolean bl = false;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.unnullify();
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.extendedID == 10) {
            return this.toBlob();
        }
        return this.toClob();
    }

    public void fromObject(Object object) throws SQLException {
        if (object instanceof String) {
            this.fromString((String)object);
        } else if (object instanceof byte[]) {
            this.fromBytes((byte[])object);
        } else if (object instanceof Blob) {
            this.fromBlob((Blob)object);
        } else if (object instanceof Clob) {
            this.fromClob((Clob)object);
        } else {
            throw IfxErrMsg.getSQLException(-79791, this.conn);
        }
    }

    public byte[] toBytes() throws SQLException {
        this.getSize();
        IfxBblob ifxBblob = new IfxBblob(this.conn, this.locator);
        ifxBblob.setSize(this.sm_size);
        byte[] byArray = ifxBblob.getPortion(1L, this.sm_size);
        ifxBblob.close();
        return byArray;
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = byArray.length;
        this.blobBuffer = byArray;
        this.unnullify();
        boolean bl = false;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public Blob toBlob() throws SQLException {
        this.getSize();
        IfxBblob ifxBblob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxBblob = new IfxBblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79701, this.conn);
                }
            } else if (this.blobBuffer != null) {
                ifxBblob = new IfxBblob(this.blobBuffer);
            }
        } else {
            ifxBblob = new IfxBblob(this.conn, this.locator);
        }
        ifxBblob.setIfxLobType((short)2);
        ifxBblob.setSize(this.sm_size);
        return ifxBblob;
    }

    public Clob toClob() throws SQLException {
        return this.toClob(8);
    }

    public Clob toClob(int n) throws SQLException {
        this.getSize();
        IfxLob ifxLob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxLob = new IfxCblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79701, this.conn);
                }
            } else if (this.blobBuffer != null) {
                ifxLob = new IfxCblob(this.blobBuffer);
            }
        } else {
            ifxLob = new IfxCblob(this.conn, this.locator, n);
        }
        ifxLob.setIfxLobType((short)3);
        ifxLob.setSize(this.sm_size);
        return ifxLob;
    }

    public void fromBlob(Blob blob) throws SQLException {
        if (blob instanceof IfxBblob) {
            IfxBblob ifxBblob = (IfxBblob)blob;
            short s = ifxBblob.getIfxLobType();
            if (s == 2) {
                this.locator = ifxBblob.getLocator();
            } else if (s == 0) {
                this.fromBinaryStream(ifxBblob.getBinaryStream(), (int)ifxBblob.length());
            }
        } else {
            this.fromBinaryStream(blob.getBinaryStream(), (int)blob.length());
        }
        this.unnullify();
    }

    public void fromClob(Clob clob) throws SQLException {
        if (clob instanceof IfxCblob) {
            IfxCblob ifxCblob = (IfxCblob)clob;
            short s = ifxCblob.getIfxLobType();
            if (s == 3) {
                this.locator = ifxCblob.getLocator();
            } else if (s == 1) {
                this.fromAsciiStream(ifxCblob.getAsciiStream(), (int)ifxCblob.length());
            }
        } else {
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
        this.unnullify();
    }

    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tempBlobFile = null;
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

