/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxSmallFloat
extends IfxObject {
    private float value;
    private static final int IFX_SMFLOAT_SIZE = 4;

    IfxSmallFloat() throws SQLException {
        this.setIfxType(4);
    }

    IfxSmallFloat(float f) throws SQLException {
        this.setIfxType(4);
        this.value = f;
        this.unnullify();
    }

    IfxSmallFloat(Float f) throws SQLException {
        this.setIfxType(4);
        if (f != null) {
            this.value = f.floatValue();
            this.unnullify();
        }
    }

    IfxSmallFloat(double d) throws SQLException {
        this.setIfxType(4);
        this.value = (float)d;
        this.unnullify();
    }

    IfxSmallFloat(Double d) throws SQLException {
        this.setIfxType(4);
        if (d != null) {
            this.value = (float)d.doubleValue();
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) {
        boolean bl = true;
        bl = IfxSmallFloat.isIfxNull(byArray, n, n2);
        if (!bl) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaReal(byArray, n);
        } else {
            this.nullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxSmallFloat) {
            IfxSmallFloat ifxSmallFloat = (IfxSmallFloat)object;
            if (ifxSmallFloat.isNull()) {
                return false;
            }
            return this.value == ifxSmallFloat.value;
        }
        return false;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        byte by = this.isNull() ? (byte)0 : (byte)this.value;
        return by;
    }

    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
        }
    }

    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    public short toShort() throws SQLException {
        this.clearWarning();
        short s = this.isNull() ? (short)0 : (short)this.value;
        return s;
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    public int toInt() throws SQLException {
        int n;
        this.clearWarning();
        if (this.isNull()) {
            n = 0;
        } else {
            n = (int)this.value;
            if (n <= Integer.MIN_VALUE) {
                n = -2147483647;
            }
        }
        return n;
    }

    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
        }
    }

    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    public long toLong() throws SQLException {
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        return l;
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    public double toDouble() throws SQLException {
        double d = this.isNull() ? 0.0 : (double)this.value;
        return d;
    }

    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.value = (float)d;
        this.unnullify();
    }

    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.floatValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        boolean bl = this.isNull() ? false : this.value != 0.0f;
        return bl;
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
            this.unnullify();
        }
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    public String toString() {
        String string = this.isNull() ? null : Float.toString(this.value);
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            try {
                this.value = Float.valueOf(string.trim()).floatValue();
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    static boolean isIfxNull(float f) {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f);
        return IfxSmallFloat.isIfxNull(byArray);
    }

    static boolean isIfxNull(byte[] byArray) {
        return IfxSmallFloat.isIfxNull(byArray, 0, byArray.length);
    }

    static boolean isIfxNull(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            if (byArray[n3 + n] != -1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static float getIfxNull() {
        byte[] byArray = new byte[4];
        float f = 0.0f;
        int n = 0;
        while (n < 4) {
            byArray[n] = -1;
            f = IfxToJavaType.IfxToJavaReal(byArray);
            ++n;
        }
        return f;
    }
}

