/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class IfxSqli
implements IfxProtocol {
    IfxResultSetMetaData desc;
    private FileOutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileAmount;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short statementID = (short)-1;
    private short statementType;
    protected IfxSqliConnect conn;
    protected Trace trace;
    protected Trace protoTrace;
    private String dbEncoding;
    private boolean isText;
    private boolean convText;
    private long serial8Inserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean typeSent;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private SQLException exception;
    private String sqlerrm;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort;
    private boolean OpenDBStmt;
    private String serverVersion;
    private Vector offsetVector = new Vector();
    private int totalTupleSize;
    private int curOffset;
    private int totalTuples;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit;
    private int Tupid;
    private int fpHandle;
    private Vector fpRet;
    private Vector fpInput;
    private IfxFParam fparam;
    private boolean partialFParam;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    private final int INFX_BUFSIZE = 4096;
    private final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    private final int INFX_MAX_BIGBUFSIZE = 0x200000;
    private final int INFX_MAXQUOTEDSTRINGSIZE = 65535;
    private IfxRowColumn rowColumn;
    protected IfxDataOutputStream os;
    protected IfxDataInputStream is;
    protected boolean SQ_CLOSERecvd;
    private boolean SQ_CLOSESent;
    private boolean first = true;
    private Vector DBList;
    boolean executeBatchInProgress;
    public ArrayList batchRowStatus;
    private int batchCount;
    private int batchRowSize;

    public IfxSqli(IfxSqliConnect ifxSqliConnect) {
        this.conn = ifxSqliConnect;
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
        this.convText = this.conn.isConvText();
    }

    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void clear() {
        this.serial8Inserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        this.sqlerrm = null;
        int n = 0;
        while (n < 10) {
            this.sqlerrd[n] = 0;
            if (n < 8) {
                this.serverWarningsString.setCharAt(n, ' ');
            }
            n = (short)(n + 1);
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
            this.rowColumn = null;
        }
    }

    private void resetTuples() {
        this.offsetVector.removeAllElements();
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(new Integer(0), 0);
        this.totalTupleSize = 0;
        this.curOffset = 0;
        this.curRow = -1;
        this.totalTuples = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
    }

    public void executeBegin() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendBegin() throws SQLException {
        try {
            this.os.writeSmallInt((short)35);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCommit() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(true);
    }

    private void sendCommit() throws SQLException {
        try {
            this.os.writeSmallInt((short)19);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeRollback() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(false);
    }

    public void executeGetDBList() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    public Vector getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        try {
            this.os.writeSmallInt((short)26);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveDBList() throws SQLException {
        try {
            String string;
            this.DBList = new Vector();
            while ((string = new String(this.is.readChar(this.dbEncoding))).length() != 0) {
                boolean bl = false;
                int n = 0;
                while (n < this.DBList.size()) {
                    String string2 = (String)this.DBList.elementAt(n);
                    if (string.compareToIgnoreCase(string2) < 0) {
                        this.DBList.insertElementAt(string, n);
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                this.DBList.insertElementAt(string, this.DBList.size());
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendRollback() throws SQLException {
        try {
            this.os.writeSmallInt((short)20);
            this.os.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCommand(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (statement instanceof IfxPreparedStatement && ((IfxPreparedStatement)statement).usePut()) {
                this.initiateTransaction();
                this.sendPut((IfxPreparedStatement)statement);
            } else {
                this.sendCommand((IfxStatement)statement);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(statement));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.SendCommit || this.conn.db_use_log && this.conn.autoCommit && statement instanceof IfxPreparedStatement && ((IfxPreparedStatement)statement).usePut()) {
            this.executeCommit();
            this.conn.setTxEndState();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendCommand(IfxStatement ifxStatement) throws SQLException {
        if (!this.conn.autoCommit && !ifxStatement.commandString.trim().toLowerCase().startsWith("begin")) {
            this.initiateTransaction();
        }
        this.batchRowSize = ifxStatement.BatchVector.size();
        if (ifxStatement.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        if (ifxStatement instanceof IfxPreparedStatement) {
            this.sendExecute(ifxStatement);
        } else {
            int n;
            String[] stringArray = null;
            if (this.conn.isBatchUpdatePerSpec() && this.batchRowSize > 0 && this.executeBatchInProgress) {
                stringArray = new String[this.batchRowSize];
                n = 0;
                while (n < this.batchRowSize) {
                    stringArray[n] = (String)ifxStatement.BatchVector.elementAt(n);
                    ++n;
                }
            } else {
                stringArray = new String[]{ifxStatement.commandString};
            }
            try {
                if (ifxStatement.commandString.length() > 65535) {
                    throw IfxErrMsg.getSQLException(-79864, this.conn);
                }
                n = 0;
                do {
                    this.os.writeSmallInt((short)1);
                    this.os.writeSmallInt((short)0);
                    this.os.writeChar(stringArray[n++], this.dbEncoding);
                    this.os.writeSmallInt((short)22);
                    this.os.writeSmallInt((short)7);
                    this.os.writeSmallInt((short)11);
                    this.isReleased = true;
                } while (this.conn.isBatchUpdatePerSpec() && n < this.batchRowSize && this.executeBatchInProgress);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
    }

    private void sendBind(IfxPreparedStatement ifxPreparedStatement) throws SQLException {
        this.sendBind(ifxPreparedStatement.getVector(), ifxPreparedStatement.inputvals, 0, ifxPreparedStatement.inputvals);
    }

    private void sendBind(Vector vector, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        try {
            this.os.writeSmallInt((short)5);
            this.os.writeSmallInt((short)n);
            int n5 = n2;
            while (n5 < n3) {
                Object object;
                IfxObject ifxObject = (IfxObject)vector.elementAt(n5);
                short s = (short)ifxObject.getIfxType();
                if (s == 11 || s == 12) {
                    if (((IfxBlob)ifxObject).isIfxTextType()) {
                        s = 12;
                    }
                    if (!ifxObject.isNull()) {
                        ++n4;
                    }
                }
                this.os.writeSmallInt(s);
                if (this.conn.isUSVER() && s >= 18) {
                    object = null;
                    String string = null;
                    object = ifxObject.getExtendedOwner();
                    string = ifxObject.getExtendedTypeName();
                    if (object == null) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeChar((String)object);
                    }
                    this.os.writeChar(string);
                }
                if (ifxObject.isNull()) {
                    this.os.writeSmallInt((short)-1);
                    this.os.writeSmallInt((short)0);
                } else {
                    this.os.writeSmallInt((short)0);
                    short s2 = ifxObject.getEncodedLength();
                    this.os.writeSmallInt(s2);
                    object = ifxObject.toIfx();
                    this.os.writePadded((byte[])object);
                    if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                        this.conn.setDbName(ifxObject.toString());
                    }
                    if (this.statementType == 31) {
                        this.conn.setDbName(null);
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (n4 > 0) {
            this.sendBlob(vector, n4, n);
        }
    }

    public void executePrepare(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)statement);
            this.receiveMessage();
            ((IfxStatement)statement).setStatementType(this.statementType);
            if (this.desc != null) {
                this.desc.parseSetTableName(((IfxStatement)statement).commandString);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)statement).commandString);
        }
    }

    private void sendPrepare(IfxStatement ifxStatement) throws SQLException {
        String string = ifxStatement.commandString;
        try {
            if (string.length() > 65535) {
                throw IfxErrMsg.getSQLException(-79864, this.conn);
            }
            if (this.conn.db_use_log && !this.conn.autoCommit && this.conn.isBatchUpdatePerSpec() && ifxStatement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                if (ifxPreparedStatement.BatchVector.size() > 0 && !ifxPreparedStatement.usePut()) {
                    this.initiateTransaction();
                }
            }
            this.os.writeSmallInt((short)2);
            this.os.writeSmallInt((short)ifxStatement.numqmarks);
            this.os.writeChar(string, this.dbEncoding);
            this.os.writeSmallInt((short)22);
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendStatementExecute(IfxStatement ifxStatement) throws SQLException {
        this.sendExecute(ifxStatement);
        this.receiveMessage();
    }

    private void sendExecute(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (this.conn.isBatchUpdatePerSpec() && ifxStatement.executeBatchInProgress) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                int n = ifxPreparedStatement.BatchVector.size();
                if (ifxPreparedStatement.inputvals > 0) {
                    Vector vector = ifxPreparedStatement.getVector();
                    int n2 = 0;
                    int n3 = ifxPreparedStatement.getqmarks();
                    int n4 = 0;
                    while (n4 < n) {
                        n2 = n4 * n3;
                        int n5 = n2 + n3;
                        this.sendBind(vector, n3, n2, n5);
                        this.os.writeSmallInt((short)7);
                        ++n4;
                    }
                }
            } else {
                if (ifxStatement instanceof IfxPreparedStatement) {
                    IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                    if (ifxPreparedStatement.inputvals != ifxPreparedStatement.getqmarks() && ifxPreparedStatement.BatchVector.size() == 0) {
                        throw IfxErrMsg.getSQLException(-79749, this.conn);
                    }
                    if (ifxPreparedStatement.inputvals > 0) {
                        if (ifxPreparedStatement.BatchVector.size() > 0 && !ifxPreparedStatement.executeBatchInProgress) {
                            int n = ifxPreparedStatement.getqmarks();
                            int n6 = (ifxPreparedStatement.vector.size() - ifxPreparedStatement.BatchVector.size()) / n;
                            this.sendBind(ifxPreparedStatement.vector, n6, n * ifxPreparedStatement.BatchVector.size(), ifxPreparedStatement.vector.size());
                        } else {
                            this.sendBind(ifxPreparedStatement);
                        }
                    }
                }
                this.os.writeSmallInt((short)7);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeStatementQuery(Statement statement) throws SQLException {
        this.executeStatementQuery(statement, false, null);
    }

    public void executeStatementQuery(Statement statement, boolean bl) throws SQLException {
        this.executeStatementQuery(statement, bl, null);
    }

    public void executeStatementQuery(Statement statement, boolean bl, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && n > 0) {
            try {
                if (!this.conn.autoCommit) {
                    this.initiateTransaction();
                }
                this.sendStatementQuery((IfxStatement)statement, bl, (IfxResultSetMetaData)resultSetMetaData);
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendStatementQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.sendQuery(ifxStatement, bl, ifxResultSetMetaData);
        if (ifxStatement.getResultSetType() == 1003) {
            IfxResultSetMetaData ifxResultSetMetaData2 = null;
            if (ifxStatement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)ifxStatement;
                ifxResultSetMetaData2 = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
            }
            if (this.desc.hasVariableLengthColumns) {
                this.receiveMessage();
            }
            if (ifxResultSetMetaData2 != null) {
                this.sendFetch(this.desc.hasVariableLengthColumns, ifxResultSetMetaData2);
            } else {
                this.sendFetch(this.desc.hasVariableLengthColumns, this.desc);
            }
            ifxStatement.cursorOpen = true;
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData ifxResultSetMetaData, short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            int n = 1;
            while (n <= this.desc.getColumnCount()) {
                IfxResultSetMetaData ifxResultSetMetaData2;
                if (ifxResultSetMetaData != null && ifxResultSetMetaData.getColumnCount() >= n && ifxResultSetMetaData.getIfxColumnType(n) != -99) {
                    ifxResultSetMetaData2 = ifxResultSetMetaData;
                    this.desc.setIfxColumnType(n, ifxResultSetMetaData.getIfxColumnType(n));
                    this.desc.setExtendedName(n, ifxResultSetMetaData.getExtendedName(n));
                    this.desc.setColumnExtendedId(n, ifxResultSetMetaData.getColumnExtendedId(n));
                    this.desc.setEncodedLength(n, ifxResultSetMetaData.getEncodedLength(n));
                } else {
                    ifxResultSetMetaData2 = this.desc;
                }
                int n2 = ifxResultSetMetaData2.getIfxColumnType(n);
                boolean bl = ifxResultSetMetaData2.isVariableLengthType(n);
                if (bl && n2 != 13 && n2 != 16) {
                    short s2 = ifxResultSetMetaData2.isDistinct(n) ? (short)ifxResultSetMetaData2.getSourceType(n) : (short)ifxResultSetMetaData2.getColumnExtendedId(n);
                    n2 = s2 == 3 ? 46 : (s2 == 4 ? 47 : (s2 == 1 ? 43 : (s2 == 5 ? 45 : 44)));
                }
                this.os.writeSmallInt((short)n2);
                if (bl && n2 != 13 && n2 != 16) {
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedOwnerName(n));
                    this.os.writeChar(ifxResultSetMetaData2.getExtendedName(n));
                }
                this.os.writeInt(ifxResultSetMetaData2.getEncodedLength(n));
                ++n;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendQuery(IfxStatement ifxStatement, boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        try {
            int n;
            IfxPreparedStatement ifxPreparedStatement;
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)3);
            String string = ifxStatement.getCursorName();
            this.os.writeChar(string, this.dbEncoding);
            if (ifxStatement instanceof IfxPreparedStatement && !(ifxPreparedStatement = (IfxPreparedStatement)ifxStatement).usePut() && ifxPreparedStatement.inputvals > 0) {
                this.sendBind(ifxPreparedStatement);
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (ifxStatement.getAutoFree()) {
                this.os.writeSmallInt((short)108);
            }
            if ((n = ifxStatement.getResultSetType()) == 1004) {
                this.os.writeSmallInt((short)24);
            }
            if (bl) {
                this.os.writeSmallInt((short)43);
            }
            this.os.writeSmallInt((short)6);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        ifxStatement.cursorOpen = true;
    }

    public void executeOpenDatabase(String string, int n) throws SQLException {
        if (string == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.os.writeSmallInt((short)36);
            this.os.writeChar(string, this.dbEncoding);
            this.os.writeSmallInt((short)n);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(string);
    }

    public void executeClose(Statement statement) throws SQLException {
        if (this.conn.SendCommit && !this.doneCommit) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (((IfxStatement)statement).cursorOpen) {
            if (!this.conn.lockSession()) {
                throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
            }
            ((IfxStatement)statement).cursorOpen = false;
            if (!this.SQ_CLOSERecvd) {
                try {
                    this.sendClose((IfxStatement)statement);
                    this.receiveMessage();
                }
                catch (SQLException sQLException) {
                    this.conn.unlockSession();
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.conn.unlockSession();
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
            }
            this.conn.unlockSession();
        }
        if (((IfxStatement)statement).getAutoFree()) {
            this.clearAll();
        } else {
            this.clear();
        }
    }

    public void executeRelease(Statement statement) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!((IfxStatement)statement).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)statement).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased && this.statementID != -1) {
                    this.sendRelease((IfxStatement)statement);
                    this.statementID = (short)-1;
                    this.receiveMessage();
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
            catch (Exception exception) {
                this.conn.unlockSession();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        this.conn.unlockSession();
        ((IfxStatement)statement).cursorOpen = false;
        this.clearAll();
    }

    void executeFetch() throws SQLException {
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetch(false, this.desc);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendFetch(boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        int n = this.getTupleBufferSize();
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (bl) {
                this.sendType(ifxResultSetMetaData, (short)1);
            }
            this.os.writeSmallInt((short)9);
            if (this.conn.isXPSVER8_40()) {
                this.os.writeInt(n);
            } else {
                this.os.writeSmallInt((short)n);
            }
            if (this.conn.isFetchArr()) {
                this.os.writeSmallInt((short)0);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, ifxResultSetMetaData, n);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendClose(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)10);
            this.SQ_CLOSESent = true;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendRelease(IfxStatement ifxStatement) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)11);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeCloseDatabase() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        String string = this.conn.getConnectionDbName();
        if (string != null && string.length() != 0) {
            this.conn.unlockSession();
            return;
        }
        try {
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
            this.conn.setDbName(null);
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    public void executeExecute(Statement statement) throws SQLException {
        this.executeExecute(statement, null);
    }

    public void executeExecute(Statement statement, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(statement instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)statement);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)statement).commandString);
                }
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        try {
            if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                this.sendStatementQuery((IfxStatement)statement, false, (IfxResultSetMetaData)resultSetMetaData);
            } else {
                this.sendStatementExecute((IfxStatement)statement);
            }
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw sQLException;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(statement));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.SendCommit && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    public void receiveMessage() throws SQLException {
        short s = 0;
        this.clearExceptions();
        try {
            this.flip();
            while (this.dispatchMsg(s = this.is.readSmallInt()) && s != 12 && s != 56) {
            }
        }
        catch (SQLException sQLException) {
            this.addException(sQLException);
        }
        catch (Exception exception) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public boolean dispatchMsg(int n) throws Exception {
        boolean bl = true;
        switch (n) {
            case 56: {
                this.sendExit();
                break;
            }
            case 8: {
                this.receiveDescribe();
                break;
            }
            case 14: {
                this.receiveTuple();
                break;
            }
            case 25: {
                this.receiveTupleId();
                break;
            }
            case 15: {
                this.receiveDone();
                break;
            }
            case 39: {
                if (this.isText && this.convText) {
                    this.receiveText();
                    break;
                }
                this.receiveBlob();
                break;
            }
            case 97: {
                this.receiveLODATA();
                break;
            }
            case 13: {
                this.receiveError();
                break;
            }
            case 55: {
                this.receiveCost();
                break;
            }
            case 94: {
                this.receiveInsertDone();
                break;
            }
            case 99: {
                this.receiveXactstat();
                break;
            }
            case 10: {
                this.SQ_CLOSERecvd = true;
                break;
            }
            case 81: {
                this.receiveInfo();
                break;
            }
            case 53: {
                this.receiveVersion();
                break;
            }
            case 12: {
                if (!this.conn.isBatchUpdatePerSpec() || !this.executeBatchInProgress) break;
                this.batchCount = 0;
                this.executeBatchInProgress = false;
                break;
            }
            case 101: {
                this.receiveHandle();
                break;
            }
            case 103: {
                this.receiveFastPath();
                break;
            }
            case 98: {
                this.receiveSQFILE();
                break;
            }
            case 26: {
                this.receiveDBList();
                break;
            }
            case 104: {
                this.receiveFParam();
                break;
            }
            case 18: {
                this.receivePutErr();
                break;
            }
            case 86: {
                break;
            }
            default: {
                this.setError(-408);
                bl = false;
            }
        }
        return bl;
    }

    protected void flip() throws SQLException {
        try {
            this.os.writeSmallInt((short)12);
            this.os.flush();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendExit() throws SQLException {
        if (this.conn != null && !this.conn.isASF()) {
            this.conn.setDatabaseOpen(false, this.serverWarningsShort);
        }
        this.conn.close();
    }

    private void callsetDatabaseOpen(String string) throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDbName(string);
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(n, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        short s = 0;
        int n = 0;
        String string = null;
        short[] sArray = null;
        try {
            this.statementType = this.is.readSmallInt();
            this.statementID = this.is.readSmallInt();
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
            short s2 = this.is.readSmallInt();
            s = this.is.readSmallInt();
            this.desc = new IfxResultSetMetaData(s, this.conn);
            this.desc.setTupleSize(s2);
            short s3 = this.is.readSmallInt();
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            if (s > 0) {
                sArray = new short[s];
                short s4 = 1;
                while (s4 <= s) {
                    short s5;
                    sArray[s4 - 1] = this.is.readSmallInt();
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnStartPosition(s4, n);
                    } else {
                        s5 = this.is.readSmallInt();
                        this.desc.setColumnStartPosition(s4, s5);
                    }
                    s5 = this.is.readSmallInt();
                    this.desc.setIfxColumnType(s4, s5);
                    if (this.conn.isUSVER()) {
                        n = this.is.readInt();
                        this.desc.setColumnExtendedId(s4, n);
                        String string2 = new String(this.is.readChar(this.dbEncoding));
                        this.desc.setExtendedOwnerName(s4, string2);
                        string2 = new String(this.is.readChar());
                        this.desc.setExtendedName(s4, string2);
                        s5 = this.is.readSmallInt();
                        this.desc.setReference(s4, s5);
                        s5 = this.is.readSmallInt();
                        this.desc.setAlignment(s4, s5);
                        n = this.is.readInt();
                        this.desc.setSourceType(s4, n);
                        n = this.is.readInt();
                        this.desc.setEncodedLength(s4, n);
                    } else {
                        s5 = this.is.readSmallInt();
                        this.desc.setEncodedLength(s4, s5);
                    }
                    s4 = (short)(s4 + 1);
                }
                this.desc.setTextByteColumnCount();
            }
            if (s3 > 0) {
                byte[] byArray = new byte[s3];
                this.is.readPadded(byArray);
                string = IfxToJavaType.IfxToJavaChar(byArray, this.dbEncoding);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (string != null) {
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            short s6 = 0;
            while (s6 < s) {
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    this.desc.setColumnName(s6 + 1, string3);
                } else {
                    this.desc.setColumnName(s6 + 1, null);
                }
                s6 = (short)(s6 + 1);
            }
        }
        if (this.conn != null) {
            this.desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
    }

    void setSQLerrd(short s, int n) throws SQLException {
        try {
            this.sqlerrd[s] = n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveInsertDone() throws SQLException {
        try {
            this.serial8Inserted = this.is.readLongInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    private void receiveDone() throws SQLException {
        this.OpenDBStmt = false;
        try {
            if (this.conn.isBatchUpdatePerSpec() && this.batchRowSize > 0 && this.executeBatchInProgress && this.batchRowStatus == null) {
                this.batchRowStatus = new ArrayList();
            }
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            if (this.statementType == 31) {
                this.conn.setDbName(null);
            }
            short s = this.is.readSmallInt();
            this.setWarnings(s, this.OpenDBStmt);
            int n = this.is.readInt();
            if (this.conn.isBatchUpdatePerSpec() && this.batchRowSize > 0 && this.executeBatchInProgress) {
                this.batchRowStatus.add(this.batchCount++, new Integer(n));
            }
            this.setSQLerrd((short)2, n);
            n = this.is.readInt();
            this.setSQLerrd((short)5, n);
            n = this.is.readInt();
            this.setSQLerrd((short)1, n);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    public int getSerialInsert() {
        return this.sqlerrd[1];
    }

    int getISAMCode() {
        return this.isamcode;
    }

    public int getNumberOfRowsProcessed() {
        return this.sqlerrd[2];
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    int getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    int getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        try {
            int n = this.is.readInt();
            this.setSQLerrd((short)0, n);
            n = this.is.readInt();
            this.setSQLerrd((short)3, n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveXactstat() throws SQLException {
        try {
            this.xcEvent = this.is.readSmallInt();
            this.xcNewLevel = this.is.readSmallInt();
            this.xcOldLevel = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        try {
            short s = this.is.readSmallInt();
            int n = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (n > 0) {
                this.rowColumn.readTuple(this.is, this.totalTupleSize, n);
                this.totalTupleSize += n;
                if (++this.totalTuples >= this.offsetVector.size()) {
                    this.offsetVector.setSize(this.totalTuples + 100);
                }
                this.offsetVector.setElementAt(new Integer(this.totalTupleSize), this.totalTuples);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void addException(SQLException sQLException) {
        if (this.exception == null) {
            this.exception = sQLException;
        } else {
            this.exception.setNextException(sQLException);
        }
    }

    private void addException(int n, String string) {
        String string2 = this.conn.getclLocale();
        SQLException sQLException = null;
        sQLException = string != null && string.length() > 0 ? new SQLException(IfxMessage.getMessage(n, string, string2), IfxMessage.getSQLSTATE(n), n) : IfxErrMsg.getSQLException(n, this.conn);
        this.addException(sQLException);
    }

    private void addException(String string, String string2, int n) {
        String string3 = this.conn.getclLocale();
        SQLException sQLException = null;
        sQLException = string == null || string.trim() == "" ? (string2 == null || string2.trim() == "" ? new SQLException(IfxMessage.getMessage(n, string3), IfxMessage.getSQLSTATE(n), n) : new SQLException(IfxMessage.getMessage(n, string3), string2, n)) : (string2 == null || string2.trim() == "" ? new SQLException(string, "U0001", n) : new SQLException(string, string2, n));
        this.addException(sQLException);
    }

    public SQLException getExceptions() {
        return this.exception;
    }

    private void addWarning(SQLWarning sQLWarning) {
        if (this.warn == null) {
            this.warn = sQLWarning;
        } else {
            this.warn.setNextException(sQLWarning);
        }
    }

    private void addWarning(int n, String string) {
        SQLWarning sQLWarning = null;
        sQLWarning = new SQLWarning(string, IfxMessage.getSQLSTATE(n), n);
        this.addWarning(sQLWarning);
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = null;
        sQLWarning = string2 != null ? IfxWarnMsg.getSQLWarning(string2, string, this.conn) : IfxWarnMsg.getSQLWarning(string, this.conn);
        this.addWarning(sQLWarning);
    }

    private void setWarnings(short s, boolean bl) {
        int n = 0;
        this.SQLState = null;
        if (this.conn.Noansiwarn) {
            s = (short)(s & ~16);
        }
        this.serverWarningsShort = s;
        int n2 = 1;
        while (n2 <= 6) {
            n = s & 1;
            if (n == 1) {
                this.serverWarningsString.setCharAt(n2, 'W');
                switch (n2) {
                    case 1: {
                        if (bl) {
                            this.addWarning(null, "01I01");
                            break;
                        }
                        this.addWarning(null, "01006");
                        break;
                    }
                    case 2: {
                        if (bl) {
                            this.addWarning(null, "01I03");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 3: {
                        if (bl) {
                            this.addWarning(null, "01I04");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        if (bl) {
                            this.addWarning(null, "01I10");
                            break;
                        }
                        this.addWarning(null, "01I11");
                    }
                }
            } else {
                this.serverWarningsString.setCharAt(n2, ' ');
            }
            s = (short)(s >> 1);
            n2 = (short)(n2 + 1);
        }
    }

    public void chainWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(sQLWarning);
            } else {
                this.warn = sQLWarning;
            }
        }
    }

    public void clearExceptions() {
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.exception = null;
    }

    public void clearWarnings() {
        this.SQLState = null;
        this.message = null;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.warn = null;
    }

    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receivePutErr() throws SQLException {
        try {
            int n = this.is.readInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.receiveError();
    }

    private void receiveError() throws SQLException {
        try {
            this.sqlcode = this.is.readSmallInt();
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                this.is.readChar();
                this.addException(this.sqlcode, null);
                return;
            }
            this.isamcode = this.is.readSmallInt();
            this.setSQLerrd((short)1, this.isamcode);
            short s = this.is.readSmallInt();
            this.setSQLerrd((short)4, s);
            this.conn.setSQLStatementOffset(s);
            if (this.sqlcode != -368) {
                this.sqlerrm = this.is.readChar(this.dbEncoding).trim();
            }
            if (this.sqlcode == 0 && !this.conn.isUSVER()) {
                this.sqlcode = -407;
                this.isamcode = 0;
                this.addException(this.sqlcode, null);
            } else if (this.sqlcode == 100) {
                this.SQLState = IfxMessage.getSQLSTATE(this.sqlcode);
                this.message = IfxMessage.getMessage(36007, this.conn.getclLocale());
                this.addWarning(this.sqlcode, this.message);
            } else if (this.sqlcode != 0 && this.sqlcode != -937) {
                this.addException(this.sqlcode, this.sqlerrm);
                if (this.isamcode != 0) {
                    this.addException(this.isamcode, null);
                }
            } else {
                byte[] byArray = new byte[5];
                this.is.readPadded(byArray);
                this.SQLState = IfxToJavaType.IfxToJavaChar(byArray);
                this.message = this.is.readChar(this.dbEncoding);
                this.sqlerrm = null;
                if (this.sqlcode == 0) {
                    this.isamcode = 0;
                    this.addWarning(this.message, this.SQLState);
                } else {
                    this.addException(this.message, this.SQLState, this.sqlcode);
                    if (this.isamcode != 0) {
                        this.addException(this.isamcode, null);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            this.addException(-79716, null);
        }
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    private void receiveTupleId() throws SQLException {
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
            } else {
                int n = this.Tupid;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    void executeInfo(short s) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(s);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendInfo(short s) throws SQLException {
        try {
            this.os.writeSmallInt((short)81);
            if (s != 0) {
                this.os.writeSmallInt((short)1);
                this.os.writeSmallInt((short)0);
            }
            this.os.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveInfo() throws SQLException {
        try {
            short s;
            while ((s = this.is.readSmallInt()) > 0) {
                int n = this.is.readSmallInt();
                switch (s) {
                    case 2: {
                        if (n < 4) {
                            this.setError(-408);
                            break;
                        }
                        byte[] byArray = new byte[n - 4];
                        n -= 4;
                        break;
                    }
                    case 3: {
                        int n2;
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < n / 4) {
                            n2 = this.is.readInt();
                            n3 |= n2;
                            ++n4;
                        }
                        this.conn.setTypeList(n3);
                        break;
                    }
                    case 4: {
                        int n2;
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < n / 4) {
                            n2 = this.is.readInt();
                            n5 |= n2;
                            ++n6;
                        }
                        this.conn.setCapList(n5);
                        break;
                    }
                    default: {
                        this.gobbleChars(n);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeEnv(Properties properties) throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(properties);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendEnv(Properties properties) throws SQLException {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        short s5 = 0;
        String string = null;
        String string2 = null;
        int n = 0;
        IfxDataOutputStream ifxDataOutputStream = this.conn.Ifxproto_send();
        if (!this.conn.isASF()) {
            return;
        }
        s = 4;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties.getProperty(string);
            s2 = (short)string.length();
            s3 = (short)string2.length();
            n = s2 & 1;
            if (n == 1) {
                s2 = (short)(s2 + 1);
            }
            if ((n = s3 & 1) == 1) {
                s3 = (short)(s3 + 1);
            }
            s = (short)(s + (s2 + s3 + 4));
            if (s2 > s4) {
                s4 = s2;
            }
            if (s3 <= s5) continue;
            s5 = s3;
        }
        s = (short)(s + 2);
        try {
            ifxDataOutputStream.writeSmallInt((short)81);
            ifxDataOutputStream.writeSmallInt((short)6);
            ifxDataOutputStream.writeSmallInt(s);
            ifxDataOutputStream.writeSmallInt(s4);
            ifxDataOutputStream.writeSmallInt(s5);
            Enumeration<?> enumeration2 = properties.propertyNames();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                string2 = properties.getProperty(string);
                ifxDataOutputStream.writeChar(string, this.dbEncoding);
                ifxDataOutputStream.writeChar(string2, this.dbEncoding);
            }
            ifxDataOutputStream.writeSmallInt((short)0);
            ifxDataOutputStream.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void gobbleChars(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void gobbleSmallInts(int n) throws SQLException {
        try {
            int n2 = 0;
            while (n2 < n) {
                this.is.readSmallInt();
                ++n2;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public void executeVersion() throws SQLException {
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendVersion() throws SQLException {
        try {
            this.os.writeSmallInt((short)53);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveVersion() throws SQLException {
        try {
            this.serverVersion = new String(this.is.readChar());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize() {
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.desc.getTupleSize() <= 2048 ? 4096 : (this.desc.getTupleSize() <= 4096 ? 8192 : (int)this.desc.getTupleSize());
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.isXPSVER8_40() ? (this.conn.fetchBufSize > 0x200000 ? 0x200000 : this.conn.fetchBufSize) : (this.conn.fetchBufSize > Short.MAX_VALUE ? Short.MAX_VALUE : this.conn.fetchBufSize);
        }
        return this.tupleBufferSize;
    }

    public boolean isResultSet() throws SQLException {
        int n = 0;
        if (this.desc != null) {
            n = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && n > 0;
    }

    public int getTupleCount() {
        return this.totalTuples - (this.curRow + 1);
    }

    public boolean getaRow(int n, int n2, int n3, int n4, Statement statement) throws SQLException {
        if (n != 1000 && n2 != 1) {
            throw IfxErrMsg.getSQLException(-79751, this.conn);
        }
        int n5 = this.getTupleCount();
        int n6 = this.totalTuples;
        if (this.first) {
            if (!this.SQ_CLOSERecvd && (n5 == 0 && n6 > 0 || n4 == 1)) {
                if (n4 == 1) {
                    this.executeScrollFetch(n3, n2, statement);
                } else {
                    this.executeFetch();
                    ((IfxStatement)statement).cursorOpen = true;
                }
                n5 = this.getTupleCount();
            }
        } else {
            if (this.SQ_CLOSERecvd) {
                return false;
            }
            if (n5 == 0 && this.totalTuples > 0 || n4 == 1) {
                if (n4 == 1) {
                    this.executeScrollFetch(n3, n2, statement);
                } else {
                    this.executeFetch();
                }
                n5 = this.getTupleCount();
            }
        }
        if (n5 == 0) {
            if (this.conn.SendCommit && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        this.curOffset = (Integer)this.offsetVector.elementAt(this.curRow);
        this.rowColumn.setOffsetInTuple(this.curOffset);
        return true;
    }

    public int getTupleSize() throws SQLException {
        return this.desc.getTupleSize();
    }

    public IfxObject getColumnInRow(int n) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(n);
    }

    public void loadColumnData(int n, IfxObject ifxObject) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(n, ifxObject);
    }

    private void sendBlob(Vector vector, int n, int n2) throws SQLException {
        try {
            this.os.writeSmallInt((short)41);
            this.os.writeSmallInt((short)n);
            this.os.flush();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.isText = false;
            IfxObject ifxObject = (IfxObject)vector.elementAt(n3);
            short s = (short)ifxObject.getIfxType();
            if (s == 12) {
                this.isText = true;
            }
            if (!(ifxObject.isNull() || s != 11 && s != 12)) {
                IfxBlob ifxBlob = (IfxBlob)ifxObject;
                if (s == 11 || this.isText && !this.convText) {
                    if (ifxBlob.isBlobByteType()) {
                        this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                    } else {
                        this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                    }
                } else if (ifxBlob.isBlobByteType()) {
                    this.convTextBlobBuffer(ifxBlob);
                    this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                } else {
                    this.convTextBlobStream(ifxBlob);
                    this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                }
            }
            this.isText = false;
            ++n3;
        }
        this.isText = false;
    }

    private void convTextBlobStream(IfxBlob ifxBlob) throws SQLException {
        String string = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        String string2 = this.conn.getclEncoding();
        String string3 = this.conn.getdbEncoding();
        try {
            int n;
            Object object;
            if (ifxBlob.tb_size <= this.conn.getCodesetLobSize()) {
                inputStream = ifxBlob.getBlobInputStream();
                outputStream = new ByteArrayOutputStream();
            } else {
                string = String.valueOf(System.currentTimeMillis());
                object = Thread.currentThread().getName();
                string = this.conn.getJDBCTempDir() + "ifxb_" + (String)object + string.substring(4);
                ifxTmpFile = new IfxTmpFile(string, this.conn);
                inputStream = ifxBlob.getBlobInputStream();
                outputStream = new FileOutputStream(string);
            }
            object = new BufferedReader(new InputStreamReader(inputStream, string2));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string3));
            char[] cArray = new char[4096];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)object).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            inputStream.close();
            if (ifxBlob.tb_size <= this.conn.getCodesetLobSize()) {
                IfxByteArrayInputStream ifxByteArrayInputStream = new IfxByteArrayInputStream((ByteArrayOutputStream)outputStream);
                ifxBlob.fromInputStream(ifxByteArrayInputStream, ((ByteArrayOutputStream)outputStream).size());
            } else {
                outputStream.close();
                IfxInputStream ifxInputStream = new IfxInputStream(ifxTmpFile);
                File file = new File(string);
                ifxBlob.fromInputStream(ifxInputStream, (int)file.length());
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
        }
    }

    private void convTextBlobBuffer(IfxBlob ifxBlob) throws SQLException {
        String string = null;
        IfxByteArrayInputStream ifxByteArrayInputStream = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        String string2 = this.conn.getclEncoding();
        String string3 = this.conn.getdbEncoding();
        try {
            int n;
            Object object;
            ifxByteArrayInputStream = new IfxByteArrayInputStream(ifxBlob.getBlobBuffer());
            if (ifxBlob.tb_size <= this.conn.getCodesetLobSize()) {
                outputStream = new ByteArrayOutputStream();
            } else {
                string = String.valueOf(System.currentTimeMillis());
                object = Thread.currentThread().getName();
                string = this.conn.getJDBCTempDir() + "ifxb_" + (String)object + string.substring(4);
                ifxTmpFile = new IfxTmpFile(string, this.conn);
                outputStream = new FileOutputStream(string);
            }
            object = new BufferedReader(new InputStreamReader((InputStream)ifxByteArrayInputStream, string2));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string3));
            char[] cArray = new char[4096];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Reader)object).close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            ((InputStream)ifxByteArrayInputStream).close();
            ifxBlob.blobBuffer = null;
            if (ifxBlob.tb_size <= this.conn.getCodesetLobSize()) {
                ifxBlob.setBlobBuffer(((ByteArrayOutputStream)outputStream).toByteArray());
            } else {
                outputStream.close();
                IfxInputStream ifxInputStream = new IfxInputStream(ifxTmpFile);
                File file = new File(string);
                byte[] byArray = new byte[(int)file.length()];
                ifxInputStream.read(byArray, 0, (int)file.length());
                ifxBlob.setBlobBuffer(byArray);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
        }
    }

    private void sendBytesBlob(IfxDataOutputStream ifxDataOutputStream, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                if (n > 1024) {
                    ifxDataOutputStream.writeSmallInt((short)1024);
                    ifxDataOutputStream.writePadded(byArray, n2, 1024);
                    n -= 1024;
                    n2 += 1024;
                    continue;
                }
                ifxDataOutputStream.writeSmallInt((short)n);
                ifxDataOutputStream.writePadded(byArray, n2, n);
                n = 0;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)39);
            ifxDataOutputStream.writeSmallInt((short)0);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendStreamBlob(IfxDataOutputStream ifxDataOutputStream, InputStream inputStream, int n) throws SQLException {
        int n2 = n;
        byte[] byArray = new byte[1024];
        int n3 = 0;
        while (n2 > 0) {
            try {
                if (n2 > 1024) {
                    n3 = inputStream.read(byArray, 0, 1024);
                    if (n3 <= 0) break;
                    ifxDataOutputStream.writeSmallInt((short)39);
                    ifxDataOutputStream.writeSmallInt((short)n3);
                    ifxDataOutputStream.writePadded(byArray, 0, n3);
                    n2 -= n3;
                    continue;
                }
                n3 = inputStream.read(byArray, 0, n2);
                if (n3 <= 0) break;
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)n3);
                ifxDataOutputStream.writePadded(byArray, 0, n3);
                n2 -= n3;
            }
            catch (Exception exception) {
                break;
            }
        }
        if (inputStream instanceof IfxInputStream) {
            try {
                ifxDataOutputStream.flush();
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 0) {
            try {
                ifxDataOutputStream.writeSmallInt((short)39);
                ifxDataOutputStream.writeSmallInt((short)0);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        try {
            ifxDataOutputStream.writeSmallInt((short)40);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.TxStmt == 2 && this.sqlcode != -255) {
                this.conn.setTxEndState();
            }
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
    }

    public void executeFetchBlob(IfxObject ifxObject) throws SQLException {
        int n = this.convText ? this.conn.getCodesetLobSize() : this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        IfxBlob ifxBlob = (IfxBlob)ifxObject;
        int n2 = ifxBlob.getBlobLength();
        short s = (short)ifxObject.getIfxType();
        this.isText = s == 12;
        if (n < 0 || n > 0 && n2 <= n) {
            try {
                this.BlobBuffer = memoryUtil.allocateMemory(n2, this.conn);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79753, exception.toString(), (IfxConnection)this.conn);
            }
            ifxBlob.setBlobBuffer(this.BlobBuffer);
            ifxBlob.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            String string = String.valueOf(System.currentTimeMillis());
            String string2 = Thread.currentThread().getName();
            string = this.conn.getJDBCTempDir() + "ifxb_" + string2 + string.substring(4);
            ifxBlob.tempBlobFile = new IfxTmpFile(string, this.conn);
            try {
                this.BlobFd = new FileOutputStream(((IfxBlob)ifxObject).getBlobFileName());
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception exception) {
                if (n == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = memoryUtil.allocateMemory(n2, this.conn);
                this.BlobFd = null;
                ifxBlob.setBlobBuffer(this.BlobBuffer);
                ifxBlob.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetchBlob((IfxBlob)ifxObject);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                this.isText = false;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isText = false;
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                this.isText = false;
                throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            this.isText = false;
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        if (this.isText && this.convText) {
            this.fetchCodesetConvertedTextBlob(ifxBlob);
        }
        this.isText = false;
    }

    private void fetchCodesetConvertedTextBlob(IfxBlob ifxBlob) throws SQLException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String string = this.conn.getdbEncoding();
        String string2 = this.conn.getclEncoding();
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            if (ifxBlob.tb_size <= this.conn.getCodesetLobSize()) {
                inputStream = new IfxByteArrayInputStream(ifxBlob.blobBuffer);
                outputStream = new ByteArrayOutputStream();
            } else {
                object3 = ifxBlob.tempBlobFile;
                object2 = String.valueOf(System.currentTimeMillis());
                object = Thread.currentThread().getName();
                object2 = this.conn.getJDBCTempDir() + "ifxb_" + (String)object + ((String)object2).substring(4);
                ifxBlob.tempBlobFile = new IfxTmpFile((String)object2, this.conn);
                inputStream = new IfxInputStream((IfxTmpFile)object3);
                outputStream = new FileOutputStream((String)object2);
            }
            object3 = new BufferedReader(new InputStreamReader(inputStream, string));
            object2 = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            object = new char[4096];
            while ((n = ((Reader)object3).read((char[])object)) != -1) {
                ((Writer)object2).write((char[])object, 0, n);
            }
            ((Reader)object3).close();
            ((Writer)object2).flush();
            ((Writer)object2).close();
            if (ifxBlob.tb_size > this.conn.getCodesetLobSize()) {
                outputStream.close();
            } else {
                memoryUtil.byfill(ifxBlob.blobBuffer, (byte)0);
                System.arraycopy(((ByteArrayOutputStream)outputStream).toByteArray(), 0, ifxBlob.blobBuffer, 0, ((ByteArrayOutputStream)outputStream).size());
            }
            inputStream.close();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
        }
    }

    private void sendFetchBlob(IfxBlob ifxBlob) throws SQLException {
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            this.os.writeSmallInt((short)38);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        try {
            this.os.writePadded(ifxBlob.toIfx());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveText() throws SQLException {
        int n;
        short s;
        byte[] byArray = null;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        try {
            byArray = new byte[s];
            n = this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, n);
                this.BlobWriteOffset += n;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (n < s) {
            int n2 = 0;
            while (n < s) {
                try {
                    byArray = new byte[s - n];
                    n2 = this.is.readPadded(byArray);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(byArray, this.BlobWriteOffset, n2);
                        this.BlobWriteOffset += n2;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                n += n2;
            }
        }
    }

    private void receiveBlob() throws SQLException {
        int n;
        short s;
        byte[] byArray = null;
        try {
            s = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        try {
            byArray = new byte[s];
            n = this.is.readPadded(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, n);
                this.BlobWriteOffset += n;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
        }
        if (n < s) {
            int n2 = 0;
            while (n < s) {
                try {
                    byArray = new byte[s - n];
                    n2 = this.is.readPadded(byArray);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(byArray, this.BlobWriteOffset, n2);
                        this.BlobWriteOffset += n2;
                    }
                    catch (Exception exception) {
                        this.BlobWriteFailure = 1;
                    }
                }
                n += n2;
            }
        }
    }

    private int blobDataWrite(byte[] byArray, int n, int n2) {
        if (this.BufferOrStream == 1) {
            try {
                this.BlobFd.write(byArray, 0, n2);
            }
            catch (Exception exception) {
                return 1;
            }
        } else if (n2 > 0) {
            System.arraycopy(byArray, 0, this.BlobBuffer, n, n2);
        }
        return 0;
    }

    public void executeScrollFetch(int n, int n2, Statement statement) throws SQLException {
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            IfxResultSetMetaData ifxResultSetMetaData = null;
            if (statement != null && statement instanceof IfxPreparedStatement) {
                IfxPreparedStatement ifxPreparedStatement = (IfxPreparedStatement)statement;
                ifxResultSetMetaData = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
            }
            if (ifxResultSetMetaData != null) {
                this.sendScrollFetch(n, n2, ifxResultSetMetaData);
            } else {
                this.sendScrollFetch(n, n2, this.desc);
            }
            ((IfxStatement)statement).cursorOpen = true;
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendScrollFetch(int n, int n2, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        int n3 = this.getTupleBufferSize();
        try {
            this.os.writeSmallInt((short)4);
            this.os.writeSmallInt(this.statementID);
            if (ifxResultSetMetaData.hasVariableLengthColumns) {
                this.sendType(ifxResultSetMetaData, (short)1);
            }
            this.os.writeSmallInt((short)23);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            if (this.conn.isXPSVER8_40()) {
                this.os.writeInt(n3);
            } else {
                this.os.writeSmallInt((short)n3);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, ifxResultSetMetaData, n3);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public int getTupid() throws SQLException {
        return this.Tupid;
    }

    public InputStream toClobStream(IfxSmBlob ifxSmBlob) throws SQLException {
        InputStream inputStream = null;
        String string = this.conn.getdbEncoding();
        String string2 = this.conn.getclEncoding();
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        IfxTmpFile ifxTmpFile = null;
        try {
            int n;
            Object object;
            Object object2;
            IfxLobInputStream ifxLobInputStream = (IfxLobInputStream)ifxSmBlob.toAsciiStream();
            int n2 = (int)ifxLobInputStream.lobSize;
            int n3 = this.conn.getCodesetLobSize();
            byte[] byArray = null;
            if (n2 <= n3) {
                try {
                    byArray = memoryUtil.allocateMemory((int)ifxLobInputStream.lobSize, this.conn);
                    ifxLobInputStream.read(byArray);
                    inputStream2 = new ByteArrayInputStream(byArray);
                    outputStream = new ByteArrayOutputStream();
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79753, exception.toString(), (IfxConnection)this.conn);
                }
            }
            try {
                inputStream2 = ifxLobInputStream.getStream();
                object2 = String.valueOf(System.currentTimeMillis());
                object = Thread.currentThread().getName();
                object2 = this.conn.getJDBCTempDir() + "ifxb_" + (String)object + ((String)object2).substring(4);
                ifxTmpFile = new IfxTmpFile((String)object2, this.conn);
                outputStream = new FileOutputStream((String)object2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
            }
            object2 = new BufferedReader(new InputStreamReader(inputStream2, string));
            object = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
            char[] cArray = new char[4096];
            while ((n = ((Reader)object2).read(cArray)) != -1) {
                ((Writer)object).write(cArray, 0, n);
            }
            ((Reader)object2).close();
            ((Writer)object).flush();
            ((Writer)object).close();
            inputStream2.close();
            if (n2 <= n3) {
                inputStream = new IfxByteArrayInputStream((ByteArrayOutputStream)outputStream);
            } else {
                outputStream.close();
                inputStream = new IfxInputStream(ifxTmpFile);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
        }
        return inputStream;
    }

    public Vector executeFastPath(String string, Vector vector, boolean bl) throws SQLException {
        this.executeFastPath(string, vector, false, bl);
        return this.fpRet;
    }

    public void executeFastPath(String string, Vector vector, boolean bl, boolean bl2) throws SQLException {
        if (this.fpRet != null) {
            this.fpRet.removeAllElements();
            this.fpRet = null;
        }
        if (this.fpInput != null) {
            this.fpInput.removeAllElements();
            this.fpInput = null;
        }
        if (string == null || !this.conn.isUSVER()) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException sQLException) {
                this.conn.unlockSession();
                throw sQLException;
            }
        }
        short s = this.xcNewLevel;
        try {
            this.getHandle(string, bl2, bl);
            this.sendFastPath(this.fpHandle, vector, bl2);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (this.conn.SendCommit && s < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    public Vector getFPReturnVector() {
        return this.fpRet;
    }

    private void getHandle(String string, boolean bl, boolean bl2) throws SQLException {
        this.fpHandle = this.conn.getFPCacheRoutineId(string);
        if (this.fpHandle != -1) {
            this.fparam = bl ? this.conn.getFPCacheFParam(string) : null;
        } else {
            try {
                this.partialFParam = false;
                if (bl) {
                    this.fparam = new IfxFParam();
                    this.fparam.hasOutParameter = bl2;
                }
                this.os.writeSmallInt((short)101);
                this.os.writeChar(string);
                if (bl) {
                    this.os.writeSmallInt((short)1);
                } else {
                    this.os.writeSmallInt((short)0);
                }
                this.receiveMessage();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
            this.conn.setFPCacheInfo(this.fpHandle, string, this.fparam);
        }
    }

    private void sendFastPath(int n, Vector vector, boolean bl) throws SQLException {
        int n2;
        if (vector != null) {
            n2 = vector.size();
            this.fpInput = vector;
        } else {
            n2 = 0;
        }
        try {
            this.os.writeSmallInt((short)102);
            this.os.writeInt(n);
            this.os.writeSmallInt((short)n2);
            if (bl) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        if (n2 != 0) {
            this.sendBind(vector, n2, 0, n2);
        }
        if (bl) {
            this.sendFParam();
        }
    }

    private void receiveFastPath() throws SQLException {
        Object var7_1 = null;
        this.fpRet = new Vector();
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        try {
            short s = this.is.readSmallInt();
            if (this.fparam != null && this.fparam.colInfoArray.length < s) {
                throw IfxErrMsg.getSQLException(-79716, "receiveFastPath colInfoArray too small", (IfxConnection)this.conn);
            }
            short s2 = 0;
            while (s2 < s) {
                int n;
                if (this.fparam != null) {
                    this.fparam.colInfoArray[s2] = ifxColumnInfo;
                }
                if (((n = this.is.readSmallInt()) & 0x800) > 0) {
                    ifxColumnInfo.IsDistinct = true;
                }
                ifxColumnInfo.SQLtype = n &= 0xFF;
                if (n >= 18 || ifxColumnInfo.IsDistinct) {
                    ifxColumnInfo.ExtendedOwner = new String(this.is.readChar());
                    ifxColumnInfo.ExtendedName = new String(this.is.readChar());
                }
                n = this.cleanUpFPTypeInfo(s2, n, ifxColumnInfo);
                ifxColumnInfo.Nullable = true;
                short s3 = this.is.readSmallInt();
                IfxObject ifxObject = IfxValue.makeInstance(this.conn, ifxColumnInfo);
                ifxObject.setConnection(this.conn);
                short s4 = this.is.readSmallInt();
                if (s4 != 0 && ifxColumnInfo.ColLength == 0) {
                    ifxColumnInfo.ColLength = s4;
                }
                if (s3 == -1) {
                    ifxObject.nullify();
                    this.fpRet.addElement(ifxObject);
                } else {
                    switch (n) {
                        case 0: 
                        case 13: 
                        case 15: 
                        case 16: {
                            ifxObject.fromString(this.is.readChar(this.dbEncoding));
                            break;
                        }
                        case 2: 
                        case 6: {
                            ifxObject.fromInt(this.is.readInt());
                            break;
                        }
                        case 7: {
                            ifxObject.fromDate(this.is.readDate());
                            break;
                        }
                        case 1: {
                            ifxObject.fromShort(this.is.readSmallInt());
                            break;
                        }
                        case 17: 
                        case 18: {
                            ifxObject.fromLong(this.is.readLongInt());
                            break;
                        }
                        case 4: {
                            ifxObject.fromFloat(this.is.readReal(s4));
                            break;
                        }
                        case 3: {
                            ifxObject.fromDouble(this.is.readDouble(s4));
                            break;
                        }
                        case 5: 
                        case 8: {
                            ifxObject.fromDecimal(this.is.readDecimal(s4));
                            break;
                        }
                        case 14: {
                            ifxObject.fromTimestamp(this.is.readDateTime(s4));
                            break;
                        }
                        case 10: {
                            ifxObject.fromTimestamp(this.is.readDateTime(s4));
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 44: {
                            int n2 = this.is.readInt();
                            if (n2 <= 0) break;
                            int n3 = 5;
                            byte[] byArray3 = new byte[n2 + n3];
                            byArray3[0] = 0;
                            byte[] byArray2 = JavaToIfxType.JavaToIfxInt(n2);
                            System.arraycopy(byArray2, 0, byArray3, 1, 4);
                            this.is.readPadded(byArray3, n3, n2);
                            if (ifxColumnInfo.ExtendedId == 11 || ifxColumnInfo.ExtendedId == 10) {
                                ((IfxSmBlob)ifxObject).fromIfxFP(byArray3);
                                break;
                            }
                            ifxObject.fromIfx(byArray3);
                            break;
                        }
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            int n2 = this.is.readShort();
                            n2 = this.is.readInt();
                            if (n2 <= 0) break;
                            byte[] byArray = new byte[n2 + 4];
                            byte[] byArray3 = JavaToIfxType.JavaToIfxInt(n2);
                            System.arraycopy(byArray3, 0, byArray, 0, 4);
                            this.is.readPadded(byArray, 4, n2);
                            ifxObject.fromIfx(byArray);
                            break;
                        }
                    }
                    this.fpRet.addElement(ifxObject);
                }
                s2 = (short)(s2 + 1);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private int cleanUpFPTypeInfo(int n, int n2, IfxColumnInfo ifxColumnInfo) {
        if (n2 == 45) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 5;
        } else if (n2 == 43) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 1;
        } else if (n2 == 102) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 10;
        } else if (n2 == 101) {
            n2 = 44;
            ifxColumnInfo.SQLtype = 44;
            ifxColumnInfo.ExtendedId = 11;
        } else if (this.fparam != null) {
            ifxColumnInfo.ExtendedId = n == 0 && this.fparam.hasOutParameter ? this.fparam.argType[this.fparam.nargs - 1].xid : this.fparam.retType[0].xid;
        }
        if (n == 0) {
            IfxObject ifxObject = (IfxObject)this.fpInput.elementAt(this.fpInput.size() - 1);
            String string = ifxObject.getExtendedTypeName();
            if (string != null && string.trim().length() != 0) {
                ifxColumnInfo.ExtendedName = string;
            }
            if (n2 == 40 || n2 == 41) {
                if (ifxObject instanceof IfxRow) {
                    n2 = 22;
                    ifxColumnInfo.SQLtype = 22;
                } else if (ifxObject instanceof IfxCollection) {
                    n2 = 20;
                    ifxColumnInfo.SQLtype = 20;
                }
            }
        }
        return n2;
    }

    private void receiveHandle() throws IOException {
        this.fpHandle = this.is.readInt();
    }

    private void receiveFParam() throws SQLException {
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.receiveFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            this.fparam.funcState = this.is.readLong();
            this.fparam.request = this.is.readInt();
            byte by = this.is.readByte();
            this.fparam.isDone = by != 0;
            if (this.partialFParam) {
                return;
            }
            this.fparam.id = this.is.readInt();
            this.fparam.row = this.is.readLong();
            this.fparam.colid = this.is.readInt();
            this.fparam.nrets = this.is.readShort();
            int n = 0;
            if (this.fparam.nrets > 0) {
                this.fparam.retNull = new boolean[this.fparam.nrets];
                this.fparam.retType = new IfxFParam.FPTypeInfo[this.fparam.nrets];
                this.readFPTypeInfo(this.fparam.nrets, this.fparam.retNull, this.fparam.retType, "Return");
                n = this.fparam.nrets;
            }
            if (this.fparam.hasOutParameter) {
                ++n;
            }
            this.fparam.colInfoArray = new IfxColumnInfo[n];
            this.fparam.nargs = this.is.readShort();
            if (this.fparam.nargs > 0) {
                this.fparam.argNull = new boolean[this.fparam.nargs];
                this.fparam.argType = new IfxFParam.FPTypeInfo[this.fparam.nargs];
                this.readFPTypeInfo(this.fparam.nargs, this.fparam.argNull, this.fparam.argType, "Parameter");
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        this.partialFParam = true;
    }

    private void readFPTypeInfo(int n, boolean[] blArray, IfxFParam.FPTypeInfo[] fPTypeInfoArray, String string) throws SQLException {
        try {
            int n2 = 0;
            while (n2 < n) {
                fPTypeInfoArray[n2] = new IfxFParam.FPTypeInfo();
                byte by = this.is.readByte();
                blArray[n2] = by != 0;
                fPTypeInfoArray[n2].type = this.is.readShort();
                fPTypeInfoArray[n2].xid = this.is.readInt();
                if (this.conn.is902()) {
                    fPTypeInfoArray[n2].len = this.is.readInt();
                    fPTypeInfoArray[n2].precision = this.is.readShort();
                    fPTypeInfoArray[n2].scale = this.is.readShort();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendFParam() throws SQLException {
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.sendFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            this.os.writeSmallInt((short)104);
            this.os.writeLong(this.fparam.funcState);
            this.os.writeInt(this.fparam.request);
            if (this.fparam.isDone) {
                this.os.writeByte(0);
            } else {
                this.os.writeByte(1);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    public IfxFParam getFParam() {
        return this.fparam;
    }

    public int executeReadSmBlob(int n, byte[] byArray, int n2) throws SQLException {
        this.BlobBuffer = byArray;
        this.BlobRequestSize = n2;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)0, n, n2, 0);
    }

    public int executeReadSmBlob(int n, byte[] byArray, int n2, int n3) throws SQLException {
        this.BlobBuffer = byArray;
        this.BlobRequestSize = n2;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)1, n, n2, n3);
    }

    public int executeReadSmBlob(int n, FileOutputStream fileOutputStream, int n2) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = n2;
        this.BlobFd = fileOutputStream;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData((short)0, n, n2, 0);
    }

    private int doLoData(short s, int n, int n2, int n3) throws SQLException {
        this.sendLoData(s, n, n2, n3);
        try {
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        return this.amountRW;
    }

    public int executeWriteSmBlob(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        this.amountRW = 0;
        this.sendLoData((short)2, n, n2, 0);
        while (n2 > 0) {
            try {
                n4 = n2 < 32000 ? n2 : 32000;
                this.os.writeSmallInt((short)n4);
                this.os.writePadded(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
        }
        this.receiveMessage();
        return this.amountRW;
    }

    public int executeWriteSmBlob(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2 = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        int n3 = n2;
        boolean bl = false;
        int n4 = 0;
        this.amountRW = 0;
        int n5 = 0;
        byte[] byArray = new byte[32000];
        boolean bl2 = false;
        this.sendLoData((short)2, n, n3, 0);
        while (n3 > 0) {
            try {
                n4 = n3 < 32000 ? n3 : 32000;
                n5 = inputStream2.read(byArray, 0, n4);
                if (n5 <= 0) {
                    bl2 = true;
                    n5 = n4;
                }
                this.os.writeSmallInt((short)n5);
                this.os.writePadded(byArray, 0, n5);
                n3 -= n5;
            }
            catch (Exception exception) {
                bl2 = true;
            }
        }
        this.receiveMessage();
        if (bl2) {
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
        return this.amountRW;
    }

    private void sendLoData(short s, int n, int n2, int n3) throws SQLException {
        try {
            this.os.writeSmallInt((short)97);
            this.os.writeSmallInt(s);
            this.os.writeSmallInt((short)n);
            this.os.writeInt(n2);
            this.os.writeSmallInt((short)32000);
            if (s == 1) {
                this.os.writeLongInt(n3);
                this.os.writeSmallInt((short)1);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short s = 0;
        int n = 0;
        try {
            s = this.is.readSmallInt();
            n = this.is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s == 2) {
            this.amountRW = n;
            return;
        }
        if (n < 1) {
            try {
                short s2 = this.is.readSmallInt();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] byArray = null;
        if (this.BlobRequestSize > n) {
            this.BlobRequestSize = n;
        }
        short s3 = 0;
        while (this.BlobRequestSize > 0) {
            try {
                s3 = this.is.readSmallInt();
                if (s3 < 0) {
                    this.amountRW = -1;
                    return;
                }
                byArray = new byte[s3];
                int n2 = this.is.readPadded(byArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(byArray, this.BlobWriteOffset, s3);
                this.BlobWriteOffset += s3;
            }
            catch (Exception exception) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += s3;
            this.BlobRequestSize -= s3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveSQFILE() throws SQLException {
        int n = -1;
        byte[] byArray = null;
        int n2 = -1;
        long l = 0L;
        int n3 = -1;
        int n4 = 0;
        try {
            n = this.is.readSmallInt();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
        switch (n) {
            case 0: {
                try {
                    short s = this.is.readSmallInt();
                    byte[] byArray2 = new byte[s];
                    this.is.readPadded(byArray2);
                    this.copyToFileName = new String(byArray2);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException nullPointerException) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0) {
                        if (!this.copyToFileFd.exists()) {
                            this.copyToFileFd = null;
                            this.sendSQFILEError(2);
                            break;
                        }
                        this.copyToFileFd.setReadOnly();
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException securityException) {
                    throw IfxErrMsg.getSQLException(-79716, securityException.toString(), (IfxConnection)this.conn);
                }
            }
            case 2: {
                long l2;
                n3 = 0;
                long l3 = 0L;
                boolean bl = false;
                try {
                    n2 = this.is.readSmallInt();
                    l = this.is.readInt();
                    n3 = this.is.readSmallInt();
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    l2 = this.loFile.length();
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > l2) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    byArray = new byte[n2];
                }
                catch (Exception exception) {
                    this.sendSQFILEError(-406);
                    break;
                }
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                l = l == -1L ? l2 - (long)this.copyToFileOffset : (l2 - (long)this.copyToFileOffset < l ? l2 - (long)this.copyToFileOffset : l);
                try {
                    this.os.writeInt((int)l);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(29);
                    break;
                }
                int n5 = 0;
                try {
                    while (l > 0L) {
                        l3 = (long)n2 < l ? (long)n2 : l;
                        try {
                            n5 = this.loFile.read(byArray, 0, (int)l3);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)n5);
                        this.os.writePadded(byArray, 0, n5);
                        l -= (long)n5;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
                }
                if (l <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                n4 = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                }
                catch (Exception exception) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 2) != 0) {
                        this.loFile.seek(this.copyToFileOffset);
                    }
                }
                catch (IOException iOException) {
                    this.sendSQFILEError(5);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        n3 = s;
                        if (s == 107) {
                            n2 = this.is.readSmallInt();
                            byte[] byArray3 = new byte[n2];
                            this.is.readPadded(byArray3);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(byArray3));
                                continue;
                            }
                            this.loFile.write(byArray3, 0, n2);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    n4 = 2;
                    break;
                }
                try {
                    if (n3 == 13) {
                        n4 = this.is.readSmallInt();
                    }
                    if (n4 != 0) {
                        this.sendSQFILEError(n4);
                        break;
                    }
                    long l4 = this.loFile.length();
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)l4);
                    break;
                }
                catch (IOException iOException) {
                    throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
                }
            }
            case 1: {
                try {
                    n3 = this.is.readSmallInt();
                }
                catch (IOException iOException) {
                    n3 = 0;
                }
                if (n3 != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                try {
                    if (this.copyToFileFd == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        this.flip();
    }

    private void sendSQFILEError(int n) throws SQLException {
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)n);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79716, iOException.toString(), (IfxConnection)this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement ifxPreparedStatement) throws SQLException {
        IfxResultSetMetaData ifxResultSetMetaData = (IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData();
        try {
            if (!ifxPreparedStatement.cursorOpen) {
                this.sendQuery(ifxPreparedStatement, false, null);
            } else {
                this.os.writeSmallInt((short)4);
                this.os.writeSmallInt(this.statementID);
            }
            if (!ifxResultSetMetaData.hasVariableLengthColumns && ifxResultSetMetaData.textByteColumnCount <= 0) {
                this.os.writeSmallInt((short)17);
                if (!this.conn.isUSVER()) {
                    this.os.writeSmallInt(this.desc.getTupleSize());
                } else {
                    this.os.writeInt(this.getTupleSize());
                }
                if (this.conn.isXPSVER8_40()) {
                    this.os.writeInt(ifxPreparedStatement.getBatchCount());
                } else {
                    this.os.writeSmallInt(ifxPreparedStatement.getBatchCount());
                }
                byte[] byArray = ifxPreparedStatement.getAllRows();
                this.os.write(byArray);
            } else {
                if (ifxResultSetMetaData.textByteColumnCount > 0) {
                    // empty if block
                }
                if (ifxResultSetMetaData.hasVariableLengthColumns && !this.typeSent) {
                    this.sendType((IfxResultSetMetaData)ifxPreparedStatement.getOutPutMetaData(), (short)0);
                    this.typeSent = true;
                }
                int n = 0;
                while (n < ifxPreparedStatement.getBatchCount()) {
                    this.os.writeSmallInt((short)17);
                    byte[] byArray = ifxPreparedStatement.getNextRow();
                    if (!this.conn.isUSVER()) {
                        this.os.writeSmallInt((short)byArray.length);
                    } else {
                        this.os.writeInt(byArray.length);
                    }
                    if (this.conn.isXPSVER8_40()) {
                        this.os.writeInt(1);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    this.os.writePadded(byArray);
                    int n2 = n * ifxResultSetMetaData.textByteColumnCount;
                    while (n2 < n * ifxResultSetMetaData.textByteColumnCount + ifxResultSetMetaData.textByteColumnCount) {
                        IfxBlob ifxBlob = ifxPreparedStatement.getIfxBlobAt(n2);
                        if (ifxBlob != null) {
                            if (ifxBlob.isBlobByteType()) {
                                this.sendBytesBlob(this.os, ifxBlob.getBlobBuffer());
                            } else {
                                this.sendStreamBlob(this.os, ifxBlob.getBlobInputStream(), ifxBlob.getBlobLength());
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this.conn);
        }
    }

    String parseDbName(Statement statement) {
        String string = null;
        String string2 = null;
        try {
            String string3 = ((IfxStatement)statement).commandString;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("CLOSE")) {
                if (string.equalsIgnoreCase("DATABASE")) {
                    string2 = null;
                }
            } else if (string.equalsIgnoreCase("DATABASE")) {
                string2 = stringTokenizer.nextToken();
            } else if (string.equalsIgnoreCase("CREATE") && (string = stringTokenizer.nextToken()).equalsIgnoreCase("DATABASE")) {
                string2 = stringTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 != null && string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public int incRefCount(byte[] byArray) throws SQLException {
        return 0;
    }

    public int decRefCount(byte[] byArray) throws SQLException {
        return 0;
    }

    int getStatementID() {
        return this.statementID;
    }

    void initiateTransaction() throws SQLException {
        if (!this.conn.inXATransaction() && this.conn.db_use_log && !this.conn.AnsiDb && this.TxStmt != 1) {
            if (this.conn.TxState == 1) {
                this.sendBegin();
                this.receiveMessage();
                this.conn.setTxBeginState();
            }
        }
        if (this.conn.AnsiDb && !this.conn.autoCommit) {
            this.conn.TxState = (short)2;
        }
    }

    private class FPCacheInfo {
        int routineId = -1;
        IfxFParam fparam = null;

        private FPCacheInfo() {
        }
    }
}

