/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLInput;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.SQLUDTInput;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxUDTInput
extends IfxSQLInput
implements SQLUDTInput,
IfmxUDTSQLInput {
    private static final int NO_ALIGNMENT = -1;
    private boolean autoAlignmentEnabled = true;

    IfxUDTInput(IfxConnection ifxConnection, byte[] byArray, int n, int n2) throws SQLException {
        super(ifxConnection, byArray, n, n2);
    }

    public int length() {
        return super.length();
    }

    private void checkAlignment(int n, int n2) throws SQLException {
        int n3;
        if (this.autoAlignmentEnabled && n2 != -1 && (n3 = (this.currentPos + n + (n2 - 1) & ~(n2 - 1)) - (this.currentPos + n)) > 0) {
            super.checkLength(n3);
            super.skipBytes(n3);
            this.currentPos += n3;
        }
    }

    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readString().", this.conn);
    }

    public byte readByte() throws SQLException {
        this.checkAlignment(1, -1);
        this.checkLength(1);
        ++this.currentPos;
        try {
            return this.is.readByte();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public short readShort() throws SQLException {
        this.checkAlignment(2, 2);
        return super.readShort();
    }

    public int readInt() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readInt();
    }

    public String readString(int n) throws SQLException {
        byte[] byArray;
        if (this.unreadLength < n) {
            n = this.unreadLength;
        }
        this.checkAlignment(n, -1);
        this.checkLength(n);
        try {
            byArray = new byte[n];
            this.is.readFully(byArray, 0, n);
            this.currentPos += n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        String string = IfxToJavaType.IfxToJavaChar(byArray);
        if (string == null) {
            this.isNull = true;
            return null;
        }
        return string;
    }

    public boolean readBoolean() throws SQLException {
        byte by = 0;
        this.checkAlignment(1, -1);
        this.checkLength(1);
        try {
            by = this.is.readByte();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        ++this.currentPos;
        if (by == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        if (by == 255) {
            this.isNull = true;
        }
        return false;
    }

    public long readLong() throws SQLException {
        this.checkAlignment(4, 4);
        try {
            byte[] byArray = new byte[8];
            long l = 0L;
            int n = 4;
            while (n < 8) {
                byArray[n] = (byte)(0xFF & (short)this.readByte());
                ++n;
            }
            int n2 = 0;
            while (n2 < 4) {
                byArray[n2] = (byte)(0xFF & (short)this.readByte());
                ++n2;
            }
            short s = this.readShort();
            if (s == 0) {
                this.isNull = true;
            } else {
                BigInteger bigInteger = new BigInteger(byArray);
                l = bigInteger.longValue();
                if (s == -1) {
                    l *= -1L;
                }
            }
            if (this.autoAlignmentEnabled) {
                this.readByte();
                this.readByte();
            }
            return l;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public float readFloat() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readFloat();
    }

    public double readDouble() throws SQLException {
        this.checkAlignment(8, 8);
        return super.readDouble();
    }

    private Decimal readIfxDecimal() throws SQLException {
        this.checkAlignment(2, 2);
        return Decimal.dec_tToJava(this.readBytes(22));
    }

    public BigDecimal readBigDecimal() throws SQLException {
        try {
            Decimal decimal = this.readIfxDecimal();
            if (decimal.isNull()) {
                this.isNull = true;
                return null;
            }
            return decimal.numericValue();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int n) throws SQLException {
        this.checkAlignment(n, -1);
        return super.readBytes(n);
    }

    public Date readDate() throws SQLException {
        this.checkAlignment(4, 4);
        return super.readDate();
    }

    public Timestamp readTimestamp() throws SQLException {
        try {
            short s = this.readShort();
            Decimal decimal = this.readIfxDecimal();
            if (decimal.isNull()) {
                this.isNull = true;
                return null;
            }
            decimal.setTimestampQualifier(s);
            return decimal.timestampValue();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readCharacterStream().", this.conn);
    }

    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readAsciiStream().", this.conn);
    }

    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readBinaryStream().", this.conn);
    }

    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readObject().", this.conn);
    }

    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readRef().", this.conn);
    }

    private IfxLocator readIfxLocator() throws SQLException {
        byte[] byArray = this.readBytes(72);
        return new IfxLocator(byArray, this.conn);
    }

    public Blob readBlob() throws SQLException {
        IfxLocator ifxLocator = this.readIfxLocator();
        IfxSmBlob ifxSmBlob = new IfxSmBlob(this.conn, ifxLocator);
        return ifxSmBlob.toBlob();
    }

    public Clob readClob() throws SQLException {
        IfxLocator ifxLocator = this.readIfxLocator();
        IfxSmBlob ifxSmBlob = new IfxSmBlob(this.conn, ifxLocator);
        return ifxSmBlob.toClob();
    }

    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTInput.readArray().", this.conn);
    }

    public Interval readInterval() throws SQLException {
        try {
            short s = this.readShort();
            Decimal decimal = this.readIfxDecimal();
            if (decimal.isNull()) {
                this.isNull = true;
                return null;
            }
            decimal.setTimestampQualifier(s);
            return decimal.intervalValue();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.getMessage(), this.conn);
        }
    }

    public void setAutoAlignment(boolean bl) {
        this.autoAlignmentEnabled = bl;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignmentEnabled;
    }

    public void skipBytes(int n) throws SQLException {
        super.checkLength(n);
        super.skipBytes(n);
        this.currentPos += n;
    }

    public int getCurrentPosition() {
        return super.currentPosition();
    }

    public void setCurrentPosition(int n) throws SQLException {
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        int n2 = this.getCurrentPosition();
        if (n > n2) {
            this.skipBytes(n - n2);
        } else if (n < n2) {
            this.reset();
            this.currentPos = 0;
            this.unreadLength = this.totalLength;
            this.skipBytes(n);
        }
    }

    public int available() {
        return super.available();
    }

    public IfxUDTInfo getUDTInfo(int n) throws SQLException {
        return this.conn.getUDTInfo(n);
    }

    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        return this.conn.getUDTInfo(string, string2);
    }

    public URL readURL() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexInput.readURL()", this.conn);
    }
}

