/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IntervalDF
extends Interval {
    protected long seconds;
    protected long nanos;
    String locale = null;
    protected static final int NanosPerSecond = 1000000000;
    protected static final int MilliPerSecond = 1000;
    protected static final int SecondsPerMinute = 60;
    protected static final int SecondsPerHour = 3600;
    protected static final int SecondsPerDay = 86400;

    public IntervalDF() throws SQLException {
        this.setQualifier((byte)4, (byte)15);
    }

    public IntervalDF(Connection connection) throws SQLException {
        this();
        this.setConnection(connection);
    }

    public IntervalDF(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(timestamp, timestamp2);
    }

    public IntervalDF(Timestamp timestamp, Timestamp timestamp2, Connection connection) throws SQLException {
        this(timestamp, timestamp2);
        this.setConnection(connection);
    }

    public IntervalDF(long l, long l2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(l, l2);
    }

    public IntervalDF(long l, long l2, Connection connection) throws SQLException {
        this(l, l2);
        this.setConnection(connection);
    }

    public IntervalDF(long l, long l2, short s) throws SQLException {
        this.setQualifier(s);
        this.set(l, l2);
    }

    public IntervalDF(long l, long l2, short s, Connection connection) throws SQLException {
        this(l, l2, s);
        this.setConnection(connection);
    }

    public IntervalDF(String string) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(string);
    }

    public IntervalDF(String string, Connection connection) throws SQLException {
        this(string);
        this.setConnection(connection);
    }

    public IntervalDF(String string, short s) throws SQLException {
        this.setQualifier(s);
        this.set(string);
    }

    public IntervalDF(String string, short s, Connection connection) throws SQLException {
        this(string, s);
        this.set(string);
        this.setConnection(connection);
    }

    public IntervalDF(String string, int n, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n, by, by2);
        this.set(string);
    }

    public IntervalDF(String string, int n, byte by, byte by2, Connection connection) throws SQLException {
        this(string, n, by, by2);
        this.setConnection(connection);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        long l = timestamp.getTime() / 1000L;
        long l2 = timestamp2.getTime() / 1000L;
        long l3 = l - l2;
        long l4 = timestamp.getNanos() - timestamp2.getNanos();
        this.set(l3, l4);
    }

    public void set(long l, long l2) {
        if (l < 0L) {
            if (l2 > 0L) {
                ++l;
                l2 -= 1000000000L;
            }
        } else if (l2 < 0L && l > 0L) {
            --l;
            l2 += 1000000000L;
        }
        this.seconds = l;
        this.nanos = l2;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            return;
        }
        this.fromString(string);
    }

    public String toString() {
        int n;
        int n2;
        long l = this.seconds;
        long l2 = this.nanos;
        StringBuffer stringBuffer = new StringBuffer();
        short s = this.getQualifier();
        int n3 = Interval.getEndCode(s);
        byte by = Interval.getStartCode(s);
        Interval.println("IntervalDF.toString() secs = " + l + " nans = " + l2 + " start = " + by + " end = " + n3);
        boolean bl = false;
        if (this.seconds < 0L || this.seconds == 0L && this.nanos < 0L) {
            bl = true;
            l = -this.seconds;
            l2 = -l2;
        }
        if (by == 4) {
            long l3 = l / 86400L;
            l %= 86400L;
            stringBuffer.append(l3);
            if (n3 > 4) {
                stringBuffer.append(Interval.dtdelim[2]);
            }
            Interval.println("After processing Days: " + stringBuffer);
        }
        if (by <= 6 && n3 >= 6) {
            long l4 = l / 3600L;
            l %= 3600L;
            if (l4 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l4);
            if (n3 > 6) {
                stringBuffer.append(Interval.dtdelim[3]);
            }
            Interval.println("After processing Hours: " + stringBuffer);
        }
        if (by <= 8 && n3 >= 8) {
            long l5 = l / 60L;
            l %= 60L;
            if (l5 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l5);
            if (n3 > 8) {
                stringBuffer.append(Interval.dtdelim[4]);
            }
            Interval.println("After processing Minutes: " + stringBuffer);
        }
        if (by <= 10 && n3 >= 10) {
            if (l < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l);
            Interval.println("After processing Seconds: " + stringBuffer);
        }
        if (n3 > 10) {
            stringBuffer.append(Interval.dtdelim[5]);
            if (l2 == 0L) {
                n2 = 11;
                while (n2 <= n3) {
                    stringBuffer.append('0');
                    ++n2;
                }
            } else {
                n2 = n3 - 10;
                n = 0;
                int n4 = 11;
                long l6 = 100000000L;
                while (n4 <= n3 && l2 != 0L) {
                    if (l2 < l6) {
                        stringBuffer.append('0');
                        ++n;
                    } else {
                        stringBuffer.append((long)((int)l2) / l6);
                        ++n;
                        l2 %= l6;
                    }
                    l6 /= 10L;
                    ++n4;
                }
                n4 = n;
                while (n4 < n2) {
                    stringBuffer.append('0');
                    ++n4;
                }
            }
            Interval.println("After processing Fractions: " + stringBuffer);
        }
        Interval.println("IntervalDF.toString no strip |" + stringBuffer.toString());
        n2 = 0;
        n = stringBuffer.length() - 1;
        while (n2 < n && stringBuffer.charAt(n2) == '0' && Character.isDigit(stringBuffer.charAt(n2 + 1))) {
            stringBuffer.setCharAt(n2, ' ');
            ++n2;
        }
        if (bl) {
            stringBuffer.insert(n2, '-');
        }
        Interval.println("IntervalDF.toString return |" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw IfxErrMsg.getLocSQLException(-79706, this.locale);
            }
            bl = true;
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s);
        this.seconds = (long)nArray[2] * 86400L;
        this.seconds += (long)nArray[3] * 3600L;
        this.seconds += (long)nArray[4] * 60L;
        this.seconds += (long)nArray[5];
        this.nanos = nArray[6];
        if (bl) {
            this.seconds = -this.seconds;
            this.nanos = -this.nanos;
        }
        Interval.println("IntervalDF.fromString() seconds = " + this.seconds + " nanos: " + this.nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoSeconds() {
        return this.nanos;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalDF && object != null) {
            bl = this.seconds == ((IntervalDF)object).getSeconds() && this.nanos == ((IntervalDF)object).getNanoSeconds();
        }
        return bl;
    }

    public boolean greaterThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l = intervalDF.getSeconds();
            bl = this.seconds > l ? true : this.seconds == l && this.nanos > intervalDF.getNanoSeconds();
        }
        return bl;
    }

    public boolean lessThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l = intervalDF.getSeconds();
            bl = this.seconds < l ? true : this.seconds == l && this.nanos < intervalDF.getNanoSeconds();
        }
        return bl;
    }

    private void setQualifier(byte by, byte by2) throws SQLException {
        this.setQualifier((byte)2, by, by2);
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        Interval.println("Interval.setQualifier(" + by + " , " + by2 + " , " + by3 + ")");
        if (by2 < 4 || by3 < 4 || by2 > by3) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s) throws SQLException {
        Interval.println("Interval.setQualifier(" + Integer.toString(s, 16) + ")");
        byte by = Interval.getStartCode(s);
        byte by2 = Interval.getEndCode(s);
        if (by < 4 || by2 < 4 || by > by2) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = s;
    }
}

