/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;

class ASTStaticField
extends SimpleNode {
    private String className;
    private String fieldName;

    void init(String string, String string2) {
        this.className = string;
        this.fieldName = string2;
    }

    protected Object getValueBody(Map map, Object object) throws OgnlException {
        return OgnlRuntime.getStaticField(map, this.className, this.fieldName);
    }

    public boolean isNodeConstant(Map map) throws OgnlException {
        boolean bl = false;
        Exception exception = null;
        try {
            Class clazz = OgnlRuntime.classForName(map, this.className);
            if (this.fieldName.equals("class")) {
                bl = true;
            } else {
                Field field = clazz.getField(this.fieldName);
                if (!Modifier.isStatic(field.getModifiers())) {
                    throw new OgnlException("Field " + this.fieldName + " of class " + this.className + " is not static");
                }
                bl = Modifier.isFinal(field.getModifiers());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exception = noSuchFieldException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        if (exception != null) {
            throw new OgnlException("Could not get static field " + this.fieldName + " from class " + this.className, exception);
        }
        return bl;
    }

    public ASTStaticField(int n) {
        super(n);
    }

    public ASTStaticField(OgnlParser ognlParser, int n) {
        super(ognlParser, n);
    }
}

