/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import ognl.ClassResolver;
import ognl.ExpressionSyntaxException;
import ognl.MemberAccess;
import ognl.Node;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.ParseException;
import ognl.SimpleNode;
import ognl.TokenMgrError;
import ognl.TypeConverter;

public abstract class Ognl {
    public static final String CONTEXT_CONTEXT_KEY = "context";
    public static final String ROOT_CONTEXT_KEY = "root";
    public static final String CLASS_RESOLVER_CONTEXT_KEY = "_classResolver";
    public static final String TYPE_CONVERTER_CONTEXT_KEY = "_typeConverter";
    public static final String MEMBER_ACCESS_CONTEXT_KEY = "_memberAccess";

    public static Object parseExpression(String string) throws OgnlException {
        try {
            OgnlParser ognlParser = new OgnlParser(new StringReader(string));
            return ognlParser.topLevelExpression();
        }
        catch (ParseException parseException) {
            throw new ExpressionSyntaxException(string, parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ExpressionSyntaxException(string, tokenMgrError);
        }
    }

    public static Map createDefaultContext(Object object) {
        return Ognl.addDefaultContext(object, null, null, new HashMap(11));
    }

    public static Map createDefaultContext(Object object, ClassResolver classResolver) {
        return Ognl.addDefaultContext(object, classResolver, null, new HashMap(11));
    }

    public static Map createDefaultContext(Object object, ClassResolver classResolver, TypeConverter typeConverter) {
        return Ognl.addDefaultContext(object, classResolver, typeConverter, new HashMap(11));
    }

    public static Map createDefaultContext(Object object, ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess) {
        return Ognl.addDefaultContext(object, classResolver, typeConverter, memberAccess, new HashMap(11));
    }

    public static Map addDefaultContext(Object object, Map map) {
        return Ognl.addDefaultContext(object, null, map);
    }

    public static Map addDefaultContext(Object object, ClassResolver classResolver, Map map) {
        return Ognl.addDefaultContext(object, classResolver, null, map);
    }

    public static Map addDefaultContext(Object object, ClassResolver classResolver, TypeConverter typeConverter, Map map) {
        return Ognl.addDefaultContext(object, classResolver, typeConverter, null, map);
    }

    public static Map addDefaultContext(Object object, ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess, Map map) {
        if (map != null) {
            map.put(CONTEXT_CONTEXT_KEY, map);
            if (classResolver == null) {
                if (Ognl.getClassResolver(map) == null) {
                    Ognl.setClassResolver(map, OgnlRuntime.DEFAULT_CLASS_RESOLVER);
                }
            } else {
                Ognl.setClassResolver(map, classResolver);
            }
            if (typeConverter == null) {
                if (Ognl.getTypeConverter(map) == null) {
                    Ognl.setTypeConverter(map, OgnlRuntime.DEFAULT_TYPE_CONVERTER);
                }
            } else {
                Ognl.setTypeConverter(map, typeConverter);
            }
            if (memberAccess == null) {
                if (Ognl.getMemberAccess(map) == null) {
                    Ognl.setMemberAccess(map, OgnlRuntime.DEFAULT_MEMBER_ACCESS);
                }
            } else {
                Ognl.setMemberAccess(map, memberAccess);
            }
            Ognl.setRoot(map, object);
        }
        return map;
    }

    public static void setClassResolver(Map map, ClassResolver classResolver) {
        if (classResolver != null) {
            map.put(CLASS_RESOLVER_CONTEXT_KEY, classResolver);
        } else {
            map.remove(CLASS_RESOLVER_CONTEXT_KEY);
        }
    }

    public static ClassResolver getClassResolver(Map map) {
        return (ClassResolver)map.get(CLASS_RESOLVER_CONTEXT_KEY);
    }

    public static void setTypeConverter(Map map, TypeConverter typeConverter) {
        if (typeConverter != null) {
            map.put(TYPE_CONVERTER_CONTEXT_KEY, typeConverter);
        } else {
            map.remove(TYPE_CONVERTER_CONTEXT_KEY);
        }
    }

    public static TypeConverter getTypeConverter(Map map) {
        return (TypeConverter)map.get(TYPE_CONVERTER_CONTEXT_KEY);
    }

    public static void setMemberAccess(Map map, MemberAccess memberAccess) {
        map.put(MEMBER_ACCESS_CONTEXT_KEY, memberAccess == null ? OgnlRuntime.DEFAULT_MEMBER_ACCESS : memberAccess);
    }

    public static MemberAccess getMemberAccess(Map map) {
        return (MemberAccess)map.get(MEMBER_ACCESS_CONTEXT_KEY);
    }

    public static void setRoot(Map map, Object object) {
        if (object != null) {
            map.put(ROOT_CONTEXT_KEY, object);
        } else {
            map.remove(ROOT_CONTEXT_KEY);
        }
    }

    public static Object getRoot(Map map) {
        return map.get(ROOT_CONTEXT_KEY);
    }

    public static Object getValue(Object object, Map map, Object object2) throws OgnlException {
        Node node = (Node)object;
        return node.getValue(Ognl.addDefaultContext(object2, map), object2);
    }

    public static Object getValue(String string, Map map, Object object) throws OgnlException {
        return Ognl.getValue(Ognl.parseExpression(string), map, object);
    }

    public static Object getValue(Object object, Object object2) throws OgnlException {
        return Ognl.getValue(object, Ognl.createDefaultContext(object2), object2);
    }

    public static Object getValue(String string, Object object) throws OgnlException {
        return Ognl.getValue(Ognl.parseExpression(string), object);
    }

    public static void setValue(Object object, Map map, Object object2, Object object3) throws OgnlException {
        Node node = (Node)object;
        node.setValue(Ognl.addDefaultContext(object2, map), object2, object3);
    }

    public static void setValue(String string, Map map, Object object, Object object2) throws OgnlException {
        Ognl.setValue(Ognl.parseExpression(string), map, object, object2);
    }

    public static void setValue(Object object, Object object2, Object object3) throws OgnlException {
        Ognl.setValue(object, Ognl.createDefaultContext(object2), object2, object3);
    }

    public static void setValue(String string, Object object, Object object2) throws OgnlException {
        Ognl.setValue(Ognl.parseExpression(string), object, object2);
    }

    public static boolean isConstant(Object object, Map map) throws OgnlException {
        return ((SimpleNode)object).isConstant(map);
    }

    public static boolean isConstant(String string, Map map) throws OgnlException {
        return Ognl.isConstant(Ognl.parseExpression(string), map);
    }

    public static boolean isConstant(Object object) throws OgnlException {
        return Ognl.isConstant(object, Ognl.createDefaultContext(null));
    }

    public static boolean isConstant(String string) throws OgnlException {
        return Ognl.isConstant(Ognl.parseExpression(string), Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleProperty(Object object, Map map) throws OgnlException {
        return ((SimpleNode)object).isSimpleProperty(map);
    }

    public static boolean isSimpleProperty(String string, Map map) throws OgnlException {
        return Ognl.isSimpleProperty(Ognl.parseExpression(string), map);
    }

    public static boolean isSimpleProperty(Object object) throws OgnlException {
        return Ognl.isSimpleProperty(object, Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleProperty(String string) throws OgnlException {
        return Ognl.isSimpleProperty(Ognl.parseExpression(string), Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleNavigationChain(Object object, Map map) throws OgnlException {
        return ((SimpleNode)object).isSimpleNavigationChain(map);
    }

    public static boolean isSimpleNavigationChain(String string, Map map) throws OgnlException {
        return Ognl.isSimpleNavigationChain(Ognl.parseExpression(string), map);
    }

    public static boolean isSimpleNavigationChain(Object object) throws OgnlException {
        return Ognl.isSimpleNavigationChain(object, Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleNavigationChain(String string) throws OgnlException {
        return Ognl.isSimpleNavigationChain(Ognl.parseExpression(string), Ognl.createDefaultContext(null));
    }

    private Ognl() {
    }
}

