/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import ognl.ElementsAccessor;
import ognl.NumericTypes;
import ognl.OgnlException;
import ognl.OgnlRuntime;

public abstract class OgnlOps
implements NumericTypes {
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$math$BigInteger;
    private static /* synthetic */ Class class$Ljava$math$BigDecimal;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;

    public static boolean booleanValue(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return (Boolean)object;
        }
        if (clazz == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OgnlOps.class$("java.lang.String")))) {
            return Boolean.valueOf((String)object);
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return ((Character)object).charValue() != '\u0000';
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        return true;
    }

    public static long longValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.getSuperclass() == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlOps.class$("java.lang.Number")))) {
            return ((Number)object).longValue();
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return ((Character)object).charValue();
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return (Boolean)object != false ? 1 : 0;
        }
        return Long.parseLong(object.toString());
    }

    public static double doubleValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.getSuperclass() == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlOps.class$("java.lang.Number")))) {
            return ((Number)object).doubleValue();
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return ((Character)object).charValue();
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return (Boolean)object != false ? 1 : 0;
        }
        return Double.parseDouble(object.toString());
    }

    public static BigInteger bigIntValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = OgnlOps.class$("java.math.BigInteger")))) {
            return (BigInteger)object;
        }
        if (clazz == (class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OgnlOps.class$("java.math.BigDecimal")))) {
            return ((BigDecimal)object).toBigInteger();
        }
        if (clazz.getSuperclass() == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlOps.class$("java.lang.Number")))) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return BigInteger.valueOf(((Character)object).charValue());
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return BigInteger.valueOf((Boolean)object != false ? 1 : 0);
        }
        return new BigInteger(object.toString());
    }

    public static BigDecimal bigDecValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == (class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OgnlOps.class$("java.math.BigDecimal")))) {
            return (BigDecimal)object;
        }
        if (clazz == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = OgnlOps.class$("java.math.BigInteger")))) {
            return new BigDecimal((BigInteger)object);
        }
        if (clazz.getSuperclass() == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlOps.class$("java.lang.Number")))) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return BigDecimal.valueOf(((Character)object).charValue());
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return BigDecimal.valueOf((Boolean)object != false ? 1 : 0);
        }
        return new BigDecimal(object.toString());
    }

    public static int getNumericType(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = OgnlOps.class$("java.lang.Integer")))) {
            return 4;
        }
        if (clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = OgnlOps.class$("java.lang.Double")))) {
            return 8;
        }
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean")))) {
            return 0;
        }
        if (clazz == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = OgnlOps.class$("java.lang.Byte")))) {
            return 1;
        }
        if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character")))) {
            return 2;
        }
        if (clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = OgnlOps.class$("java.lang.Short")))) {
            return 3;
        }
        if (clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = OgnlOps.class$("java.lang.Long")))) {
            return 5;
        }
        if (clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = OgnlOps.class$("java.lang.Float")))) {
            return 7;
        }
        if (clazz == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = OgnlOps.class$("java.math.BigInteger")))) {
            return 6;
        }
        if (clazz == (class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OgnlOps.class$("java.math.BigDecimal")))) {
            return 9;
        }
        return 10;
    }

    public static Object convertValue(Object object, Class clazz) {
        Object object2 = null;
        if (object != null) {
            if (clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = OgnlOps.class$("java.lang.Integer"))) || clazz == Integer.TYPE) {
                object2 = new Integer((int)OgnlOps.longValue(object));
            }
            if (clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = OgnlOps.class$("java.lang.Double"))) || clazz == Double.TYPE) {
                object2 = new Double(OgnlOps.doubleValue(object));
            }
            if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlOps.class$("java.lang.Boolean"))) || clazz == Boolean.TYPE) {
                object2 = OgnlOps.booleanValue(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (clazz == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = OgnlOps.class$("java.lang.Byte"))) || clazz == Byte.TYPE) {
                object2 = new Byte((byte)OgnlOps.longValue(object));
            }
            if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlOps.class$("java.lang.Character"))) || clazz == Character.TYPE) {
                object2 = new Character((char)OgnlOps.longValue(object));
            }
            if (clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = OgnlOps.class$("java.lang.Short"))) || clazz == Short.TYPE) {
                object2 = new Short((short)OgnlOps.longValue(object));
            }
            if (clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = OgnlOps.class$("java.lang.Long"))) || clazz == Long.TYPE) {
                object2 = new Long(OgnlOps.longValue(object));
            }
            if (clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = OgnlOps.class$("java.lang.Float"))) || clazz == Float.TYPE) {
                object2 = new Float(OgnlOps.doubleValue(object));
            }
            if (clazz == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = OgnlOps.class$("java.math.BigInteger")))) {
                object2 = OgnlOps.bigIntValue(object);
            }
            if (clazz == (class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OgnlOps.class$("java.math.BigDecimal")))) {
                object2 = OgnlOps.bigDecValue(object);
            }
            if (clazz == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OgnlOps.class$("java.lang.String")))) {
                object2 = object.toString();
            }
        }
        return object2;
    }

    public static int getNumericType(Object object, Object object2) {
        return OgnlOps.getNumericType(object, object2, false);
    }

    public static int getNumericType(Object object, Object object2, boolean bl) {
        int n;
        int n2 = OgnlOps.getNumericType(object);
        if (n2 == (n = OgnlOps.getNumericType(object2))) {
            return n2;
        }
        if (bl && (n2 == 10 || n == 10 || n2 == 2 || n == 2)) {
            return 10;
        }
        if (n2 == 10) {
            n2 = 8;
        }
        if (n == 10) {
            n = 8;
        }
        if (n2 >= 7) {
            if (n >= 7) {
                return Math.max(n2, n);
            }
            if (n < 4) {
                return n2;
            }
            if (n == 6) {
                return 9;
            }
            return Math.max(8, n2);
        }
        if (n >= 7) {
            if (n2 < 4) {
                return n;
            }
            if (n2 == 6) {
                return 9;
            }
            return Math.max(8, n);
        }
        return Math.max(n2, n);
    }

    public static Number newInteger(int n, long l) {
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                return new Integer((int)l);
            }
            case 7: {
                if ((long)((float)l) == l) {
                    return new Float(l);
                }
            }
            case 8: {
                if ((long)((double)l) == l) {
                    return new Double(l);
                }
            }
            case 5: {
                return new Long(l);
            }
            case 1: {
                return new Byte((byte)l);
            }
            case 3: {
                return new Short((short)l);
            }
        }
        return BigInteger.valueOf(l);
    }

    public static Number newReal(int n, double d) {
        if (n == 7) {
            return new Float((float)d);
        }
        return new Double(d);
    }

    public static Object binaryOr(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).or(OgnlOps.bigIntValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) | OgnlOps.longValue(object2));
    }

    public static Object binaryXor(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).xor(OgnlOps.bigIntValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) ^ OgnlOps.longValue(object2));
    }

    public static Object binaryAnd(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).and(OgnlOps.bigIntValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) & OgnlOps.longValue(object2));
    }

    public static boolean equal(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object == object2 || object.equals(object2)) {
            return true;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        return false;
    }

    public static boolean less(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2, true);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).compareTo(OgnlOps.bigIntValue(object2)) < 0;
            }
            case 9: {
                return OgnlOps.bigDecValue(object).compareTo(OgnlOps.bigDecValue(object2)) < 0;
            }
            case 10: {
                if (object instanceof Comparable) {
                    return ((Comparable)object).compareTo(object2) < 0;
                }
            }
            case 7: 
            case 8: {
                return OgnlOps.doubleValue(object) < OgnlOps.doubleValue(object2);
            }
        }
        return OgnlOps.longValue(object) < OgnlOps.longValue(object2);
    }

    public static boolean greater(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2, true);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).compareTo(OgnlOps.bigIntValue(object2)) > 0;
            }
            case 9: {
                return OgnlOps.bigDecValue(object).compareTo(OgnlOps.bigDecValue(object2)) > 0;
            }
            case 10: {
                if (object instanceof Comparable) {
                    return ((Comparable)object).compareTo(object2) < 0;
                }
            }
            case 7: 
            case 8: {
                return OgnlOps.doubleValue(object) > OgnlOps.doubleValue(object2);
            }
        }
        return OgnlOps.longValue(object) > OgnlOps.longValue(object2);
    }

    public static boolean in(Object object, Object object2) throws OgnlException {
        if (object2 == null) {
            return false;
        }
        ElementsAccessor elementsAccessor = OgnlRuntime.getElementsAccessor(object2.getClass());
        Enumeration enumeration = elementsAccessor.getElements(object2);
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!OgnlOps.equal(object, e)) continue;
            return true;
        }
        return false;
    }

    public static Object shiftLeft(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).shiftLeft((int)OgnlOps.longValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) << (int)OgnlOps.longValue(object2));
    }

    public static Object shiftRight(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).shiftRight((int)OgnlOps.longValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) >> (int)OgnlOps.longValue(object2));
    }

    public static Object unsignedShiftRight(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object);
        if (n == 6 || n == 9) {
            return OgnlOps.bigIntValue(object).shiftRight((int)OgnlOps.longValue(object2));
        }
        if (n <= 4) {
            return OgnlOps.newInteger(4, (int)OgnlOps.longValue(object) >>> (int)OgnlOps.longValue(object2));
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) >>> (int)OgnlOps.longValue(object2));
    }

    public static Object add(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2, true);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).add(OgnlOps.bigIntValue(object2));
            }
            case 9: {
                return OgnlOps.bigDecValue(object).add(OgnlOps.bigDecValue(object2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(n, OgnlOps.doubleValue(object) + OgnlOps.doubleValue(object2));
            }
            case 10: {
                return object.toString() + object2.toString();
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) + OgnlOps.longValue(object2));
    }

    public static Object subtract(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).subtract(OgnlOps.bigIntValue(object2));
            }
            case 9: {
                return OgnlOps.bigDecValue(object).subtract(OgnlOps.bigDecValue(object2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(n, OgnlOps.doubleValue(object) - OgnlOps.doubleValue(object2));
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) - OgnlOps.longValue(object2));
    }

    public static Object multiply(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).multiply(OgnlOps.bigIntValue(object2));
            }
            case 9: {
                return OgnlOps.bigDecValue(object).multiply(OgnlOps.bigDecValue(object2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(n, OgnlOps.doubleValue(object) * OgnlOps.doubleValue(object2));
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) * OgnlOps.longValue(object2));
    }

    public static Object divide(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).divide(OgnlOps.bigIntValue(object2));
            }
            case 9: {
                return OgnlOps.bigDecValue(object).divide(OgnlOps.bigDecValue(object2), 6);
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(n, OgnlOps.doubleValue(object) / OgnlOps.doubleValue(object2));
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) / OgnlOps.longValue(object2));
    }

    public static Object remainder(Object object, Object object2) {
        int n = OgnlOps.getNumericType(object, object2);
        switch (n) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(object).remainder(OgnlOps.bigIntValue(object2));
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) % OgnlOps.longValue(object2));
    }

    public static Object negate(Object object) {
        int n = OgnlOps.getNumericType(object);
        switch (n) {
            case 6: {
                return OgnlOps.bigIntValue(object).negate();
            }
            case 9: {
                return OgnlOps.bigDecValue(object).negate();
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(n, -OgnlOps.doubleValue(object));
            }
        }
        return OgnlOps.newInteger(n, -OgnlOps.longValue(object));
    }

    public static Object bitNegate(Object object) {
        int n = OgnlOps.getNumericType(object);
        switch (n) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(object).not();
            }
        }
        return OgnlOps.newInteger(n, OgnlOps.longValue(object) ^ -1L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

