/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassResolver;
import ognl.CollectionElementsAccessor;
import ognl.DefaultClassResolver;
import ognl.DefaultMemberAccess;
import ognl.DefaultTypeConverter;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.IteratorElementsAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MemberAccess;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.NumberElementsAccessor;
import ognl.ObjectElementsAccessor;
import ognl.ObjectPropertyAccessor;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import ognl.TypeConverter;

public abstract class OgnlRuntime {
    private static final Object NotFound = new Object();
    private static int javaMajorVersion;
    private static Map constructorCache;
    private static Map staticMethodCache;
    private static Map instanceMethodCache;
    private static Map fieldCache;
    private static Map propertyDescriptorCache;
    private static List superclasses;
    private static HashMap propertyAccessors;
    private static HashMap elementsAccessors;
    protected static ClassResolver DEFAULT_CLASS_RESOLVER;
    protected static TypeConverter DEFAULT_TYPE_CONVERTER;
    protected static MemberAccess DEFAULT_MEMBER_ACCESS;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class array$B;
    private static /* synthetic */ Class array$S;
    private static /* synthetic */ Class array$C;
    private static /* synthetic */ Class array$I;
    private static /* synthetic */ Class array$J;
    private static /* synthetic */ Class array$F;
    private static /* synthetic */ Class array$D;
    private static /* synthetic */ Class array$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$util$List;
    private static /* synthetic */ Class class$Ljava$util$Map;
    private static /* synthetic */ Class class$Ljava$util$Collection;
    private static /* synthetic */ Class class$Ljava$util$Iterator;
    private static /* synthetic */ Class class$Ljava$util$Enumeration;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Character;

    private static final Object invokeMethod(Object object, Method method, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        boolean bl = true;
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || (bl = method.isAccessible()))) {
            ((AccessibleObject)method).setAccessible(true);
        }
        Object object2 = method.invoke(object, objectArray);
        if (!bl) {
            ((AccessibleObject)method).setAccessible(false);
        }
        return object2;
    }

    public static int getJavaMajorVersion() {
        return javaMajorVersion;
    }

    public static Class getArgClass(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = OgnlRuntime.class$("java.lang.Boolean")))) {
            return Boolean.TYPE;
        }
        if (clazz.getSuperclass() == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlRuntime.class$("java.lang.Number")))) {
            if (clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = OgnlRuntime.class$("java.lang.Integer")))) {
                return Integer.TYPE;
            }
            if (clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = OgnlRuntime.class$("java.lang.Double")))) {
                return Double.TYPE;
            }
            if (clazz == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = OgnlRuntime.class$("java.lang.Byte")))) {
                return Byte.TYPE;
            }
            if (clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = OgnlRuntime.class$("java.lang.Long")))) {
                return Long.TYPE;
            }
            if (clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = OgnlRuntime.class$("java.lang.Float")))) {
                return Float.TYPE;
            }
            if (clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = OgnlRuntime.class$("java.lang.Short")))) {
                return Short.TYPE;
            }
        } else if (clazz == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = OgnlRuntime.class$("java.lang.Character")))) {
            return Character.TYPE;
        }
        return clazz;
    }

    public static boolean isTypeCompatible(Object object, Class clazz) {
        boolean bl = true;
        if (object == null) {
            if (clazz.isPrimitive()) {
                bl = false;
            }
        } else if (clazz.isPrimitive()) {
            if (OgnlRuntime.getArgClass(object) != clazz) {
                bl = false;
            }
        } else if (!clazz.isInstance(object)) {
            bl = false;
        }
        return bl;
    }

    public static boolean areArgsCompatible(Object[] objectArray, Class[] classArray) {
        boolean bl = true;
        if (objectArray.length != classArray.length) {
            bl = false;
        } else {
            int n = 0;
            int n2 = objectArray.length;
            while (bl && n < n2) {
                bl = OgnlRuntime.isTypeCompatible(objectArray[n], classArray[n]);
                ++n;
            }
        }
        return bl;
    }

    public static boolean isMoreSpecific(Class[] classArray, Class[] classArray2) {
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class clazz = classArray[n];
            Class clazz2 = classArray2[n];
            if (clazz != clazz2) {
                if (clazz.isPrimitive()) {
                    return true;
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    return false;
                }
                if (clazz2.isAssignableFrom(clazz)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static String getModifierString(int n) {
        String string = Modifier.isPublic(n) ? "public" : (Modifier.isProtected(n) ? "protected" : (Modifier.isPrivate(n) ? "private" : ""));
        if (Modifier.isStatic(n)) {
            string = "static " + string;
        }
        if (Modifier.isFinal(n)) {
            string = "final " + string;
        }
        if (Modifier.isNative(n)) {
            string = "native " + string;
        }
        if (Modifier.isSynchronized(n)) {
            string = "synchronized " + string;
        }
        if (Modifier.isTransient(n)) {
            string = "transient " + string;
        }
        return string;
    }

    public static Class getTargetClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    public static Class classForName(Map map, String string) throws ClassNotFoundException {
        ClassResolver classResolver;
        if (map == null || (classResolver = Ognl.getClassResolver(map)) == null) {
            classResolver = DEFAULT_CLASS_RESOLVER;
        }
        return classResolver.classForName(string, map);
    }

    public static boolean isInstance(Map map, Object object, String string) throws OgnlException {
        try {
            Class clazz = OgnlRuntime.classForName(map, string);
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new OgnlException("No such class: " + string, classNotFoundException);
        }
    }

    private static final Object getConvertedType(Map map, Object object, Member member, String string, Object object2, Class clazz) {
        Object object3 = null;
        TypeConverter typeConverter = Ognl.getTypeConverter(map);
        if (object2 != null) {
            object3 = typeConverter.convertValue(map, object, member, string, object2, clazz);
        }
        return object3;
    }

    private static final boolean getConvertedTypes(Map map, Object object, Member member, String string, Class[] classArray, List list, List list2) {
        boolean bl = false;
        list2.clear();
        if (classArray.length == list.size()) {
            bl = true;
            int n = 0;
            int n2 = classArray.length - 1;
            while (bl && n <= n2) {
                Class clazz;
                Object e = list.get(n);
                if (OgnlRuntime.isTypeCompatible(e, clazz = classArray[n])) {
                    list2.add(e);
                } else {
                    Object object2 = OgnlRuntime.getConvertedType(map, object, member, string, e, clazz);
                    if (object2 != null) {
                        list2.add(object2);
                    } else {
                        list2.clear();
                        bl = false;
                        break;
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    private static final Method getConvertedMethodAndArgs(Map map, Object object, String string, String string2, List list, List list2, List list3) {
        Method method = null;
        TypeConverter typeConverter = Ognl.getTypeConverter(map);
        if (typeConverter != null && list != null) {
            Iterator iterator = list.iterator();
            while (method == null && iterator.hasNext()) {
                Class[] classArray;
                Method method2 = (Method)iterator.next();
                if (!OgnlRuntime.getConvertedTypes(map, object, method2, string2, classArray = method2.getParameterTypes(), list2, list3)) continue;
                method = method2;
            }
        }
        return method;
    }

    private static final Constructor getConvertedConstructorAndArgs(Map map, Object object, List list, List list2, List list3) {
        Constructor constructor = null;
        TypeConverter typeConverter = Ognl.getTypeConverter(map);
        if (typeConverter != null && list != null) {
            Iterator iterator = list.iterator();
            while (constructor == null && iterator.hasNext()) {
                Class[] classArray;
                Constructor constructor2 = (Constructor)iterator.next();
                if (!OgnlRuntime.getConvertedTypes(map, object, constructor2, null, classArray = constructor2.getParameterTypes(), list2, list3)) continue;
                constructor = constructor2;
            }
        }
        return constructor;
    }

    private static final Object callAppropriateMethod(Map map, Object object, Object object2, String string, String string2, List list, List list2) throws MethodFailedException {
        Object[] objectArray = list2.toArray();
        Throwable throwable = null;
        try {
            Object object3;
            Object object4;
            Object object5 = null;
            if (list != null) {
                object4 = list.iterator();
                while (object4.hasNext()) {
                    object3 = (Method)object4.next();
                    if (!OgnlRuntime.areArgsCompatible(objectArray, ((Method)object3).getParameterTypes()) || object5 != null && !OgnlRuntime.isMoreSpecific(((Method)object3).getParameterTypes(), ((Method)object5).getParameterTypes())) continue;
                    object5 = object3;
                }
            }
            if (object5 == null && (object5 = OgnlRuntime.getConvertedMethodAndArgs(map, object2, string, string2, list, list2, (List)(object4 = new ArrayList()))) != null) {
                objectArray = object4.toArray();
            }
            if (object5 == null) {
                object4 = new StringBuffer();
                if (list2 != null) {
                    object3 = list2.iterator();
                    while (object3.hasNext()) {
                        Object e = object3.next();
                        ((StringBuffer)object4).append(e == null ? "null" : e.getClass().getName());
                        if (!object3.hasNext()) continue;
                        ((StringBuffer)object4).append(", ");
                    }
                }
                throw new NoSuchMethodException(string + "(" + object4 + ")");
            }
            return OgnlRuntime.invokeMethod(object2, object5, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        throw new MethodFailedException(object, string, throwable);
    }

    public static Object callStaticMethod(Map map, String string, String string2, List list) throws MethodFailedException {
        try {
            Class clazz = OgnlRuntime.classForName(map, string);
            List list2 = OgnlRuntime.getMethods(clazz, string2, true);
            return OgnlRuntime.callAppropriateMethod(map, string, null, string2, null, list2, list);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MethodFailedException(string, string2, classNotFoundException);
        }
    }

    public static Object callMethod(Map map, Object object, String string, String string2, List list) throws MethodFailedException {
        List list2 = OgnlRuntime.getMethods(object.getClass(), string, false);
        return OgnlRuntime.callAppropriateMethod(map, object, object, string, string2, list2, list);
    }

    public static Object callConstructor(Map map, String string, List list) throws OgnlException {
        Object[] objectArray = list.toArray();
        Throwable throwable = null;
        try {
            Constructor constructor = null;
            Class clazz = OgnlRuntime.classForName(map, string);
            List list2 = OgnlRuntime.getConstructors(clazz);
            Object object = list2.iterator();
            while (object.hasNext()) {
                Constructor constructor2 = (Constructor)object.next();
                if (!OgnlRuntime.areArgsCompatible(objectArray, constructor2.getParameterTypes()) || constructor != null && !OgnlRuntime.isMoreSpecific(constructor2.getParameterTypes(), constructor.getParameterTypes())) continue;
                constructor = constructor2;
            }
            if (constructor == null && (constructor = OgnlRuntime.getConvertedConstructorAndArgs(map, clazz, list2, list, (List)(object = new ArrayList()))) != null) {
                objectArray = object.toArray();
            }
            if (constructor == null) {
                throw new NoSuchMethodException();
            }
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        throw new MethodFailedException(string, "new", throwable);
    }

    public static Object getMethodValue(Map map, Object object, String string) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        Object object2 = null;
        Method method = OgnlRuntime.getGetMethod(map, OgnlRuntime.getTargetClass(object), string);
        if (method != null) {
            try {
                object2 = OgnlRuntime.invokeMethod(object, method, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new OgnlException(string, invocationTargetException.getTargetException());
            }
        } else {
            throw new NoSuchMethodException(string);
        }
        return object2;
    }

    public static void setMethodValue(Map map, Object object, String string, Object object2) throws OgnlException, IllegalAccessException, NoSuchMethodException, MethodFailedException, IntrospectionException {
        Method method = OgnlRuntime.getSetMethod(map, OgnlRuntime.getTargetClass(object), string);
        if (method != null) {
            OgnlRuntime.callMethod(map, object, method.getName(), string, Collections.nCopies(1, object2));
        }
    }

    public static List getConstructors(Class clazz) {
        List<Constructor<?>> list = (List<Constructor<?>>)constructorCache.get(clazz);
        if (list == null) {
            list = Arrays.asList(clazz.getConstructors());
            constructorCache.put(clazz, list);
        }
        return list;
    }

    public static List getMethods(Class clazz, String string, boolean bl) {
        Map map = bl ? staticMethodCache : instanceMethodCache;
        HashMap<String, ArrayList<Method>> hashMap = (HashMap<String, ArrayList<Method>>)map.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<String, ArrayList<Method>>();
            map.put(clazz, hashMap);
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                if (Modifier.isStatic(methodArray[n].getModifiers()) == bl) {
                    ArrayList<Method> arrayList = (ArrayList<Method>)hashMap.get(methodArray[n].getName());
                    if (arrayList == null) {
                        arrayList = new ArrayList<Method>();
                        hashMap.put(methodArray[n].getName(), arrayList);
                    }
                    arrayList.add(methodArray[n]);
                }
                ++n;
            }
        }
        return (List)hashMap.get(string);
    }

    public static Map getFields(Class clazz) {
        HashMap<String, Field> hashMap = (HashMap<String, Field>)fieldCache.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<String, Field>();
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                hashMap.put(fieldArray[n].getName(), fieldArray[n]);
                ++n;
            }
            fieldCache.put(clazz, hashMap);
        }
        return hashMap;
    }

    public static Field getField(Class clazz, String string) {
        Field field = null;
        Map map = fieldCache;
        synchronized (map) {
            Object v = OgnlRuntime.getFields(clazz).get(string);
            if (v == null) {
                superclasses.clear();
                Class clazz2 = clazz;
                while (clazz2 != null && field == null) {
                    v = OgnlRuntime.getFields(clazz2).get(string);
                    if (v == NotFound) break;
                    superclasses.add(clazz2);
                    field = (Field)v;
                    if (field != null) break;
                    clazz2 = clazz2.getSuperclass();
                }
                clazz2 = superclasses.iterator();
                while (clazz2.hasNext()) {
                    OgnlRuntime.getFields((Class)clazz2.next()).put(string, field == null ? NotFound : field);
                }
            } else if (v instanceof Field) {
                field = (Field)v;
            } else if (field == NotFound) {
                field = null;
            }
        }
        return field;
    }

    public static Object getFieldValue(Map map, Object object, String string) throws NoSuchFieldException {
        Object object2 = null;
        Field field = OgnlRuntime.getField(OgnlRuntime.getTargetClass(object), string);
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        try {
            Object object3 = null;
            if (field == null || Modifier.isStatic(field.getModifiers())) {
                throw new NoSuchFieldException(string);
            }
            object3 = Ognl.getMemberAccess(map).setup(map, object, field, string);
            object2 = field.get(object);
            Ognl.getMemberAccess(map).restore(map, object, field, string, object3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchFieldException(string);
        }
        return object2;
    }

    public static boolean setFieldValue(Map map, Object object, String string, Object object2) throws OgnlException {
        boolean bl;
        block4: {
            bl = false;
            try {
                Object object3;
                Field field;
                block5: {
                    field = OgnlRuntime.getField(OgnlRuntime.getTargetClass(object), string);
                    if (field == null || Modifier.isStatic(field.getModifiers())) break block4;
                    object3 = Ognl.getMemberAccess(map).setup(map, object, field, string);
                    try {
                        if (!OgnlRuntime.isTypeCompatible(object2, field.getType()) && (object2 = OgnlRuntime.getConvertedType(map, object, field, string, object2, field.getType())) == null) break block5;
                        field.set(object, object2);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        Ognl.getMemberAccess(map).restore(map, object, field, string, object3);
                        throw throwable;
                    }
                }
                Object var8_8 = null;
                Ognl.getMemberAccess(map).restore(map, object, field, string, object3);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NoSuchPropertyException(object, string, illegalAccessException);
            }
        }
        return bl;
    }

    public static boolean isFieldAccessible(Map map, Object object, Class clazz, String string) {
        return OgnlRuntime.isFieldAccessible(map, object, OgnlRuntime.getField(clazz, string), string);
    }

    public static boolean isFieldAccessible(Map map, Object object, Field field, String string) {
        return Ognl.getMemberAccess(map).isAccessible(map, object, field, string);
    }

    public static boolean hasField(Map map, Object object, Class clazz, String string) {
        Field field = OgnlRuntime.getField(clazz, string);
        return field != null && OgnlRuntime.isFieldAccessible(map, object, field, string);
    }

    public static Object getStaticField(Map map, String string, String string2) throws OgnlException {
        Exception exception = null;
        try {
            Class clazz = OgnlRuntime.classForName(map, string);
            if (string2.equals("class")) {
                return clazz;
            }
            Field field = clazz.getField(string2);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new OgnlException("Field " + string2 + " of class " + string + " is not static");
            }
            return field.get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            exception = noSuchFieldException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        throw new OgnlException("Could not get static field " + string2 + " from class " + string, exception);
    }

    public static Method getGetMethod(Map map, Class clazz, String string) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = OgnlRuntime.getPropertyDescriptor(clazz, string);
        return propertyDescriptor == null ? null : propertyDescriptor.getReadMethod();
    }

    public static boolean isMethodAccessible(Map map, Object object, Method method, String string) {
        return method == null ? false : Ognl.getMemberAccess(map).isAccessible(map, object, method, string);
    }

    public static boolean hasGetMethod(Map map, Object object, Class clazz, String string) throws IntrospectionException {
        return OgnlRuntime.isMethodAccessible(map, object, OgnlRuntime.getGetMethod(map, clazz, string), string);
    }

    public static Method getSetMethod(Map map, Class clazz, String string) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = OgnlRuntime.getPropertyDescriptor(clazz, string);
        return propertyDescriptor == null ? null : propertyDescriptor.getWriteMethod();
    }

    public static boolean hasSetMethod(Map map, Object object, Class clazz, String string) throws IntrospectionException {
        return OgnlRuntime.isMethodAccessible(map, object, OgnlRuntime.getSetMethod(map, clazz, string), string);
    }

    public static boolean hasGetProperty(Map map, Object object, Object object2) throws IntrospectionException {
        String string;
        Class clazz = OgnlRuntime.getTargetClass(object);
        return OgnlRuntime.hasGetMethod(map, object, clazz, string = object2.toString()) || OgnlRuntime.hasField(map, object, clazz, string);
    }

    public static boolean hasSetProperty(Map map, Object object, Object object2) throws IntrospectionException {
        String string;
        Class clazz = OgnlRuntime.getTargetClass(object);
        return OgnlRuntime.hasSetMethod(map, object, clazz, string = object2.toString()) || OgnlRuntime.hasField(map, object, clazz, string);
    }

    public static Map getPropertyDescriptors(Class clazz) throws IntrospectionException {
        Map map = propertyDescriptorCache;
        synchronized (map) {
            HashMap<String, PropertyDescriptor> hashMap = (HashMap<String, PropertyDescriptor>)propertyDescriptorCache.get(clazz);
            if (hashMap == null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                hashMap = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    hashMap.put(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n]);
                    ++n;
                }
                propertyDescriptorCache.put(clazz, hashMap);
            }
            return hashMap;
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) throws IntrospectionException {
        Map map = propertyDescriptorCache;
        synchronized (map) {
            return (PropertyDescriptor)OgnlRuntime.getPropertyDescriptors(clazz).get(string);
        }
    }

    public static void setPropertyAccessor(Class clazz, PropertyAccessor propertyAccessor) {
        propertyAccessors.put(clazz, propertyAccessor);
    }

    public static PropertyAccessor getPropertyAccessor(Class clazz) throws OgnlException {
        PropertyAccessor propertyAccessor = (PropertyAccessor)OgnlRuntime.getHandler(clazz, propertyAccessors);
        if (propertyAccessor != null) {
            return propertyAccessor;
        }
        throw new OgnlException("No property accessor for class " + clazz);
    }

    public static void setElementsAccessor(Class clazz, ElementsAccessor elementsAccessor) {
        elementsAccessors.put(clazz, elementsAccessor);
    }

    public static ElementsAccessor getElementsAccessor(Class clazz) throws OgnlException {
        ElementsAccessor elementsAccessor = (ElementsAccessor)OgnlRuntime.getHandler(clazz, elementsAccessors);
        if (elementsAccessor != null) {
            return elementsAccessor;
        }
        throw new OgnlException("No elements accessor for class " + clazz);
    }

    public static synchronized Object getHandler(Class clazz, Map map) {
        Object object = null;
        if (clazz.isArray()) {
            object = map.get(array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = OgnlRuntime.class$("[Ljava.lang.Object;")));
        } else {
            Class<Object> clazz2 = clazz;
            Class clazz3 = clazz;
            block0: while (clazz3 != null) {
                object = map.get(clazz3);
                if (object == null) {
                    Class<?>[] classArray = clazz3.getInterfaces();
                    int n = 0;
                    int n2 = classArray.length;
                    while (n < n2) {
                        Class<?> clazz4 = classArray[n];
                        object = map.get(clazz4);
                        if (object == null) {
                            object = OgnlRuntime.getHandler(clazz4, map);
                        }
                        if (object != null) {
                            clazz2 = clazz4;
                            break block0;
                        }
                        ++n;
                    }
                } else {
                    clazz2 = clazz3;
                    break;
                }
                clazz3 = clazz3.getSuperclass();
            }
            if (object != null && clazz2 != clazz) {
                map.put(clazz, object);
            }
        }
        return object;
    }

    public static Object getProperty(Map map, Object object, Object object2) throws OgnlException {
        Object var3_3 = null;
        if (object == null) {
            throw new OgnlException("source is null for getProperty(null, \"" + object2 + "\")");
        }
        if (object2 == null) {
            throw new OgnlException("name is null for getProperty(" + object.getClass().getName() + ", null)");
        }
        PropertyAccessor propertyAccessor = OgnlRuntime.getPropertyAccessor(object.getClass());
        if (propertyAccessor == null) {
            throw new OgnlException("No property accessor for " + object.getClass().getName());
        }
        return propertyAccessor.getProperty(map, object, object2);
    }

    public static void setProperty(Map map, Object object, Object object2, Object object3) throws OgnlException {
        Object var4_4 = null;
        if (object == null) {
            throw new OgnlException("target is null for setProperty(null, \"" + object2 + "\", " + object3 + ")");
        }
        if (object2 == null) {
            throw new OgnlException("name is null for setProperty(" + object.getClass().getName() + ", null, " + object3 + ")");
        }
        PropertyAccessor propertyAccessor = OgnlRuntime.getPropertyAccessor(object.getClass());
        if (propertyAccessor == null) {
            throw new OgnlException("No property accessor for " + object.getClass().getName());
        }
        propertyAccessor.setProperty(map, object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        constructorCache = new HashMap(101);
        staticMethodCache = new HashMap(101);
        instanceMethodCache = new HashMap(101);
        fieldCache = new HashMap(101);
        propertyDescriptorCache = new HashMap(101);
        superclasses = new ArrayList();
        propertyAccessors = new HashMap(17);
        elementsAccessors = new HashMap(23);
        DEFAULT_CLASS_RESOLVER = new DefaultClassResolver();
        DEFAULT_TYPE_CONVERTER = new DefaultTypeConverter();
        DEFAULT_MEMBER_ACCESS = new DefaultMemberAccess(false);
        try {
            Class.forName("java.util.Map");
            javaMajorVersion = 2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            javaMajorVersion = 1;
        }
        ArrayPropertyAccessor arrayPropertyAccessor = new ArrayPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = OgnlRuntime.class$("java.lang.Object")), new ObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(array$B != null ? array$B : (array$B = OgnlRuntime.class$("[B")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$S != null ? array$S : (array$S = OgnlRuntime.class$("[S")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$C != null ? array$C : (array$C = OgnlRuntime.class$("[C")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$I != null ? array$I : (array$I = OgnlRuntime.class$("[I")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$J != null ? array$J : (array$J = OgnlRuntime.class$("[J")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$F != null ? array$F : (array$F = OgnlRuntime.class$("[F")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$D != null ? array$D : (array$D = OgnlRuntime.class$("[D")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = OgnlRuntime.class$("[Ljava.lang.Object;")), arrayPropertyAccessor);
        OgnlRuntime.setPropertyAccessor(class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = OgnlRuntime.class$("java.util.List")), new ListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = OgnlRuntime.class$("java.util.Map")), new MapPropertyAccessor());
        ArrayElementsAccessor arrayElementsAccessor = new ArrayElementsAccessor();
        OgnlRuntime.setElementsAccessor(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = OgnlRuntime.class$("java.lang.Object")), new ObjectElementsAccessor());
        OgnlRuntime.setElementsAccessor(array$B != null ? array$B : (array$B = OgnlRuntime.class$("[B")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$S != null ? array$S : (array$S = OgnlRuntime.class$("[S")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$C != null ? array$C : (array$C = OgnlRuntime.class$("[C")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$I != null ? array$I : (array$I = OgnlRuntime.class$("[I")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$J != null ? array$J : (array$J = OgnlRuntime.class$("[J")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$F != null ? array$F : (array$F = OgnlRuntime.class$("[F")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$D != null ? array$D : (array$D = OgnlRuntime.class$("[D")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = OgnlRuntime.class$("[Ljava.lang.Object;")), arrayElementsAccessor);
        OgnlRuntime.setElementsAccessor(class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = OgnlRuntime.class$("java.util.Collection")), new CollectionElementsAccessor());
        OgnlRuntime.setElementsAccessor(class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = OgnlRuntime.class$("java.util.Map")), new MapElementsAccessor());
        OgnlRuntime.setElementsAccessor(class$Ljava$util$Iterator != null ? class$Ljava$util$Iterator : (class$Ljava$util$Iterator = OgnlRuntime.class$("java.util.Iterator")), new IteratorElementsAccessor());
        OgnlRuntime.setElementsAccessor(class$Ljava$util$Enumeration != null ? class$Ljava$util$Enumeration : (class$Ljava$util$Enumeration = OgnlRuntime.class$("java.util.Enumeration")), new EnumerationElementsAccessor());
        OgnlRuntime.setElementsAccessor(class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = OgnlRuntime.class$("java.lang.Number")), new NumberElementsAccessor());
    }
}

