/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.iap.ResponseInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class Protocol {
    protected String host;
    private Socket socket;
    private TraceInputStream traceInput;
    private ResponseInputStream input;
    private TraceOutputStream traceOutput;
    private DataOutputStream output;
    private int tagCounter;
    private Vector handlers;
    private long timestamp;
    private static final byte[] CRLF = new byte[]{13, 10};

    public Protocol(String string, int n, boolean bl, PrintStream printStream, Properties properties, String string2) throws IOException, ProtocolException {
        this.host = string;
        this.socket = SocketFetcher.getSocket((String)string, (int)n, (Properties)properties, (String)string2);
        String string3 = properties.getProperty("mail.debug.quote");
        boolean bl2 = string3 != null && string3.equalsIgnoreCase("true");
        this.traceInput = new TraceInputStream(this.socket.getInputStream(), (OutputStream)printStream);
        this.traceInput.setTrace(bl);
        this.traceInput.setQuote(bl2);
        this.input = new ResponseInputStream((InputStream)this.traceInput);
        this.traceOutput = new TraceOutputStream(this.socket.getOutputStream(), (OutputStream)printStream);
        this.traceOutput.setTrace(bl);
        this.traceOutput.setQuote(bl2);
        this.output = new DataOutputStream(new BufferedOutputStream((OutputStream)this.traceOutput));
        this.processGreeting(this.readResponse());
        this.timestamp = System.currentTimeMillis();
    }

    public Protocol(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.host = "localhost";
        this.traceInput = new TraceInputStream(inputStream, (OutputStream)System.out);
        this.traceInput.setTrace(bl);
        this.input = new ResponseInputStream((InputStream)this.traceInput);
        this.traceOutput = new TraceOutputStream(outputStream, (OutputStream)System.out);
        this.traceOutput.setTrace(bl);
        this.output = new DataOutputStream(new BufferedOutputStream((OutputStream)this.traceOutput));
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void addResponseHandler(ResponseHandler responseHandler) {
        if (this.handlers == null) {
            this.handlers = new Vector();
        }
        this.handlers.addElement(responseHandler);
    }

    public synchronized void removeResponseHandler(ResponseHandler responseHandler) {
        if (this.handlers != null) {
            this.handlers.removeElement(responseHandler);
        }
    }

    public void notifyResponseHandlers(Response[] responseArray) {
        if (this.handlers == null) {
            return;
        }
        int n = this.handlers.size();
        int n2 = 0;
        while (n2 < responseArray.length) {
            Response response = responseArray[n2];
            if (response != null) {
                int n3 = 0;
                while (n3 < n) {
                    ((ResponseHandler)this.handlers.elementAt(n3)).handleResponse(response);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    protected void processGreeting(Response response) throws ProtocolException {
        if (response.isBYE()) {
            throw new ConnectionException(response);
        }
    }

    protected ResponseInputStream getInputStream() {
        return this.input;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected boolean supportsNonSyncLiterals() {
        return false;
    }

    public Response readResponse() throws IOException, ProtocolException {
        return new Response(this);
    }

    public String writeCommand(String string, Argument argument) throws IOException, ProtocolException {
        String string2 = "A" + Integer.toString(this.tagCounter++, 10);
        this.output.writeBytes(String.valueOf(string2) + " " + string);
        if (argument != null) {
            this.output.write(32);
            argument.write(this);
        }
        this.output.write(CRLF);
        this.output.flush();
        return string2;
    }

    public synchronized Response[] command(String string, Argument argument) {
        Vector<Response> vector = new Vector<Response>();
        boolean bl = false;
        String string2 = null;
        Response response = null;
        try {
            string2 = this.writeCommand(string, argument);
        }
        catch (LiteralException literalException) {
            vector.addElement(literalException.getResponse());
            bl = true;
        }
        catch (Exception exception) {
            vector.addElement(Response.ByeResponse);
            bl = true;
        }
        while (!bl) {
            try {
                response = this.readResponse();
            }
            catch (IOException iOException) {
                response = Response.ByeResponse;
            }
            catch (ProtocolException protocolException) {
                continue;
            }
            vector.addElement(response);
            if (response.isBYE()) {
                bl = true;
            }
            if (!response.isTagged() || !response.getTag().equals(string2)) continue;
            bl = true;
        }
        Object[] objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.timestamp = System.currentTimeMillis();
        return objectArray;
    }

    public void handleResult(Response response) throws ProtocolException {
        if (response.isOK()) {
            return;
        }
        if (response.isNO()) {
            throw new CommandFailedException(response);
        }
        if (response.isBAD()) {
            throw new BadCommandException(response);
        }
        if (response.isBYE()) {
            this.disconnect();
            throw new ConnectionException(response);
        }
    }

    public void simpleCommand(String string, Argument argument) throws ProtocolException {
        Response[] responseArray = this.command(string, argument);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }
}

