/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus;
    private long cachedStatusTime;
    private boolean debug = false;
    private boolean connectionPoolDebug;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore) {
        super((Store)iMAPStore);
        if (string == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = string;
        this.separator = c;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException((Folder)this, String.valueOf(this.fullName) + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException((Folder)this, "Lost folder connection to server");
        }
    }

    private void checkRange(int n) throws MessagingException {
        if (n < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        if (n > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        block2: {
            if (this.name != null) break block2;
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {}
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c = this.getSeparator0();
        int n = this.fullName.lastIndexOf(c);
        if (n != -1) {
            return new IMAPFolder(this.fullName.substring(0, n), c, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.list("", this.fullName);
                }
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray != null) {
            this.fullName = listInfoArray[0].name;
            this.separator = listInfoArray[0].separator;
            if (listInfoArray[0].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private Folder[] doList(String string, boolean bl) throws MessagingException {
        Folder[] folderArray;
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        char c = this.getSeparator0();
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = bl ? iMAPProtocol.lsub("", String.valueOf(this.fullName) + c + string) : iMAPProtocol.list("", String.valueOf(this.fullName) + c + string);
                }
            }
            catch (CommandFailedException commandFailedException) {
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            folderArray = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n = 0;
        if (listInfoArray[0].name.equals(String.valueOf(this.fullName) + c)) {
            n = 1;
        }
        folderArray = new IMAPFolder[listInfoArray.length - n];
        int n2 = n;
        while (n2 < listInfoArray.length) {
            folderArray[n2 - n] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    Object object = this.lockFor(iMAPProtocol);
                    synchronized (object) {
                        listInfoArray = iMAPProtocol.isREV1() ? iMAPProtocol.list(this.fullName, "") : iMAPProtocol.list("", this.fullName);
                    }
                }
                catch (ConnectionException connectionException) {
                    this.throwClosedException(iMAPProtocol, connectionException);
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
                Object var4_6 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    listInfoArray = iMAPProtocol.lsub("", this.fullName);
                }
            }
            catch (ProtocolException protocolException) {
            }
            Object var4_4 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return listInfoArray != null;
    }

    public void setSubscribed(boolean bl) throws MessagingException {
        this.checkExists();
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    if (bl) {
                        iMAPProtocol.subscribe(this.fullName);
                    } else {
                        iMAPProtocol.unsubscribe(this.fullName);
                    }
                }
            }
            catch (CommandFailedException commandFailedException) {
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized boolean create(int n) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    if ((n & 1) == 0) {
                        iMAPProtocol.create(String.valueOf(this.fullName) + this.getSeparator0());
                    } else {
                        ListInfo[] listInfoArray;
                        iMAPProtocol.create(this.fullName);
                        if ((n & 2) != 0 && (listInfoArray = iMAPProtocol.list("", this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                            iMAPProtocol.delete(this.fullName);
                            throw new MessagingException("Unsupported type");
                        }
                    }
                }
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl = false;
                Object var5_8 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl;
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        this.exists = true;
        this.type = n;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException((Folder)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
            }
            if (this.recent <= 0) return false;
            return true;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    ListInfo[] listInfoArray = iMAPProtocol.list("", this.fullName);
                    if (listInfoArray != null) {
                        if (listInfoArray[0].changeState == 1) {
                            boolean bl = true;
                            Object var7_14 = null;
                            // MONITOREXIT @DISABLED, blocks:[17, 18, 2, 3, 4, 6] lbl33 : MonitorExitStatement: MONITOREXIT : var6_6
                            Object var4_18 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return bl;
                        }
                        if (listInfoArray[0].changeState == 2) {
                            boolean bl = false;
                            Object var7_15 = null;
                            // MONITOREXIT @DISABLED, blocks:[16, 18, 2, 3, 4, 6] lbl42 : MonitorExitStatement: MONITOREXIT : var6_6
                            Object var4_19 = null;
                            this.releaseStoreProtocol(iMAPProtocol);
                            return bl;
                        }
                    }
                    Status status = this.getStatus();
                    if (status.recent > 0) {
                        boolean bl = true;
                        Object var7_16 = null;
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 6, 15] lbl52 : MonitorExitStatement: MONITOREXIT : var6_6
                        Object var4_20 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return bl;
                    }
                    boolean bl = false;
                    Object var7_17 = null;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 6] lbl60 : MonitorExitStatement: MONITOREXIT : var6_6
                    Object var4_21 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return bl;
                }
            }
            catch (BadCommandException badCommandException) {
                boolean bl = false;
                Object var4_22 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var4_23 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator0();
        return new IMAPFolder(String.valueOf(this.fullName) + c + string, c, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean bl) throws MessagingException {
        boolean bl2;
        Object object;
        this.checkClosed();
        if (bl) {
            object = this.list();
            bl2 = false;
            while (bl2 < ((Folder[])object).length) {
                object[bl2].delete(bl);
                bl2 += 1;
            }
        }
        object = null;
        try {
            try {
                object = this.getStoreProtocol();
                Object object2 = this.lockFor((IMAPProtocol)object);
                synchronized (object2) {
                    ((IMAPProtocol)object).delete(this.fullName);
                }
            }
            catch (CommandFailedException commandFailedException) {
                bl2 = false;
                Object var5_7 = null;
                this.releaseStoreProtocol((IMAPProtocol)object);
                return bl2;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_8 = null;
            this.releaseStoreProtocol((IMAPProtocol)object);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.releaseStoreProtocol((IMAPProtocol)object);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.rename(this.fullName, folder.getFullName());
                }
            }
            catch (CommandFailedException commandFailedException) {
                boolean bl = false;
                Object var5_7 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                return bl;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    public synchronized void open(int n) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.protocol.addResponseHandler(this);
            try {
                mailboxInfo = n == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (ProtocolException protocolException) {
                this.protocol.removeResponseHandler(this);
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException2) {}
                this.protocol = null;
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            if (!(mailboxInfo.mode == n || n == 2 && mailboxInfo.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                this.protocol.removeResponseHandler(this);
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException protocolException) {}
                this.protocol = null;
                throw new ReadOnlyFolderException((Folder)this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.messageCache = new Vector(this.total);
            int n2 = 0;
            while (n2 < this.total) {
                this.messageCache.addElement(new IMAPMessage(this, n2 + 1, n2 + 1));
                ++n2;
            }
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(messageArray, null), flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            return;
        }
    }

    public synchronized void close(boolean bl) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (!this.opened && this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            this.reallyClosed = true;
            if (!this.opened) {
                Object var3_3 = null;
                return;
            }
            try {
                block19: {
                    try {
                        block20: {
                            if (((IMAPStore)this.store).isConnectionPoolFull()) {
                                if (this.debug) {
                                    System.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                                }
                                if (bl) {
                                    this.protocol.close();
                                }
                                if (this.protocol != null) {
                                    this.protocol.logout();
                                }
                                break block19;
                            }
                            if (!bl && this.mode == 2) {
                                try {
                                    this.protocol.examine(this.fullName);
                                }
                                catch (ProtocolException protocolException) {
                                    if (this.protocol == null) break block20;
                                    this.protocol.disconnect();
                                }
                            }
                        }
                        if (this.protocol != null) {
                            this.protocol.close();
                        }
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                    }
                }
                Object var5_5 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
                throw throwable;
            }
            return;
        }
    }

    private void cleanup(boolean bl) {
        this.releaseProtocol(bl);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {}
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        int n;
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            n = mailboxInfo.total;
                            Object var6_12 = null;
                        }
                        Object var3_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        int n;
                        iMAPProtocol = this.getStoreProtocol();
                        Object object = this.lockFor(iMAPProtocol);
                        synchronized (object) {
                            MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                            iMAPProtocol.close();
                            n = mailboxInfo.recent;
                            Object var6_12 = null;
                        }
                        Object var3_13 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_14 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search((SearchTerm)new FlagTerm(flags, false));
                int n = nArray.length;
                Object var4_10 = null;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search((SearchTerm)new FlagTerm(flags, true));
                int n = nArray.length;
                Object var4_7 = null;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status getStatus() throws ProtocolException {
        int n = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            Status status;
            iMAPProtocol = this.getStoreProtocol();
            Object object = this.lockFor(iMAPProtocol);
            synchronized (object) {
                Status status2 = iMAPProtocol.status(this.fullName, null);
                if (n > 0) {
                    this.cachedStatus = status2;
                    this.cachedStatusTime = System.currentTimeMillis();
                }
                status = status2;
                Object var7_6 = null;
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return status;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpened();
        this.checkRange(n);
        return (Message)this.messageCache.elementAt(n - 1);
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n = ((IMAPStore)this.store).getAppendBufferSize();
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                int n2 = 0;
                while (n2 < messageArray.length) {
                    block16: {
                        MessageLiteral messageLiteral;
                        Message message = messageArray[n2];
                        try {
                            messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
                        }
                        catch (IOException iOException) {
                            throw new MessagingException("IOException while appending messages", (Exception)iOException);
                        }
                        catch (MessageRemovedException messageRemovedException) {
                            break block16;
                        }
                        Object object = this.messageCacheLock;
                        synchronized (object) {
                            Object object2 = this.lockFor(iMAPProtocol);
                            synchronized (object2) {
                                Date date = message.getReceivedDate();
                                if (date == null) {
                                    date = message.getSentDate();
                                }
                                iMAPProtocol.append(this.fullName, message.getFlags(), date, messageLiteral);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_13 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(Utility.toMessageSet(messageArray, null), folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, String.valueOf(folder.getFullName()) + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), (Exception)commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException((Folder)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
                return;
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object[] objectArray = this.messageCacheLock;
        synchronized (objectArray) {
            IMAPMessage iMAPMessage;
            this.doExpungeNotification = false;
            try {
                try {
                    this.protocol.expunge();
                }
                catch (CommandFailedException commandFailedException) {
                    if (this.mode != 2) {
                        throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                    }
                    throw new MessagingException(commandFailedException.getMessage(), (Exception)commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException((Folder)this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
                iMAPMessage = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n = 0;
            while (n < this.messageCache.size()) {
                iMAPMessage = (IMAPMessage)((Object)this.messageCache.elementAt(n));
                if (iMAPMessage.isExpunged()) {
                    long l;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n);
                    if (this.uidTable == null || (l = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n;
            }
        }
        this.total = this.messageCache.size();
        objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            IMAPMessage[] iMAPMessageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    iMAPMessageArray = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        iMAPMessageArray[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return iMAPMessageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
    }

    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            IMAPMessage[] iMAPMessageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(Utility.toMessageSet(messageArray, null), searchTerm);
                if (nArray != null) {
                    iMAPMessageArray = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        iMAPMessageArray[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return iMAPMessageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
    }

    public long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    String[] stringArray = new String[]{"UIDVALIDITY"};
                    status = iMAPProtocol.status(this.fullName, stringArray);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("Cannot obtain UIDValidity", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return status.uidvalidity;
    }

    public synchronized Message getMessageByUID(long l) throws MessagingException {
        this.checkOpened();
        Long l2 = new Long(l);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)((Object)this.uidTable.get(l2));
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID = this.protocol.fetchSequenceNumber(l);
                if (uID != null) {
                    iMAPMessage = (IMAPMessage)((Object)this.messageCache.elementAt(uID.msgno - 1));
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l2, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
        return iMAPMessage;
    }

    public synchronized Message[] getMessagesByUID(long l, long l2) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l, l2);
                messageArray = new Message[uIDArray.length];
                int n = 0;
                while (n < uIDArray.length) {
                    IMAPMessage iMAPMessage = (IMAPMessage)((Object)this.messageCache.elementAt(uIDArray[n].msgno - 1));
                    iMAPMessage.setUID(uIDArray[n].uid);
                    messageArray[n] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                    ++n;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException((Folder)this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
        }
        return messageArray;
    }

    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            messageArray = new Vector();
            int n2 = 0;
            while (n2 < lArray.length) {
                Long l = new Long(lArray[n2]);
                if (!this.uidTable.containsKey(l)) {
                    messageArray.addElement(l);
                }
                ++n2;
            }
            int n3 = messageArray.size();
            lArray2 = new long[n3];
            n = 0;
            while (n < n3) {
                lArray2[n] = (Long)messageArray.elementAt(n);
                ++n;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    UID[] uIDArray = this.protocol.fetchSequenceNumbers(lArray2);
                    n = 0;
                    while (n < uIDArray.length) {
                        IMAPMessage iMAPMessage = (IMAPMessage)((Object)this.messageCache.elementAt(uIDArray[n].msgno - 1));
                        iMAPMessage.setUID(uIDArray[n].uid);
                        this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                        ++n;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        int n4 = 0;
        while (n4 < lArray.length) {
            messageArray[n4] = (Message)this.uidTable.get(new Long(lArray[n4]));
            ++n4;
        }
        return messageArray;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l = iMAPMessage.getUID();
        if (l != -1L) {
            return l;
        }
        UID uID = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        if (uID != null) {
            l = uID.uid;
            iMAPMessage.setUID(l);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l), iMAPMessage);
        }
        return l;
    }

    public Quota[] getQuota() throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    quotaArray = iMAPProtocol.getQuotaRoot(this.fullName);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return quotaArray;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setQuota(quota);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public ACL[] getACL() throws MessagingException {
        ACL[] aCLArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    aCLArray = iMAPProtocol.getACL(this.fullName);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return aCLArray;
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(String string) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.deleteACL(this.fullName, string);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(String string) throws MessagingException {
        Rights[] rightsArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rightsArray = iMAPProtocol.listRights(this.fullName, string);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rightsArray;
    }

    public Rights myRights() throws MessagingException {
        Rights rights = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    rights = iMAPProtocol.myRights(this.fullName);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return rights;
    }

    private void setACL(ACL aCL, char c) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                Object object = this.lockFor(iMAPProtocol);
                synchronized (object) {
                    iMAPProtocol.setACL(this.fullName, c, aCL);
                }
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("ACL not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(iMAPProtocol, connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public void handleResponse(Response response) {
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            return;
        }
        if (!response.isUnTagged()) {
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            System.out.println("UNEXPECTED RESPONSE : " + response.toString());
            System.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n = iMAPResponse.getNumber();
            if (n <= this.realTotal) {
                return;
            }
            int n2 = n - this.realTotal;
            Message[] messageArray = new Message[n2];
            int n3 = 0;
            while (n3 < n2) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n3] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n3;
            }
            this.notifyMessageAddedListeners(messageArray);
            return;
        }
        if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n = iMAPMessage.getMessageNumber();
            while (n < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
                return;
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)fetchResponse.getItem(class$javax$mail$Flags != null ? class$javax$mail$Flags : (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags")));
            if (flags != null) {
                IMAPMessage iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber());
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, (Message)iMAPMessage);
                return;
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n = 0;
        while (n < responseArray.length) {
            if (responseArray[n] != null) {
                this.handleResponse(responseArray[n]);
            }
            ++n;
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
            if (this.connectionPoolDebug) {
                System.out.println("DEBUG: getStoreProtocol() - using our own connection");
            }
            return this.protocol;
        }
        if (this.connectionPoolDebug) {
            System.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(IMAPProtocol iMAPProtocol, Exception exception) throws FolderClosedException, StoreClosedException {
        if (iMAPProtocol == this.protocol) {
            throw new FolderClosedException((Folder)this, exception.getMessage());
        }
        throw new StoreClosedException(this.store, exception.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        if (!this.opened) {
            IMAPProtocol iMAPProtocol = null;
            try {
                try {
                    Object object;
                    iMAPProtocol = this.getStoreProtocol();
                    Object object2 = this.lockFor(iMAPProtocol);
                    synchronized (object2) {
                        object = protocolCommand.doCommand(iMAPProtocol);
                        Object var7_10 = null;
                    }
                    Object var4_11 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return object;
                }
                catch (ConnectionException connectionException) {
                    throw new StoreClosedException(this.store, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
            }
            catch (Throwable throwable) {
                Object var4_12 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                return protocolCommand.doCommand(this.getProtocol());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException((Folder)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
    }

    protected synchronized Object lockFor(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol == this.protocol) {
            return this.messageCacheLock;
        }
        return new Object();
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private synchronized void releaseProtocol(boolean bl) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
                return;
            }
            ((IMAPStore)this.store).releaseProtocol(this, null);
        }
    }

    private void keepConnectionAlive(boolean bl) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (bl && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol;
            block4: {
                iMAPProtocol = null;
                try {
                    iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                    if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() <= 1000L) break block4;
                    iMAPProtocol.noop();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            Object var4_3 = null;
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            return;
        }
    }

    IMAPMessage getMessageBySeqNumber(int n) {
        int n2 = n - 1;
        while (n2 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)((Object)this.messageCache.elementAt(n2));
            if (iMAPMessage.getSequenceNumber() == n) {
                return iMAPMessage;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String string) {
            super(string);
        }
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }
}

