/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.Namespaces;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class IMAPStore
extends Store
implements ResponseHandler {
    private String name = "imap";
    private int blksize = 16384;
    private int port = 143;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private String host;
    private String user;
    private String password;
    private Namespaces namespaces;
    private boolean debug;
    private PrintStream out;
    private ConnectionPool pool = new ConnectionPool();

    public IMAPStore(Session session, URLName uRLName) {
        super(session, uRLName);
        int n;
        String string;
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        this.out = session.getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
        if ((string = session.getProperty("mail." + this.name + ".connectionpool.debug")) != null && string.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
        if ((string = session.getProperty("mail." + this.name + ".partialfetch")) != null && string.equalsIgnoreCase("false")) {
            this.blksize = -1;
        } else {
            string = session.getProperty("mail." + this.name + ".fetchsize");
            if (string != null) {
                this.blksize = Integer.parseInt(string);
            }
        }
        string = session.getProperty("mail." + this.name + ".statuscachetimeout");
        if (string != null) {
            this.statusCacheTimeout = Integer.parseInt(string);
        }
        if ((string = session.getProperty("mail." + this.name + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(string);
        }
        if ((string = session.getProperty("mail." + this.name + ".connectionpoolsize")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.pool.poolSize = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: found a pool size property: " + this.pool.poolSize);
            }
        }
        if ((string = session.getProperty("mail." + this.name + ".connectionpooltimeout")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.pool.clientTimeoutInterval = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: found a timeout property: " + this.pool.clientTimeoutInterval);
            }
        }
        if ((string = session.getProperty("mail." + this.name + ".separatestoreconnection")) != null && string.equalsIgnoreCase("true")) {
            if (this.pool.debug) {
                this.out.println("DEBUG: dedicate a store connection");
            }
            this.pool.separateStoreConnection = true;
        }
    }

    protected synchronized boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        block15: {
            IMAPProtocol iMAPProtocol = null;
            if (string == null || string3 == null || string2 == null) {
                return false;
            }
            if (n != -1) {
                this.port = n;
            } else {
                String string4 = ((Service)this).session.getProperty("mail." + this.name + ".port");
                if (string4 != null) {
                    this.port = Integer.parseInt(string4);
                }
            }
            if (this.port == -1) {
                this.port = 143;
            }
            try {
                boolean bl;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    bl = this.pool.authenticatedConnections.isEmpty();
                }
                if (!bl) break block15;
                iMAPProtocol = new IMAPProtocol(this.name, string, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties());
                this.login(iMAPProtocol, string2, string3);
                iMAPProtocol.addResponseHandler(this);
                this.host = string;
                this.user = string2;
                this.password = string3;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                }
            }
            catch (CommandFailedException commandFailedException) {
                iMAPProtocol.disconnect();
                iMAPProtocol = null;
                throw new AuthenticationFailedException(commandFailedException.getResponse().getRest());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            catch (IOException iOException) {
                throw new MessagingException(iOException.getMessage(), (Exception)iOException);
            }
        }
        return true;
    }

    private void login(IMAPProtocol iMAPProtocol, String string, String string2) throws ProtocolException {
        if (iMAPProtocol.isAuthenticated()) {
            return;
        }
        if (iMAPProtocol.hasCapability("AUTH-LOGIN") || iMAPProtocol.hasCapability("AUTH=LOGIN")) {
            iMAPProtocol.authlogin(string, string2);
            return;
        }
        iMAPProtocol.login(string, string2);
    }

    IMAPProtocol getProtocol(IMAPFolder iMAPFolder) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty() || this.pool.separateStoreConnection && this.pool.authenticatedConnections.size() == 1 || this.pool.borrowedStoreConnections > 0L && this.pool.authenticatedConnections.size() == 1) {
                if (this.debug) {
                    this.out.println("DEBUG: no connections in the pool, creating a new one");
                }
                try {
                    iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties());
                    this.login(iMAPProtocol, this.user, this.password);
                }
                catch (Exception exception) {
                    if (iMAPProtocol != null) {
                        try {
                            iMAPProtocol.disconnect();
                        }
                        catch (Exception exception2) {}
                    }
                    iMAPProtocol = null;
                }
                if (iMAPProtocol == null) {
                    throw new MessagingException("connection failure");
                }
            } else {
                if (this.debug) {
                    this.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                iMAPProtocol.removeResponseHandler(this);
                this.pool.authenticatedConnections.removeElement(iMAPProtocol);
            }
            this.timeoutConnections();
            if (iMAPFolder != null) {
                if (this.pool.folders == null) {
                    this.pool.folders = new Vector();
                }
                this.pool.folders.addElement(iMAPFolder);
            }
        }
        return iMAPProtocol;
    }

    IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol iMAPProtocol = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty()) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                }
                try {
                    iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, ((Service)this).session.getDebug(), ((Service)this).session.getDebugOut(), ((Service)this).session.getProperties());
                    this.login(iMAPProtocol, this.user, this.password);
                }
                catch (Exception exception) {
                    if (iMAPProtocol != null) {
                        try {
                            iMAPProtocol.logout();
                        }
                        catch (Exception exception2) {}
                    }
                    iMAPProtocol = null;
                }
                if (iMAPProtocol == null) {
                    throw new ProtocolException("connection failure");
                }
                iMAPProtocol.addResponseHandler(this);
                this.pool.authenticatedConnections.addElement(iMAPProtocol);
            } else {
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
            }
            if (!this.pool.separateStoreConnection) {
                ConnectionPool connectionPool2 = this.pool;
                connectionPool2.borrowedStoreConnections = connectionPool2.borrowedStoreConnections + 1L;
                if (this.pool.debug) {
                    this.out.println("DEBUG: getStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            IMAPProtocol iMAPProtocol2 = iMAPProtocol;
            Object var4_4 = null;
            return iMAPProtocol2;
        }
    }

    boolean allowReadOnlySelect() {
        String string = ((Service)this).session.getProperty("mail." + this.name + ".allowreadonlyselect");
        return string != null && string.equalsIgnoreCase("true");
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                this.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            boolean bl = this.pool.authenticatedConnections.size() >= this.pool.poolSize;
            Object var3_3 = null;
            return bl;
        }
    }

    void releaseProtocol(IMAPFolder iMAPFolder, IMAPProtocol iMAPProtocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (iMAPProtocol != null) {
                if (!this.isConnectionPoolFull()) {
                    iMAPProtocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(iMAPProtocol);
                    if (this.debug) {
                        this.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        iMAPProtocol.logout();
                    }
                    catch (ProtocolException protocolException) {}
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(iMAPFolder);
            }
            this.timeoutConnections();
            return;
        }
    }

    void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (!this.pool.separateStoreConnection) {
                ConnectionPool connectionPool2 = this.pool;
                connectionPool2.borrowedStoreConnections = connectionPool2.borrowedStoreConnections - 1L;
                if (this.pool.debug) {
                    this.out.println("DEBUG: releaseStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            return;
        }
    }

    private void emptyConnectionPool() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            int n = this.pool.authenticatedConnections.size() - 1;
            while (n >= 0) {
                try {
                    ((IMAPProtocol)this.pool.authenticatedConnections.elementAt(n)).removeResponseHandler(this);
                    ((IMAPProtocol)this.pool.authenticatedConnections.elementAt(n)).logout();
                }
                catch (ProtocolException protocolException) {}
                --n;
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            this.out.println("DEBUG: removed all authenticated connections");
        }
    }

    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    this.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                int n = this.pool.authenticatedConnections.size() - 1;
                while (n > 0) {
                    IMAPProtocol iMAPProtocol = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(n);
                    if (this.pool.debug) {
                        this.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - iMAPProtocol.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > this.pool.clientTimeoutInterval) {
                        if (this.pool.debug) {
                            this.out.println("DEBUG: authenticated connection timed out");
                            this.out.println("DEBUG: logging out the connection");
                        }
                        iMAPProtocol.removeResponseHandler(this);
                        this.pool.authenticatedConnections.removeElementAt(n);
                        try {
                            iMAPProtocol.logout();
                        }
                        catch (ProtocolException protocolException) {}
                    }
                    --n;
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
            return;
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return ((Service)this).session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.noop();
            }
            catch (ProtocolException protocolException) {
            }
            Object var3_2 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return super.isConnected();
    }

    public void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                boolean bl;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    bl = this.pool.authenticatedConnections.isEmpty();
                }
                if (bl) {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: close() - no connections ");
                    }
                    this.cleanup();
                    Object var3_5 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    return;
                }
                iMAPProtocol = this.getStoreProtocol();
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.removeElement(iMAPProtocol);
                }
                iMAPProtocol.logout();
            }
            catch (ProtocolException protocolException) {
                this.cleanup();
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        Object var3_6 = null;
        this.releaseStoreProtocol(iMAPProtocol);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private synchronized void cleanup() {
        ConnectionPool connectionPool;
        Vector vector = null;
        boolean bl = true;
        block10: while (true) {
            connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    bl = false;
                    vector = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    bl = true;
                }
            }
            if (bl) break;
            int n = 0;
            int n2 = vector.size();
            while (true) {
                if (n >= n2) continue block10;
                IMAPFolder iMAPFolder = (IMAPFolder)vector.elementAt(n);
                try {
                    iMAPFolder.close(false);
                }
                catch (MessagingException messagingException) {}
                ++n;
            }
            break;
        }
        connectionPool = this.pool;
        synchronized (connectionPool) {
            this.emptyConnectionPool();
        }
        try {
            super.close();
            return;
        }
        catch (MessagingException messagingException) {
            return;
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String string) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(string, '\uffff', this);
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(uRLName.getFile(), '\uffff', this);
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(namespaces.personal, null);
    }

    public Folder[] getUserNamespaces(String string) throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.otherUsers == null) {
            return super.getUserNamespaces(string);
        }
        return this.namespaceToFolders(namespaces.otherUsers, string);
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces namespaces = this.getNamespaces();
        if (namespaces == null || namespaces.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(namespaces.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        this.checkConnected();
        IMAPProtocol iMAPProtocol = null;
        if (this.namespaces == null) {
            try {
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    this.namespaces = iMAPProtocol.namespace();
                }
                catch (BadCommandException badCommandException) {
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
                }
                Object var3_3 = null;
                this.releaseStoreProtocol(iMAPProtocol);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.releaseStoreProtocol(iMAPProtocol);
                throw throwable;
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] namespaceArray, String string) {
        Folder[] folderArray = new Folder[namespaceArray.length];
        int n = 0;
        while (n < folderArray.length) {
            String string2 = namespaceArray[n].prefix;
            if (string == null) {
                int n2 = string2.length();
                if (n2 > 0 && string2.charAt(n2 - 1) == namespaceArray[n].delimiter) {
                    string2 = string2.substring(0, n2 - 1);
                }
            } else {
                string2 = String.valueOf(string2) + string;
            }
            folderArray[n] = new IMAPFolder(string2, namespaceArray[n].delimiter, this);
            ++n;
        }
        return folderArray;
    }

    public Quota[] getQuota(String string) throws MessagingException {
        Quota[] quotaArray = null;
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                quotaArray = iMAPProtocol.getQuotaRoot(string);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException((Store)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var5_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return quotaArray;
    }

    public void setQuota(Quota quota) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                iMAPProtocol.setQuota(quota);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("QUOTA not supported", (Exception)badCommandException);
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException((Store)this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)protocolException);
            }
            Object var4_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void handleResponse(Response response) {
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            this.handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (super.isConnected()) {
                this.cleanup();
            }
            return;
        }
    }

    void handleResponseCode(Response response) {
        String string = response.getRest();
        boolean bl = false;
        if (string.startsWith("[")) {
            int n = string.indexOf(93);
            if (n > 0 && string.substring(0, n + 1).equalsIgnoreCase("[ALERT]")) {
                bl = true;
            }
            string = string.substring(n + 1).trim();
        }
        if (bl) {
            this.notifyStoreListeners(1, string);
            return;
        }
        if (response.isUnTagged() && string.length() > 0) {
            this.notifyStoreListeners(2, string);
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private long borrowedStoreConnections;
        private long clientTimeoutInterval = 45000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;

        ConnectionPool() {
        }
    }
}

