/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.conversation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.ConversationManager;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.security.conversation.message.token.DerivedKeyToken;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConversationServerHandler
extends BasicHandler {
    private static DerivedKeyCallbackHandler dkcbHandler;

    public ConversationServerHandler() {
        System.out.println("ConversationServerHandler :: created");
        dkcbHandler = new DerivedKeyCallbackHandler();
    }

    public void invoke(MessageContext msg) throws AxisFault {
        System.out.println("ConversationServerHandler :: invoked");
        if (msg.getPastPivot()) {
            this.doResponse(msg);
        } else {
            this.doRequest(msg);
        }
    }

    private void doRequest(MessageContext msg) throws AxisFault {
        try {
            Document doc = null;
            Message message = msg.getCurrentMessage();
            SOAPPart sPart = (SOAPPart)message.getSOAPPart();
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            NodeList list = doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "SecurityContextTokenResponse");
            int len = list.getLength();
            if (len == 0) {
                try {
                    NodeList ndList = doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "DerivedKeyToken");
                    for (int i = 0; i < ndList.getLength(); ++i) {
                        Element tmpE = (Element)ndList.item(i);
                        DerivedKeyToken tmpDKT = new DerivedKeyToken(tmpE);
                        String tmpID = tmpDKT.getID();
                    }
                    WSSecurityEngine secEng = new WSSecurityEngine();
                    secEng.processSecurityHeader(doc, "", dkcbHandler, null);
                }
                catch (WSSecurityException e1) {
                    e1.printStackTrace();
                    throw new AxisFault("Error !!!! " + e1.getMessage());
                }
            } else {
                Element elem = (Element)list.item(0);
                RequestSecurityTokenResponse stRes = new RequestSecurityTokenResponse(elem);
                System.out.println("SecurityTokenResponse Found :: " + stRes.toString());
                SecurityContextToken SCT = stRes.getRequestedSecurityToken().getSecurityContextToken();
                RequestedProofToken proofToken = stRes.getRequestedProfToken();
                proofToken.doDecryption("org.apache.ws.axis.oasis.PWCallback", this.loadEncryptionCrypto());
                SecurityContextInfo scInfo = new SecurityContextInfo(SCT, proofToken, 1);
                scInfo.setSharedSecret(proofToken.getSharedSecret());
                DerivedKeyCallbackHandler.addSecurtiyContext("uuid:secureZone", scInfo);
                msg.setProperty("WSSecureConversation.ID", (Object)SCT.getIdentifier());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            String osStr = os.toString();
            sPart.setCurrentMessage((Object)osStr, 1);
            SOAPHeader sHeader = null;
            try {
                sHeader = message.getSOAPEnvelope().getHeader();
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", (Throwable)ex);
            }
            String actor = null;
            Iterator headers = sHeader.examineHeaderElements(actor);
            javax.xml.soap.SOAPHeaderElement headerElement = null;
            while (headers.hasNext()) {
                javax.xml.soap.SOAPHeaderElement hE = (javax.xml.soap.SOAPHeaderElement)headers.next();
                if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
                headerElement = hE;
                break;
            }
            ((SOAPHeaderElement)headerElement).setProcessed(true);
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doResponse(MessageContext msg) throws AxisFault {
        System.out.println("Doing response .... ");
        Document doc = null;
        Message message = msg.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        try {
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            String uuid = (String)msg.getProperty("WSSecureConversation.ID");
            ConversationManager manager = new ConversationManager();
            String genID = ConversationUtil.genericID();
            manager.addDerivedKeyToken(doc, uuid, dkcbHandler, genID);
            Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), false);
            WSSecurityUtil.appendChildElement(doc, securityHeader, new SecurityContextToken(doc, uuid).getElement());
            Init.init();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            String osStr = os.toString();
            sPart.setCurrentMessage((Object)osStr, 1);
            Reference ref = new Reference(doc);
            ref.setURI("#" + genID);
            ref.setValueType("DerivedKeyToken");
            SecurityTokenReference stRef = new SecurityTokenReference(doc);
            stRef.setReference(ref);
            msg.setProperty("encryptionPropFile", (Object)"crypto.properties");
            msg.setProperty("encryptionKeyIdentifier", (Object)"EmbeddedKeyName");
            msg.setProperty("EmbeddedKeyName", (Object)stRef.toString());
            msg.setUsername(ConversationUtil.generateIdentifier(uuid, genID));
            msg.setProperty("EmbeddedKeyCallbackRef", (Object)dkcbHandler);
            msg.setProperty("action", (Object)"Encrypt");
            WSDoAllSender wsd = new WSDoAllSender();
            wsd.invoke(msg);
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (ConversationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Crypto loadEncryptionCrypto() throws AxisFault {
        Crypto crypto = null;
        String encPropFile = "crypto.properties";
        crypto = CryptoFactory.getInstance(encPropFile);
        return crypto;
    }
}

