/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axis.AxisFault;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.util.StringUtil;
import org.apache.xml.security.c14n.Canonicalizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AxisUtil {
    public static SOAPMessage toSOAPMessage(Document doc) throws Exception {
        Canonicalizer c14n = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] canonicalMessage = c14n.canonicalizeSubtree((Node)doc);
        ByteArrayInputStream in = new ByteArrayInputStream(canonicalMessage);
        MessageFactory factory = MessageFactory.newInstance();
        return factory.createMessage(null, (InputStream)in);
    }

    public static SOAPMessage updateSOAPMessage(Document doc, SOAPMessage message) throws Exception {
        DOMSource domSource = new DOMSource(doc);
        message.getSOAPPart().setContent((Source)domSource);
        return message;
    }

    public static SOAPHeaderElement getSecurityHeader(SOAPEnvelope env, String actor) throws SOAPException {
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return null;
        }
        Iterator headerElements = header.examineHeaderElements(actor);
        while (headerElements.hasNext()) {
            SOAPHeaderElement he = (SOAPHeaderElement)headerElements.next();
            Name nm = he.getElementName();
            if (!nm.getLocalName().equalsIgnoreCase("Security") || !nm.getURI().equalsIgnoreCase(WSConstants.WSSE_NS)) continue;
            return he;
        }
        return null;
    }

    public static int decodeAction(String action, Vector actions) throws AxisFault {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions.add(new Integer(256));
                continue;
            }
            throw new AxisFault("WSDoAllSender: Unknown action defined" + single[i]);
        }
        return doAction;
    }
}

