/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class ConversationUtil {
    private static final String ID_SEPARATER = "$$$$";

    public String generateNonce(int length) {
        String nonce = "";
        Random nonceIntGen = new Random();
        String allChars = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz/=1234567890";
        for (int i = 0; i <= length; ++i) {
            float tempVal = nonceIntGen.nextFloat();
            int lengthOfCharSet = allChars.length() - 1;
            int charAt = Math.round((float)lengthOfCharSet * tempVal);
            nonce = nonce + allChars.charAt(charAt);
        }
        return nonce;
    }

    public static String getDerivedKeyTokenId(String identifier) {
        return ConversationUtil.getUuidAndDerivedKeyTokenId(identifier)[1];
    }

    public static String getUuid(String identifier) {
        return ConversationUtil.getUuidAndDerivedKeyTokenId(identifier)[0];
    }

    public static String[] getUuidAndDerivedKeyTokenId(String identifier) {
        String[] returnValue = new String[2];
        int uuidEnd = identifier.indexOf(ID_SEPARATER);
        returnValue[0] = identifier.substring(0, uuidEnd);
        returnValue[1] = identifier.substring(uuidEnd + ID_SEPARATER.length(), identifier.length());
        return returnValue;
    }

    public static String generateIdentifier(String uuid, String derivedKeyTokenId) {
        return uuid + ID_SEPARATER + derivedKeyTokenId;
    }

    public static String genericID() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            int i = random.nextInt(2367);
            return String.valueOf(i);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

