/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation;

import java.util.Hashtable;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.ConversationSession;
import org.apache.ws.security.conversation.ConversationUtil;
import org.apache.ws.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.security.message.token.SecurityTokenReference;

public class KeyDerivator {
    private boolean useFixedSizeKeys = true;
    private long keySize = 16L;

    public KeyDerivator(boolean useFixedSizeKeys, long keySize) {
        this.useFixedSizeKeys = useFixedSizeKeys;
        this.keySize = keySize;
    }

    public String generateKey(Hashtable sessionTable, String identifier) throws WSSecurityException, ConversationException, WSSecurityException {
        String[] uuidAndDerivedKeyTokenId = ConversationUtil.getUuidAndDerivedKeyTokenId(identifier);
        ConversationSession convSession = (ConversationSession)sessionTable.get(uuidAndDerivedKeyTokenId[0]);
        int freq = convSession.getContextInfo().getFrequency();
        if (freq == 0) {
            return convSession.getContextInfo().getSharedSecret().toString();
        }
        return this.deriveKey(convSession, uuidAndDerivedKeyTokenId[1]);
    }

    private String deriveKey(ConversationSession convSession, String derivedKeyTokenId) throws WSSecurityException, ConversationException {
        DerivedKeyInfo dkInfo = (DerivedKeyInfo)convSession.getDerivedKeys().get(derivedKeyTokenId);
        SecurityTokenReference secTokRef = dkInfo.getSecurityTokenReference();
        if (secTokRef != null) {
            String contextIdentifier = convSession.getContextInfo().getIdentifier();
            if (secTokRef.getReference().getURI().equals(contextIdentifier)) {
                return this.deriveTokenFromContext(convSession, dkInfo);
            }
        } else {
            return this.deriveTokenFromContext(convSession, dkInfo);
        }
        return "ThisIsNotDoneYet";
    }

    private String deriveTokenFromContext(ConversationSession convSession, DerivedKeyInfo dkInfo) throws ConversationException {
        String secret = convSession.getContextInfo().getSharedSecret().toString();
        if (this.useFixedSizeKeys || dkInfo.getLength() == -1L) {
            // empty if block
        }
        if (dkInfo.getGeneration() != -1) {
            // empty if block
        }
        return "";
    }

    public void useFixedSizeKeys(boolean usage) {
    }

    public void useFixedSizeKeys(boolean usage, long length) {
    }
}

