/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.message.info;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.message.token.RequestedProofToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;

public class SecurityContextInfo {
    private byte[] sharedSecret;
    private String expiration;
    private Date expirationDate;
    private String identifier;
    private int frequency;

    public SecurityContextInfo(SecurityContextToken securityContextToken, RequestedProofToken requestedProofToken, int frequency) throws WSSecurityException {
        this.sharedSecret = requestedProofToken.getSharedSecret();
        this.setExpiration(securityContextToken.getExpires());
        this.identifier = securityContextToken.getIdentifier();
        this.frequency = frequency;
    }

    public SecurityContextInfo(byte[] sharedSecret, String expiration, int frequency) throws WSSecurityException {
        this.sharedSecret = sharedSecret;
        this.setExpiration(expiration);
        this.frequency = frequency;
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public byte[] getSharedSecretAsByteArray() {
        return this.sharedSecret;
    }

    public String getexpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) throws WSSecurityException {
        this.expiration = expiration;
        this.expirationDate = this.getDate(expiration);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public boolean isExpired() throws WSSecurityException {
        Calendar rightNow = Calendar.getInstance();
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = this.getDate(zulu.format(rightNow.getTime()));
        boolean isExpired = this.expirationDate.before(date);
        return isExpired;
    }

    private Date getDate(String strDate) throws WSSecurityException {
        Date date;
        System.out.println("Date is ::" + strDate);
        try {
            String[] dateTimeSplits = strDate.split("T");
            String strDatePart = dateTimeSplits[0].trim();
            String strTimePart = dateTimeSplits[1].trim();
            String[] dateSplits = strDatePart.split("-");
            String sYear = dateSplits[0].trim();
            String sMonth = dateSplits[1].trim();
            String sDate = dateSplits[2].trim();
            String[] timeSplits = strTimePart.split(":");
            String sHr = timeSplits[0].trim();
            String sMin = timeSplits[1].trim();
            String sSec = timeSplits[2].replace('Z', ' ').trim();
            date = new Date(Integer.parseInt(sYear), Integer.parseInt(sMonth), Integer.parseInt(sDate), Integer.parseInt(sHr), Integer.parseInt(sMin), Integer.parseInt(sSec));
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "Can not convert to a date");
        }
        return date;
    }

    public void setSharedSecret(byte[] bs) {
        this.sharedSecret = bs;
    }
}

