/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSBaseMessage {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSBaseMessage == null ? (class$org$apache$ws$security$message$WSBaseMessage = WSBaseMessage.class$("org.apache.ws.security.message.WSBaseMessage")) : class$org$apache$ws$security$message$WSBaseMessage).getName());
    protected String actor = null;
    protected boolean mustunderstand = true;
    protected String user = null;
    protected String password = null;
    protected int keyIdentifierType = 2;
    protected Vector parts = null;
    protected int timeToLive = 300;
    protected boolean doDebug = false;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSBaseMessage;

    public WSBaseMessage() {
    }

    public WSBaseMessage(String actor) {
        this.setActor(actor);
    }

    public WSBaseMessage(String actor, boolean mu) {
        this.setActor(actor);
        this.setMustUnderstand(mu);
    }

    public void setActor(String act) {
        this.actor = act;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public void setParts(Vector parts) {
        this.parts = parts;
    }

    public void setMustUnderstand(boolean mu) {
        this.mustunderstand = mu;
    }

    public void setKeyIdentifierType(int keyIdType) {
        this.keyIdentifierType = keyIdType;
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    protected String setBodyID(Document doc) throws Exception {
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element bodyElement = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI());
        if (bodyElement == null) {
            throw new Exception("SOAP Body Element node not found");
        }
        return this.setWsuId(bodyElement);
    }

    protected String setWsuId(Element bodyElement) {
        String prefix = WSSecurityUtil.setNamespace(bodyElement, WSConstants.WSU_NS, "wsu");
        String id = bodyElement.getAttributeNS(WSConstants.WSU_NS, "Id");
        if (id == null || id.length() == 0) {
            id = "id-" + Integer.toString(bodyElement.hashCode());
            bodyElement.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
        }
        return id;
    }

    public void setUserInfo(String user, String password) {
        this.user = user;
        this.password = password;
    }

    protected Element insertSecurityHeader(Document doc) {
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element securityHeader = WSSecurityUtil.getSecurityHeader(doc, this.actor, soapConstants);
        if (securityHeader == null) {
            securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), true);
            String soapPrefix = WSSecurityUtil.getPrefixNS(soapConstants.getEnvelopeURI(), securityHeader);
            if (this.actor != null && this.actor.length() > 0) {
                securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + soapConstants.getRoleAttributeQName().getLocalPart(), this.actor);
            }
            if (this.mustunderstand) {
                securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + "mustUnderstand", soapConstants.getMustunderstand());
            }
        }
        return securityHeader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

