/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.cert.X509Certificate;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PKIPathSecurity
extends BinarySecurity {
    public static final String TYPE = WSConstants.WSSE_NS + "#X509PKIPathv1";

    public PKIPathSecurity(Element elem) throws WSSecurityException {
        super(elem);
        if (!this.getValueType().equals(TYPE)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{TYPE, this.getValueType()});
        }
    }

    public PKIPathSecurity(Document doc) {
        super(doc);
        this.setValueType(TYPE);
    }

    public X509Certificate[] getX509Certificates(boolean reverse, Crypto crypto) throws WSSecurityException {
        byte[] data = this.getToken();
        if (data == null) {
            return null;
        }
        X509Certificate[] certs = null;
        certs = crypto.getX509Certificates(data, reverse);
        return certs;
    }

    public void setX509Certificates(X509Certificate[] certs, boolean reverse, Crypto crypto) throws WSSecurityException {
        if (certs == null) {
            throw new WSSecurityException(0, "noCert");
        }
        byte[] data = crypto.getCertificateData(reverse, certs);
        this.setToken(data);
    }
}

