/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UsernameToken {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$token$UsernameToken == null ? (class$org$apache$ws$security$message$token$UsernameToken = UsernameToken.class$("org.apache.ws.security.message.token.UsernameToken")) : class$org$apache$ws$security$message$token$UsernameToken).getName());
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "UsernameToken");
    public static final String PASSWORD_TYPE = "passwordType";
    protected Element element = null;
    protected Element elementUsername = null;
    protected Element elementPassword = null;
    protected Element elementNonce = null;
    protected Element elementCreated = null;
    protected boolean hashed = true;
    private static SecureRandom random = null;
    String password = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$UsernameToken;

    public UsernameToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementUsername = (Element)WSSecurityUtil.getDirectChild(this.element, "Username", WSConstants.WSSE_NS);
        this.elementPassword = (Element)WSSecurityUtil.getDirectChild(this.element, "Password", WSConstants.WSSE_NS);
        this.elementNonce = (Element)WSSecurityUtil.getDirectChild(this.element, "Nonce", WSConstants.WSSE_NS);
        this.elementCreated = (Element)WSSecurityUtil.getDirectChild(this.element, "Created", WSConstants.WSU_NS);
        if (this.elementUsername == null || this.elementPassword == null) {
            throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
        }
        String type = this.elementPassword.getAttribute("Type");
        if (type.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
            this.hashed = true;
            if (this.elementNonce == null || this.elementCreated == null) {
                throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
            }
        } else {
            this.hashed = false;
        }
    }

    public UsernameToken(Document doc) {
        this(doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    public UsernameToken(Document doc, String passwordType) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:UsernameToken");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSSE_NS, "wsse");
        this.elementUsername = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Username");
        WSSecurityUtil.setNamespace(this.elementUsername, WSConstants.WSSE_NS, "wsse");
        this.elementUsername.appendChild(doc.createTextNode(""));
        this.element.appendChild(this.elementUsername);
        this.elementPassword = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Password");
        WSSecurityUtil.setNamespace(this.elementPassword, WSConstants.WSSE_NS, "wsse");
        this.elementPassword.appendChild(doc.createTextNode(""));
        this.element.appendChild(this.elementPassword);
        if (passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) {
            this.hashed = false;
        } else {
            this.hashed = true;
            this.addNonce(doc);
            this.addCreated(doc);
        }
    }

    public void addNonce(Document doc) {
        if (this.elementNonce != null) {
            return;
        }
        byte[] nonceValue = new byte[16];
        random.nextBytes(nonceValue);
        this.elementNonce = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Nonce");
        WSSecurityUtil.setNamespace(this.elementNonce, WSConstants.WSSE_NS, "wsse");
        this.elementNonce.appendChild(doc.createTextNode(Base64.encode((byte[])nonceValue)));
        this.element.appendChild(this.elementNonce);
    }

    public void addCreated(Document doc) {
        if (this.elementCreated != null) {
            return;
        }
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        this.elementCreated = doc.createElementNS(WSConstants.WSU_NS, "wsu:Created");
        WSSecurityUtil.setNamespace(this.elementCreated, WSConstants.WSU_NS, "wsu");
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementCreated);
    }

    public String getName() {
        if (this.elementUsername != null) {
            return this.getFirstNode(this.elementUsername).getData();
        }
        return null;
    }

    public void setName(String name) {
        Text node = this.getFirstNode(this.elementUsername);
        node.setData(name);
    }

    public String getNonce() {
        if (this.elementNonce != null) {
            return this.getFirstNode(this.elementNonce).getData();
        }
        return null;
    }

    public void setNonce(String nonce) {
        Text node = this.getFirstNode(this.elementNonce);
        node.setData(nonce);
    }

    public String getCreated() {
        if (this.elementCreated != null) {
            return this.getFirstNode(this.elementCreated).getData();
        }
        return null;
    }

    public void setCreated(String created) {
        Text node = this.getFirstNode(this.elementCreated);
        node.setData(created);
    }

    public String getPassword() {
        Text node = this.getFirstNode(this.elementPassword);
        if (node == null) {
            return null;
        }
        return node.getData();
    }

    public boolean isHashed() {
        return this.hashed;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
        if (pwd == null) {
            throw new IllegalArgumentException("pwd == null");
        }
        Text node = this.getFirstNode(this.elementPassword);
        try {
            if (!this.hashed) {
                node.setData(pwd);
                this.elementPassword.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            } else {
                byte[] b1 = Base64.decode((String)this.getNonce());
                byte[] b2 = this.getCreated().getBytes("UTF-8");
                byte[] b3 = pwd.getBytes("UTF-8");
                byte[] b4 = new byte[b1.length + b2.length + b3.length];
                int i = 0;
                int count = 0;
                for (i = 0; i < b1.length; ++i) {
                    b4[count++] = b1[i];
                }
                for (i = 0; i < b2.length; ++i) {
                    b4[count++] = b2[i];
                }
                for (i = 0; i < b3.length; ++i) {
                    b4[count++] = b3[i];
                }
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                sha.reset();
                sha.update(b4);
                node.setData(Base64.encode((byte[])sha.digest()));
                this.elementPassword.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String doPasswordDigest(String nonce, String created, String password) {
        String passwdDigest = null;
        try {
            byte[] b1 = Base64.decode((String)nonce);
            byte[] b2 = created.getBytes("UTF-8");
            byte[] b3 = password.getBytes("UTF-8");
            byte[] b4 = new byte[b1.length + b2.length + b3.length];
            int i = 0;
            int count = 0;
            for (i = 0; i < b1.length; ++i) {
                b4[count++] = b1[i];
            }
            for (i = 0; i < b2.length; ++i) {
                b4[count++] = b2[i];
            }
            for (i = 0; i < b3.length; ++i) {
                b4[count++] = b3[i];
            }
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(b4);
            passwdDigest = Base64.encode((byte[])sha.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return passwdDigest;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS(WSConstants.WSU_NS, "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, WSConstants.WSU_NS, "wsu");
        this.element.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
    }

    public byte[] getSecretKey() {
        byte[] key = null;
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] password = this.password.getBytes("UTF-8");
            byte[] label = "WS-Security".getBytes("UTF-8");
            byte[] nonce = Base64.decode((String)this.getNonce());
            byte[] created = this.getCreated().getBytes("UTF-8");
            byte[] seed = new byte[label.length + nonce.length + created.length];
            int i = 0;
            int count = 0;
            for (i = 0; i < label.length; ++i) {
                seed[count++] = label[i];
            }
            for (i = 0; i < nonce.length; ++i) {
                seed[count++] = nonce[i];
            }
            for (i = 0; i < created.length; ++i) {
                seed[count++] = created[i];
            }
            key = UsernameToken.P_hash(password, seed, mac, 128);
            System.out.println("password   :" + Base64.encode((byte[])password));
            System.out.println("label      :" + Base64.encode((byte[])label));
            System.out.println("nonce      :" + Base64.encode((byte[])nonce));
            System.out.println("created    :" + Base64.encode((byte[])created));
            System.out.println("seed       :" + Base64.encode((byte[])seed));
            System.out.println("Key        :" + Base64.encode((byte[])key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private static byte[] P_hash(byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] A = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = UsernameToken.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
    }
}

