/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSignEnvelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestWSSecurity8
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog((Class)(class$wssec$TestWSSecurity8 == null ? (class$wssec$TestWSSecurity8 = TestWSSecurity8.class$("wssec.TestWSSecurity8")) : class$wssec$TestWSSecurity8));
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance();
    MessageContext msgContext;
    Message message;
    static /* synthetic */ Class class$wssec$TestWSSecurity8;

    public TestWSSecurity8(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity8 == null ? (class$wssec$TestWSSecurity8 = TestWSSecurity8.class$("wssec.TestWSSecurity8")) : class$wssec$TestWSSecurity8);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecurity8.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient((EngineConfiguration)new NullProvider());
        this.msgContext = new MessageContext((AxisEngine)tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message((Object)in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testSigningEncryptionIS3DES() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        WSEncryptBody encrypt = new WSEncryptBody();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        encrypt.setKeyIdentifierType(2);
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        WSSignEnvelope sign = new WSSignEnvelope();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        log.info((Object)"Before Sign/Encryption....");
        Document doc = unsignedEnvelope.getAsDocument();
        Document signedDoc = sign.build(doc, crypto);
        Document encryptedSignedDoc = encrypt.build(signedDoc, crypto);
        Message encryptedMsg = (Message)AxisUtil.toSOAPMessage(encryptedSignedDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            XMLUtils.PrettyElementToWriter((Element)encryptedMsg.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
        String s = encryptedMsg.getSOAPPartAsString();
        ((SOAPPart)this.message.getSOAPPart()).setCurrentMessage((Object)s, 1);
        Document encryptedSignedDoc1 = this.message.getSOAPEnvelope().getAsDocument();
        log.info((Object)"After Sign/Encryption....");
        this.verify(encryptedSignedDoc1);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, this, crypto);
        AxisUtil.updateSOAPMessage(doc, (SOAPMessage)this.message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Verfied and decrypted message:");
            XMLUtils.PrettyElementToWriter((Element)this.message.getSOAPEnvelope().getAsDOM(), (Writer)new PrintWriter(System.out));
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

