/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.junit;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.InputSource;

public class ClaesLarssonTest
extends TestCase {
    public ClaesLarssonTest(String pName) {
        super(pName);
    }

    public void testParse() throws Exception {
        XSParser xsp = new XSParser();
        xsp.setValidating(false);
        String xmlFileName = "examples/xs/Claes_Larsson/schema.xsd";
        URL xmlSystemId = new File(xmlFileName).toURL();
        InputSource isource = new InputSource(new FileInputStream(xmlFileName));
        isource.setSystemId(xmlSystemId.toString());
        XSSchema schema = xsp.parse(isource);
        XSElement[] elements = schema.getElements();
        ClaesLarssonTest.assertEquals((int)154, (int)elements.length);
        XSElement localTransformationElement = schema.getElement(new XsQName((String)null, "local_transformation"));
        ClaesLarssonTest.assertNotNull((Object)localTransformationElement);
        XSType localTransformationType = localTransformationElement.getType();
        ClaesLarssonTest.assertTrue((!localTransformationType.isSimple() ? 1 : 0) != 0);
        XSComplexType localTransformationComplexType = localTransformationType.getComplexType();
        ClaesLarssonTest.assertTrue((!localTransformationComplexType.hasSimpleContent() ? 1 : 0) != 0);
        XSParticle localTransformationParticle = localTransformationComplexType.getParticle();
        XSGroup localTransformationGroup = localTransformationParticle.getGroup();
        XSParticle[] particles = localTransformationGroup.getParticles();
        ClaesLarssonTest.assertEquals((int)0, (int)particles[0].getMinOccurs());
        ClaesLarssonTest.assertEquals((int)1, (int)particles[0].getMaxOccurs());
    }
}

