/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base16;

public class DSRecord
extends Record {
    public static final byte SHA1_DIGEST_ID = 1;
    private static DSRecord member = new DSRecord();
    private int footprint;
    private int alg;
    private int digestid;
    private byte[] digest;

    private DSRecord() {
    }

    private DSRecord(Name name, int dclass, int ttl) {
        super(name, 43, dclass, ttl);
    }

    static DSRecord getMember() {
        return member;
    }

    public DSRecord(Name name, int dclass, int ttl, int footprint, int alg, int digestid, byte[] digest) {
        this(name, dclass, ttl);
        if (footprint < 0 || footprint > 65535) {
            throw new IllegalArgumentException("invalid footprint: " + footprint);
        }
        if (alg < 0 || alg > 255) {
            throw new IllegalArgumentException("invalid algorithm: " + alg);
        }
        if (digestid < 0 || digestid > 255) {
            throw new IllegalArgumentException("invalid digest id: " + digestid);
        }
        this.footprint = footprint;
        this.alg = alg;
        this.digestid = digestid;
        this.digest = digest;
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        DSRecord rec = new DSRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.footprint = in.readUnsignedShort();
        rec.alg = in.readUnsignedByte();
        rec.digestid = in.readUnsignedByte();
        if (length > 4) {
            rec.digest = new byte[length - 4];
            in.read(rec.digest);
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        DSRecord rec = new DSRecord(name, dclass, ttl);
        rec.footprint = st.getUInt16();
        rec.alg = (byte)st.getUInt8();
        rec.digestid = (byte)st.getUInt8();
        rec.digest = base16.fromString(Record.remainingStrings(st));
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.footprint);
        sb.append(" ");
        sb.append(this.alg);
        sb.append(" ");
        sb.append(this.digestid);
        if (this.digest != null) {
            sb.append(" ");
            sb.append(base16.toString(this.digest));
        }
        return sb.toString();
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public int getDigestID() {
        return this.digestid;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public int getFootprint() {
        return this.footprint;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        out.writeShort(this.footprint);
        out.writeByte(this.alg);
        out.writeByte(this.digestid);
        if (this.digest != null) {
            out.writeArray(this.digest);
        }
    }
}

