/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] servers = FindServer.servers();
        if (servers != null) {
            int i = 0;
            while (i < servers.length) {
                SimpleResolver r = new SimpleResolver(servers[i]);
                r.setTimeout(5);
                this.resolvers.add(r);
                ++i;
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] servers) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < servers.length) {
            SimpleResolver r = new SimpleResolver(servers[i]);
            r.setTimeout(5);
            this.resolvers.add(r);
            ++i;
        }
    }

    public ExtendedResolver(Resolver[] res) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < res.length) {
            this.resolvers.add(res[i]);
            ++i;
        }
    }

    public void setPort(int port) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setPort(port);
            ++i;
        }
    }

    public void setTCP(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTCP(flag);
            ++i;
        }
    }

    public void setIgnoreTruncation(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(flag);
            ++i;
        }
    }

    public void setEDNS(int level) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setEDNS(level);
            ++i;
        }
    }

    public void setTSIGKey(TSIG key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(key);
            ++i;
        }
    }

    public void setTSIGKey(Name name, byte[] key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    public void setTSIGKey(String name, String key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    public void setTSIGKey(String key) throws UnknownHostException {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(key);
            ++i;
        }
    }

    public void setTimeout(int secs) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(i)).setTimeout(secs);
            ++i;
        }
    }

    public Message send(Message query) throws IOException {
        Resolution res = new Resolution(this, query);
        return res.start();
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        Resolution res = new Resolution(this, query);
        res.startAsync(listener);
        return res;
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver r) {
        this.resolvers.add(r);
    }

    public void deleteResolver(Resolver r) {
        this.resolvers.remove(r);
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    private static class Resolution
    implements ResolverListener {
        Resolver[] resolvers;
        int[] sent;
        Object[] inprogress;
        int retries;
        int outstanding;
        boolean done;
        Message query;
        Message response;
        Exception exception;
        ResolverListener listener;

        public Resolution(ExtendedResolver eres, Message query) {
            List l = eres.resolvers;
            this.resolvers = l.toArray(new Resolver[l.size()]);
            if (eres.loadBalance) {
                int nresolvers = this.resolvers.length;
                int start = eres.lbStart++ % nresolvers;
                if (eres.lbStart > nresolvers) {
                    eres.lbStart %= nresolvers;
                }
                if (start > 0) {
                    Resolver[] shuffle = new Resolver[nresolvers];
                    int i = 0;
                    while (i < nresolvers) {
                        int pos = (i + start) % nresolvers;
                        shuffle[i] = this.resolvers[pos];
                        ++i;
                    }
                    this.resolvers = shuffle;
                }
            }
            this.sent = new int[this.resolvers.length];
            this.inprogress = new Object[this.resolvers.length];
            this.retries = eres.retries;
            this.query = query;
        }

        public void send(int n) {
            int n2 = n;
            this.sent[n2] = this.sent[n2] + 1;
            ++this.outstanding;
            this.inprogress[n] = this.resolvers[n].sendAsync(this.query, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Message start() throws IOException {
            block9: {
                try {
                    this.sent[0] = this.sent[0] + 1;
                    ++this.outstanding;
                    this.inprogress[0] = new Object();
                    return this.resolvers[0].send(this.query);
                }
                catch (Exception e) {
                    this.handleException(this.inprogress[0], e);
                    if (this.done) break block9;
                    var1_2 = this;
                    // MONITORENTER : var1_2
                    ** while (!this.done)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
lbl18:
                // 1 sources

                // MONITOREXIT : var1_2
            }
            if (this.response != null) {
                return this.response;
            }
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof RuntimeException == false) throw new RuntimeException("ExtendedResolver failure");
            throw (RuntimeException)this.exception;
        }

        public void startAsync(ResolverListener listener) {
            this.listener = listener;
            this.send(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(Object id, Message m) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message");
            }
            Resolution resolution = this;
            synchronized (resolution) {
                if (this.done) {
                    return;
                }
                this.response = m;
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    return;
                }
            }
            this.listener.receiveMessage(this, this.response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(Object id, Exception e) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: got" + e);
            }
            Resolution resolution = this;
            synchronized (resolution) {
                --this.outstanding;
                if (this.done) {
                    return;
                }
                int n = 0;
                while (n < this.inprogress.length) {
                    if (this.inprogress[n] == id) break;
                    ++n;
                }
                if (n == this.inprogress.length) {
                    return;
                }
                boolean startnext = false;
                boolean waiting = false;
                if (this.sent[n] == 1 && n < this.resolvers.length - 1) {
                    startnext = true;
                }
                if (e instanceof InterruptedIOException) {
                    if (this.sent[n] < this.retries) {
                        this.send(n);
                    }
                    if (this.exception == null) {
                        this.exception = e;
                    }
                } else if (e instanceof SocketException) {
                    if (this.exception == null || this.exception instanceof InterruptedIOException) {
                        this.exception = e;
                    }
                } else {
                    this.exception = e;
                }
                if (startnext) {
                    this.send(n + 1);
                }
                if (this.outstanding == 0) {
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
                if (!this.done) {
                    return;
                }
            }
            this.listener.handleException(this, this.exception);
        }
    }
}

