/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class HINFORecord
extends Record {
    private static HINFORecord member = new HINFORecord();
    private byte[] cpu;
    private byte[] os;

    private HINFORecord() {
    }

    private HINFORecord(Name name, int dclass, int ttl) {
        super(name, 13, dclass, ttl);
    }

    static HINFORecord getMember() {
        return member;
    }

    public HINFORecord(Name name, int dclass, int ttl, String cpu, String os) {
        this(name, dclass, ttl);
        try {
            this.cpu = Record.byteArrayFromString(cpu);
            this.os = Record.byteArrayFromString(os);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        HINFORecord rec = new HINFORecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.cpu = in.readStringIntoArray();
        rec.os = in.readStringIntoArray();
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        HINFORecord rec = new HINFORecord(name, dclass, ttl);
        try {
            rec.cpu = Record.byteArrayFromString(st.getString());
            rec.os = Record.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        return rec;
    }

    public String getCPU() {
        return Record.byteArrayToString(this.cpu, false);
    }

    public String getOS() {
        return Record.byteArrayToString(this.os, false);
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.cpu == null || this.os == null) {
            return;
        }
        out.writeArray(this.cpu, true);
        out.writeArray(this.os, true);
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cpu != null && this.os != null) {
            sb.append(Record.byteArrayToString(this.cpu, true));
            sb.append(" ");
            sb.append(Record.byteArrayToString(this.os, true));
        }
        return sb.toString();
    }
}

