/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Update;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Message
implements Cloneable {
    public static int MAXLENGTH = 65535;
    private Header header;
    private List[] sections = new List[4];
    private int size;
    private byte[] wireFormat;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private byte tsigerror;
    int tsigstart;
    int tsigState;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_FAILED = 3;
    private static Record[] emptyRecordArray = new Record[0];
    private static RRset[] emptyRRsetArray = new RRset[0];

    private Message(Header header) {
        this.header = header;
        this.wireFormat = null;
    }

    public Message(int id) {
        this(new Header(id));
    }

    public Message() {
        this(Header.randomID());
    }

    public static Message newQuery(Record r) {
        Message m = new Message();
        m.header.setOpcode((byte)0);
        m.header.setFlag(7);
        m.addRecord(r, 0);
        return m;
    }

    public static Message newUpdate(Name zone) {
        return new Update(zone);
    }

    Message(DataByteInputStream in) throws IOException {
        this(new Header(in));
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < this.header.getCount(i)) {
                int pos = in.getPos();
                Record rec = Record.fromWire(in, i);
                if (this.sections[i] == null) {
                    this.sections[i] = new LinkedList();
                }
                this.sections[i].add(rec);
                if (rec.getType() == 250) {
                    this.tsigstart = pos;
                }
                ++j;
            }
            ++i;
        }
        this.size = in.getPos();
    }

    public Message(byte[] b) throws IOException {
        this(new DataByteInputStream(b));
    }

    public void setHeader(Header h) {
        this.header = h;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record r, int section) {
        if (this.sections[section] == null) {
            this.sections[section] = new LinkedList();
        }
        this.sections[section].add(r);
        this.header.incCount(section);
    }

    public boolean removeRecord(Record r, int section) {
        if (this.sections[section] != null && this.sections[section].remove(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        this.sections[section] = null;
        this.header.setCount(section, 0);
    }

    public boolean findRecord(Record r, int section) {
        return this.sections[section] != null && this.sections[section].contains(r);
    }

    public boolean findRecord(Record r) {
        int i = 1;
        while (i <= 3) {
            if (this.sections[i] != null && this.sections[i].contains(r)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean findRRset(Name name, int type, int section) {
        if (this.sections[section] == null) {
            return false;
        }
        int i = 0;
        while (i < this.sections[section].size()) {
            Record r = (Record)this.sections[section].get(i);
            if (r.getType() == type && name.equals(r.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public Record getQuestion() {
        if (this.sections[0] == null) {
            return null;
        }
        try {
            return (Record)this.sections[0].get(0);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        List l = this.sections[3];
        Record rec = (Record)l.get(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    public boolean isSigned() {
        return this.tsigState == 1 || this.tsigState == 3;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        Record[] additional = this.getSectionArray(3);
        int i = 0;
        while (i < additional.length) {
            if (additional[i] instanceof OPTRecord) {
                return (OPTRecord)additional[i];
            }
            ++i;
        }
        return null;
    }

    public short getRcode() {
        short rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode = (short)(rcode + (short)(opt.getExtendedRcode() << 4));
        }
        return rcode;
    }

    public Enumeration getSection(int section) {
        if (this.sections[section] != null) {
            return Collections.enumeration(this.sections[section]);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Record[] getSectionArray(int section) {
        if (this.sections[section] == null) {
            return emptyRecordArray;
        }
        List l = this.sections[section];
        return l.toArray(new Record[l.size()]);
    }

    private static boolean sameSet(Record r1, Record r2) {
        return r1.getRRsetType() == r2.getRRsetType() && r1.getDClass() == r2.getDClass() && r1.getName().equals(r2.getName());
    }

    private static boolean sameSet(RRset set, Record rec) {
        return Message.sameSet(set.first(), rec);
    }

    public RRset[] getSectionRRsets(int section) {
        if (this.sections[section] == null) {
            return emptyRRsetArray;
        }
        LinkedList<RRset> sets = new LinkedList<RRset>();
        Record[] recs = this.getSectionArray(section);
        HashSet<Name> hash = new HashSet<Name>();
        int i = 0;
        while (i < recs.length) {
            Name name = recs[i].getName();
            boolean newset = true;
            if (hash.contains(name)) {
                int j = sets.size() - 1;
                while (j >= 0) {
                    RRset set = (RRset)sets.get(j);
                    if (set.getType() == recs[i].getRRsetType() && set.getDClass() == recs[i].getDClass() && set.getName().equals(name)) {
                        set.addRR(recs[i]);
                        newset = false;
                        break;
                    }
                    --j;
                }
            }
            if (newset) {
                RRset set = new RRset();
                sets.add(set);
                set.addRR(recs[i]);
                hash.add(name);
            }
            ++i;
        }
        return sets.toArray(new RRset[sets.size()]);
    }

    void toWire(DataByteOutputStream out) {
        this.header.toWire(out);
        Compression c = new Compression();
        int i = 0;
        while (i < 4) {
            if (this.sections[i] != null) {
                int j = 0;
                while (j < this.sections[i].size()) {
                    Record rec = (Record)this.sections[i].get(j);
                    rec.toWire(out, i, c);
                    ++j;
                }
            }
            ++i;
        }
    }

    private int sectionToWire(DataByteOutputStream out, int section, Compression c, int maxLength) {
        int n = this.sections[section].size();
        int pos = out.getPos();
        int rendered = 0;
        Record lastrec = null;
        int i = 0;
        while (i < n) {
            Record rec = (Record)this.sections[section].get(i);
            if (lastrec != null && !Message.sameSet(rec, lastrec)) {
                pos = out.getPos();
                rendered = i;
            }
            lastrec = rec;
            rec.toWire(out, section, c);
            if (out.getPos() > maxLength) {
                out.setPos(pos);
                return n - rendered;
            }
            ++i;
        }
        return 0;
    }

    private boolean toWire(DataByteOutputStream out, int maxLength) {
        if (maxLength < 12) {
            return false;
        }
        Header newheader = null;
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        int startpos = out.getPos();
        this.header.toWire(out);
        Compression c = new Compression();
        int i = 0;
        while (i < 4) {
            int skipped;
            if (this.sections[i] != null && (skipped = this.sectionToWire(out, i, c, tempMaxLength)) != 0) {
                if (i == 3) break;
                if (newheader == null) {
                    newheader = (Header)this.header.clone();
                }
                newheader.setFlag(6);
                int count = newheader.getCount(i);
                newheader.setCount(i, count - skipped);
                int j = i + 1;
                while (j < 4) {
                    newheader.setCount(j, 0);
                    ++j;
                }
                int pos = out.getPos();
                out.setPos(startpos);
                newheader.toWire(out);
                out.setPos(pos);
                break;
            }
            ++i;
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            if (newheader == null) {
                newheader = (Header)this.header.clone();
            }
            tsigrec.toWire(out, 3, c);
            newheader.incCount(3);
            int pos = out.getPos();
            out.setPos(startpos);
            newheader.toWire(out);
            out.setPos(pos);
        }
        return true;
    }

    public byte[] toWire() {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out);
        this.size = out.getPos();
        return out.toByteArray();
    }

    public byte[] toWire(int maxLength) {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out, maxLength);
        this.size = out.getPos();
        return out.toByteArray();
    }

    public void setTSIG(TSIG key, byte error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int i) {
        if (i > 3) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Record[] records = this.getSectionArray(i);
        int j = 0;
        while (j < records.length) {
            Record rec = records[j];
            if (i == 0) {
                sb.append(";;\t" + rec.name);
                sb.append(", type = " + Type.string(rec.type));
                sb.append(", class = " + DClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append("\n");
            ++j;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode()) + "\n");
        } else {
            sb.append(this.header + "\n");
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        int i = 0;
        while (i < 4) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; " + Section.longString(i) + ":\n");
            } else {
                sb.append(";; " + Section.updString(i) + ":\n");
            }
            sb.append(this.sectionToString(i) + "\n");
            ++i;
        }
        sb.append(";; Message size: " + this.numBytes() + " bytes");
        return sb.toString();
    }

    public Object clone() {
        Message m = new Message();
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i] != null) {
                m.sections[i] = new LinkedList(this.sections[i]);
            }
            ++i;
        }
        m.header = (Header)this.header.clone();
        m.size = this.size;
        return m;
    }
}

