/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class NAPTRRecord
extends Record {
    private static NAPTRRecord member = new NAPTRRecord();
    private short order;
    private short preference;
    private byte[] flags;
    private byte[] service;
    private byte[] regexp;
    private Name replacement;

    private NAPTRRecord() {
    }

    private NAPTRRecord(Name name, int dclass, int ttl) {
        super(name, 35, dclass, ttl);
    }

    static NAPTRRecord getMember() {
        return member;
    }

    public NAPTRRecord(Name name, int dclass, int ttl, int order, int preference, String flags, String service, String regexp, Name replacement) {
        this(name, dclass, ttl);
        this.order = (short)order;
        this.preference = (short)preference;
        try {
            this.flags = Record.byteArrayFromString(flags);
            this.service = Record.byteArrayFromString(service);
            this.regexp = Record.byteArrayFromString(regexp);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (!replacement.isAbsolute()) {
            throw new RelativeNameException(replacement);
        }
        this.replacement = replacement;
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        NAPTRRecord rec = new NAPTRRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.order = (short)in.readUnsignedShort();
        rec.preference = (short)in.readUnsignedShort();
        rec.flags = in.readStringIntoArray();
        rec.service = in.readStringIntoArray();
        rec.regexp = in.readStringIntoArray();
        rec.replacement = new Name(in);
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        NAPTRRecord rec = new NAPTRRecord(name, dclass, ttl);
        rec.order = (short)st.getUInt16();
        rec.preference = (short)st.getUInt16();
        try {
            rec.flags = Record.byteArrayFromString(st.getString());
            rec.service = Record.byteArrayFromString(st.getString());
            rec.regexp = Record.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        rec.replacement = st.getName(origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.replacement != null) {
            sb.append(this.order);
            sb.append(" ");
            sb.append(this.preference);
            sb.append(" ");
            sb.append(Record.byteArrayToString(this.flags, true));
            sb.append(" ");
            sb.append(Record.byteArrayToString(this.service, true));
            sb.append(" ");
            sb.append(Record.byteArrayToString(this.regexp, true));
            sb.append(" ");
            sb.append(this.replacement);
        }
        return sb.toString();
    }

    public short getOrder() {
        return this.order;
    }

    public short getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return Record.byteArrayToString(this.flags, false);
    }

    public String getService() {
        return Record.byteArrayToString(this.service, false);
    }

    public String getRegexp() {
        return Record.byteArrayToString(this.regexp, false);
    }

    public Name getReplacement() {
        return this.replacement;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.replacement == null && this.regexp == null) {
            return;
        }
        out.writeShort(this.order);
        out.writeShort(this.preference);
        out.writeArray(this.flags, true);
        out.writeArray(this.service, true);
        out.writeArray(this.regexp, true);
        this.replacement.toWire(out, null, canonical);
    }

    public Name getAdditionalName() {
        return this.replacement;
    }
}

